/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageDialect;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFile;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import junit.framework.Assert;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightVirtualFile
extends DeprecatedVirtualFile {
    private FileType myFileType;
    private CharSequence myContent = "";
    private String myName = "";
    private long myModStamp = LocalTimeCounter.currentTime();
    private boolean myIsWritable = true;
    private Language myLanguage;
    private VirtualFileListener myListener = null;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();

    public LightVirtualFile() {
        this("");
    }

    public LightVirtualFile(@NonNls String name) {
        this(name, "");
    }

    public LightVirtualFile(@NonNls String name, CharSequence content) {
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text) {
        this(name, fileType, text, LocalTimeCounter.currentTime());
    }

    public LightVirtualFile(VirtualFile original, CharSequence text, long modificationStamp) {
        this(original.getName(), original.getFileType(), text, modificationStamp);
        this.setCharset(original.getCharset());
    }

    public LightVirtualFile(String name, FileType fileType, CharSequence text, long modificationStamp) {
        this.myName = name;
        this.myFileType = fileType;
        this.myContent = text;
        this.myModStamp = modificationStamp;
        if (fileType instanceof LanguageFileType) {
            this.setCharset(((LanguageFileType)fileType).extractCharsetFromFileContent(null, this, ((Object)text).toString()));
        }
    }

    public LightVirtualFile(String name, Language language, CharSequence text) {
        this.myName = name;
        Language typeLanguage = language instanceof LanguageDialect ? ((LanguageDialect)language).getBaseLanguage() : language;
        for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType) || ((LanguageFileType)fileType).getLanguage() != typeLanguage) continue;
            this.myFileType = fileType;
            break;
        }
        if (this.myFileType == null) {
            this.myFileType = language.getAssociatedFileType();
        }
        if (this.myFileType == null) {
            this.myFileType = FileTypeManager.getInstance().getFileTypeByFileName(name);
        }
        this.myContent = text;
        this.myModStamp = LocalTimeCounter.currentTime();
        this.myLanguage = language;
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VirtualFileSystem getFileSystem() {
        MyVirtualFileSystem myVirtualFileSystem = ourFileSystem;
        if (myVirtualFileSystem == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightVirtualFile.getFileSystem must not return null");
        }
        return myVirtualFileSystem;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType != null ? this.myFileType : super.getFileType();
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightVirtualFile.getFileType must not return null");
        }
        return fileType;
    }

    public String getPath() {
        return "/" + this.getName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightVirtualFile.getName must not return null");
        }
        return string;
    }

    public boolean isWritable() {
        return this.myIsWritable;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException("Cannot get input stream");
    }

    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        return new ByteArrayOutputStream(){

            public void close() {
                LightVirtualFile.this.myModStamp = newModificationStamp;
                LightVirtualFile.this.myContent = this.toString();
            }
        };
    }

    public byte[] contentsToByteArray() throws IOException {
        Charset charset = this.getCharset();
        String s = ((Object)this.getContent()).toString();
        return charset != null ? s.getBytes(charset.name()) : s.getBytes();
    }

    public long getModificationStamp() {
        return this.myModStamp;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
            return 0L;
        }
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public void setContent(Object requestor, CharSequence content, boolean fireEvent) {
        this.myContent = content;
        if (fireEvent) {
            long oldStamp = this.myModStamp;
            this.myModStamp = LocalTimeCounter.currentTime();
            this.myListener.contentsChanged(new VirtualFileEvent(requestor, this, null, oldStamp, this.myModStamp));
        }
    }

    public void setWritable(boolean b) {
        this.myIsWritable = b;
    }

    public void rename(Object requestor, @NotNull String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile.rename must not be null");
        }
        this.myName = newName;
    }

    public CharSequence getContent() {
        return this.myContent;
    }

    private static class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem {
        @NonNls
        private static final String PROTOCOL = "mock";

        private MyVirtualFileSystem() {
        }

        public String getProtocol() {
            return PROTOCOL;
        }

        @Nullable
        public VirtualFile findFileByPath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/LightVirtualFile$MyVirtualFileSystem.findFileByPath must not be null");
            }
            return null;
        }

        public void refresh(boolean asynchronous) {
        }

        @Nullable
        public VirtualFile refreshAndFindFileByPath(String path) {
            return null;
        }

        public void deleteFile(Object requestor, VirtualFile vFile) throws IOException {
        }

        public void moveFile(Object requestor, VirtualFile vFile, VirtualFile newParent) throws IOException {
        }

        public VirtualFile copyFile(Object requestor, VirtualFile vFile, VirtualFile newParent, String copyName) throws IOException {
            throw new IOException("Cannot copy files");
        }

        public void renameFile(Object requestor, VirtualFile vFile, String newName) throws IOException {
        }

        public VirtualFile createChildFile(Object requestor, VirtualFile vDir, String fileName) throws IOException {
            throw new IOException("Cannot create files");
        }

        public VirtualFile createChildDirectory(Object requestor, VirtualFile vDir, String dirName) throws IOException {
            throw new IOException("Cannot create directories");
        }
    }
}

