/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNls
public class LightIdeaTestCase
extends UsefulTestCase
implements DataProvider {
    protected static final String PROFILE = "Configurable";
    private static IdeaTestApplication ourApplication;
    private static Project ourProject;
    private static Module ourModule;
    private static ProjectJdk ourJDK;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static TestCase ourTestCase;
    public static Thread ourTestThread;
    protected Disposable myTestRootDisposable;
    private Map<String, LocalInspectionTool> myAvailableTools = new HashMap<String, LocalInspectionTool>();
    private Map<String, LocalInspectionToolWrapper> myAvailableLocalTools = new HashMap<String, LocalInspectionToolWrapper>();

    public static Project getProject() {
        return ourProject;
    }

    public static Module getModule() {
        return ourModule;
    }

    public static PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance(ourProject);
        }
        return ourPsiManager;
    }

    public static void initApplication(DataProvider dataProvider) throws Exception {
        ourApplication = IdeaTestApplication.getInstance();
        ourApplication.setDataProvider(dataProvider);
    }

    private void cleanupApplicationCaches() {
        ((VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance()).cleanupForNextTest();
        if (ourProject != null) {
            UndoManager.getInstance(ourProject).dropHistory();
        }
        this.resetAllFields();
    }

    protected void resetAllFields() {
        this.resetClassFields(this.getClass());
    }

    private void resetClassFields(Class<?> aClass) {
        Field[] fields;
        if (aClass == null) {
            return;
        }
        for (Field field : fields = aClass.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if ((modifiers & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            try {
                field.set(this, null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (aClass == LightIdeaTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFS)ManagingFS.getInstance()).cleanPersistedContents();
    }

    private static void initProject(final ProjectJdk projectJDK) throws Exception {
        final File projectFile = File.createTempFile("temp", ".ipr");
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                if (ourProject != null) {
                    ProjectUtil.closeProject((Project)ourProject);
                } else {
                    LightIdeaTestCase.cleanPersistedVFSContent();
                }
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
                ourProject = ProjectManagerEx.getInstanceEx().newProject(projectFile.getPath(), false, false);
                ourPsiManager = null;
                ourModule = LightIdeaTestCase.createMainModule();
                ourSourceRoot = DummyFileSystem.getInstance().createRoot("src");
                ModuleRootManager rootManager = ModuleRootManager.getInstance(ourModule);
                ModifiableRootModel rootModel = rootManager.getModifiableModel();
                if (projectJDK != null) {
                    ourJDK = projectJDK;
                    rootModel.setJdk(projectJDK);
                }
                ContentEntry contentEntry = rootModel.addContentEntry(ourSourceRoot);
                contentEntry.addSourceFolder(ourSourceRoot, false);
                rootModel.commit();
                MessageBusConnection connection = ourProject.getMessageBus().connect();
                connection.subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

                    public void beforeRootsChange(ModuleRootEvent event) {
                        if (!event.isCausedByFileTypesChange()) {
                            Assert.fail((String)"Root modification in LightIdeaTestCase is not allowed.");
                        }
                    }

                    public void rootsChanged(ModuleRootEvent event) {
                    }
                });
                connection.subscribe(ProjectTopics.MODULES, new ModuleListener(){

                    @Override
                    public void moduleAdded(Project project, Module module) {
                        Assert.fail((String)"Adding modules is not permitted in LightIdeaTestCase.");
                    }

                    @Override
                    public void beforeModuleRemoved(Project project, Module module) {
                    }

                    @Override
                    public void moduleRemoved(Project project, Module module) {
                    }

                    @Override
                    public void modulesRenamed(Project project, List<Module> modules) {
                    }
                });
                ((StartupManagerImpl)StartupManager.getInstance(LightIdeaTestCase.getProject())).runStartupActivities();
            }
        });
    }

    protected static Module createMainModule() {
        return ApplicationManager.getApplication().runWriteAction(new Computable<Module>(){

            @Override
            public Module compute() {
                return ModuleManager.getInstance(ourProject).newModule("light_idea_test_case.iml");
            }
        });
    }

    protected static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myTestRootDisposable = new Disposable(){

            public void dispose() {
            }
        };
        LightIdeaTestCase.initApplication(this);
        LightIdeaTestCase.doSetup(this.getProjectJDK(), this.configureLocalInspectionTools(), this.myAvailableTools, this.myAvailableLocalTools);
    }

    public static void doSetup(ProjectJdk projectJDK, LocalInspectionTool[] localInspectionTools, final Map<String, LocalInspectionTool> availableToolsMap, final Map<String, LocalInspectionToolWrapper> availableLocalTools) throws Exception {
        LightIdeaTestCase.assertNull((String)("Previous test " + ourTestCase + " hasn't called tearDown(). Probably overriden without super call."), (Object)ourTestCase);
        IdeaLogger.ourErrorsOccurred = null;
        if (ourProject == null || LightIdeaTestCase.isJDKChanged(projectJDK)) {
            LightIdeaTestCase.initProject(projectJDK);
        }
        ProjectManagerEx.getInstanceEx().setCurrentTestProject(ourProject);
        for (LocalInspectionTool tool : localInspectionTools) {
            LightIdeaTestCase._enableInspectionTool(tool, availableToolsMap, availableLocalTools);
        }
        InspectionProfileImpl profile = new InspectionProfileImpl(PROFILE){

            public InspectionProfileEntry[] getInspectionTools() {
                if (availableLocalTools != null) {
                    Collection tools = availableLocalTools.values();
                    return (InspectionProfileEntry[])tools.toArray(new LocalInspectionToolWrapper[tools.size()]);
                }
                return new InspectionProfileEntry[0];
            }

            public boolean isToolEnabled(HighlightDisplayKey key) {
                return key != null && availableToolsMap.containsKey(key.toString());
            }

            public HighlightDisplayLevel getErrorLevel(HighlightDisplayKey key) {
                LocalInspectionTool localInspectionTool = (LocalInspectionTool)availableToolsMap.get(key.toString());
                return localInspectionTool != null ? localInspectionTool.getDefaultLevel() : HighlightDisplayLevel.WARNING;
            }

            public InspectionTool getInspectionTool(String shortName) {
                if (availableToolsMap.containsKey(shortName)) {
                    return new LocalInspectionToolWrapper((LocalInspectionTool)availableToolsMap.get(shortName));
                }
                return null;
            }
        };
        InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        inspectionProfileManager.addProfile((Profile)profile);
        inspectionProfileManager.setRootProfile(profile.getName());
        InspectionProjectProfileManager.getInstance((Project)LightIdeaTestCase.getProject()).updateProfile((Profile)profile);
        LightIdeaTestCase.assertFalse((boolean)LightIdeaTestCase.getPsiManager().isDisposed());
        CodeStyleSettingsManager.getInstance(LightIdeaTestCase.getProject()).setTemporarySettings(new CodeStyleSettings());
    }

    protected void enableInspectionTool(LocalInspectionTool tool) {
        LightIdeaTestCase._enableInspectionTool(tool, this.myAvailableTools, this.myAvailableLocalTools);
    }

    private static void _enableInspectionTool(LocalInspectionTool tool, Map<String, LocalInspectionTool> availableToolsMap, Map<String, LocalInspectionToolWrapper> availableLocalTools) {
        String shortName = tool.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
        if (key == null) {
            HighlightDisplayKey.register(shortName, tool.getDisplayName(), tool.getID());
        }
        availableToolsMap.put(shortName, tool);
        availableLocalTools.put(shortName, new LocalInspectionToolWrapper(tool));
    }

    protected LocalInspectionTool[] configureLocalInspectionTools() {
        return new LocalInspectionTool[0];
    }

    @Override
    protected void tearDown() throws Exception {
        Disposer.dispose(this.myTestRootDisposable);
        this.myTestRootDisposable = null;
        LightIdeaTestCase.doTearDown();
        super.tearDown();
    }

    private static void doPostponedFormatting(final Project project) {
        try {
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        public void run() {
                            PsiDocumentManager.getInstance(project).commitAllDocuments();
                            PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting();
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void doTearDown() throws Exception {
        LightIdeaTestCase.doPostponedFormatting(ourProject);
        InspectionProfileManager.getInstance().deleteProfile(PROFILE);
        CodeStyleSettingsManager.getInstance(LightIdeaTestCase.getProject()).setTemporarySettings(null);
        LightIdeaTestCase.assertNotNull((String)"Application components damaged", (Object)ProjectManager.getInstance());
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                try {
                    VirtualFile[] children;
                    for (VirtualFile aChildren : children = ourSourceRoot.getChildren()) {
                        aChildren.delete(this);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                FileDocumentManager manager = FileDocumentManager.getInstance();
                if (manager instanceof FileDocumentManagerImpl) {
                    ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
                }
            }
        });
        LightIdeaTestCase.assertFalse((boolean)PsiManager.getInstance(LightIdeaTestCase.getProject()).isDisposed());
        if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance(LightIdeaTestCase.getProject())).clearUncommitedDocuments();
        UndoManager.getGlobalInstance().dropHistory();
        ProjectManagerEx.getInstanceEx().setCurrentTestProject(null);
        ourApplication.setDataProvider(null);
        ourTestCase = null;
        ((PsiManagerImpl)ourPsiManager).cleanupForNextTest();
        Editor[] allEditors = EditorFactory.getInstance().getAllEditors();
        if (allEditors.length > 0) {
            for (Editor allEditor : allEditors) {
                EditorFactory.getInstance().releaseEditor(allEditor);
            }
            LightIdeaTestCase.fail((String)("Unreleased editors: " + allEditors.length));
        }
    }

    public final void runBare() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ourTestThread = Thread.currentThread();
                    LightIdeaTestCase.this.startRunAndTear();
                }
                catch (Throwable throwable) {
                    throwables[0] = throwable;
                }
                finally {
                    ourTestThread = null;
                    try {
                        LightIdeaTestCase.this.cleanupApplicationCaches();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunAndTear() throws Throwable {
        this.setUp();
        try {
            ourAssertionsInTestDetected = true;
            this.runTest();
            ourAssertionsInTestDetected = false;
        }
        finally {
            try {
                this.tearDown();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    @Override
    public Object getData(String dataId) {
        if (dataId.equals("project")) {
            return ourProject;
        }
        return null;
    }

    private static boolean isJDKChanged(ProjectJdk newJDK) {
        return ourJDK == null || !Comparing.equal(ourJDK.getVersionString(), newJDK.getVersionString());
    }

    protected ProjectJdk getProjectJDK() {
        return JavaSdkImpl.getMockJdk((String)"java 1.4");
    }

    protected static PsiFile createFile(String fileName, String text) throws IncorrectOperationException {
        return LightIdeaTestCase.createPseudoPhysicalFile(fileName, text);
    }

    protected static PsiFile createLightFile(String fileName, String text) throws IncorrectOperationException {
        return LightIdeaTestCase.getPsiManager().getElementFactory().createFileFromText(fileName, FileTypeManager.getInstance().getFileTypeByFileName(fileName), text, LocalTimeCounter.currentTime(), false);
    }

    protected static PsiFile createPseudoPhysicalFile(String fileName, String text) throws IncorrectOperationException {
        return LightIdeaTestCase.getPsiManager().getElementFactory().createFileFromText(fileName, FileTypeManager.getInstance().getFileTypeByFileName(fileName), text, LocalTimeCounter.currentTime(), true);
    }

    @Override
    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        LightIdeaTestCase.assertTrue((String)"Test name should start with 'test'", (boolean)name.startsWith("test"));
        name = name.substring("test".length());
        if (lowercaseFirstLetter) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    protected static void commitDocument(Document document) {
        PsiDocumentManager.getInstance(LightIdeaTestCase.getProject()).commitDocument(document);
    }

    protected static void commitAllDocuments() {
        PsiDocumentManager.getInstance(LightIdeaTestCase.getProject()).commitAllDocuments();
    }

    protected Document getDocument(PsiFile file) {
        return PsiDocumentManager.getInstance(LightIdeaTestCase.getProject()).getDocument(file);
    }

    static {
        ourTestCase = null;
        System.setProperty("jbdt.test.fixture", "com.intellij.designer.dt.IJTestFixture");
        ShutDownTracker.getInstance().registerShutdownThread(0, new Thread(new Runnable(){

            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            if (ourProject != null) {
                                File projectFile = VfsUtil.virtualToIoFile(ourProject.getProjectFile());
                                ProjectUtil.closeProject((Project)ourProject);
                                FileUtil.delete(projectFile);
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }));
    }
}

