/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.injected.DocumentWindow;
import com.intellij.openapi.editor.impl.injected.EditorWindow;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.testFramework.LightIdeaTestCase;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LightCodeInsightTestCase
extends LightIdeaTestCase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.testFramework.LightCodeInsightTestCase");
    protected static Editor myEditor;
    protected static PsiFile myFile;
    protected static VirtualFile myVFile;
    private static final String CARET_MARKER = "<caret>";
    private static final String SELECTION_START_MARKER = "<selection>";
    private static final String SELECTION_END_MARKER = "</selection>";

    protected void runTest() throws Throwable {
        final Throwable[] throwable = new Throwable[]{null};
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                CommandProcessor.getInstance().executeCommand(LightIdeaTestCase.getProject(), new Runnable(){

                    public void run() {
                        try {
                            LightCodeInsightTestCase.this.doRunTest();
                        }
                        catch (Throwable t) {
                            throwable[0] = t;
                        }
                    }
                }, "", null);
            }
        });
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    protected void doRunTest() throws Throwable {
        LightCodeInsightTestCase.super.runTest();
    }

    protected void configureByFile(@NonNls String filePath) throws Exception {
        String fullPath = this.getTestDataPath() + filePath;
        File ioFile = new File(fullPath);
        String fileText = new String(FileUtil.loadFileText(ioFile, "UTF-8"));
        fileText = StringUtil.convertLineSeparators(fileText, "\n");
        LightCodeInsightTestCase.configureFromFileText(ioFile.getName(), fileText);
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected static void configureFromFileText(@NonNls String fileName, @NonNls String fileText) throws IOException {
        RangeMarker selEndMarker;
        DocumentImpl fakeDocument = new DocumentImpl(fileText);
        int caretIndex = fileText.indexOf(CARET_MARKER);
        int selStartIndex = fileText.indexOf(SELECTION_START_MARKER);
        int selEndIndex = fileText.indexOf(SELECTION_END_MARKER);
        RangeMarker caretMarker = caretIndex >= 0 ? fakeDocument.createRangeMarker(caretIndex, caretIndex) : null;
        RangeMarker selStartMarker = selStartIndex >= 0 ? fakeDocument.createRangeMarker(selStartIndex, selStartIndex) : null;
        RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? fakeDocument.createRangeMarker(selEndIndex, selEndIndex) : null;
        if (caretMarker != null) {
            fakeDocument.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_MARKER.length());
        }
        if (selStartMarker != null) {
            fakeDocument.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_MARKER.length());
        }
        if (selEndMarker != null) {
            fakeDocument.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_MARKER.length());
        }
        String newFileText = fakeDocument.getText();
        LightCodeInsightTestCase.setupFileEditorAndDocument(fileName, newFileText);
        LightCodeInsightTestCase.setupCaret(caretMarker, newFileText);
        LightCodeInsightTestCase.setupSelection(selStartMarker, selEndMarker);
        LightCodeInsightTestCase.setupEditorForInjectedLanguage();
    }

    private static void setupSelection(RangeMarker selStartMarker, RangeMarker selEndMarker) {
        if (selStartMarker != null) {
            myEditor.getSelectionModel().setSelection(selStartMarker.getStartOffset(), selEndMarker.getStartOffset());
        }
    }

    private static void setupCaret(RangeMarker caretMarker, String fileText) {
        if (caretMarker != null) {
            int caretLine = StringUtil.offsetToLineNumber(fileText, caretMarker.getStartOffset());
            int caretCol = EditorUtil.calcColumnNumber(null, (CharSequence)myEditor.getDocument().getText(), (int)myEditor.getDocument().getLineStartOffset(caretLine), (int)caretMarker.getStartOffset(), (int)CodeStyleSettingsManager.getSettings((Project)LightCodeInsightTestCase.getProject()).JAVA_INDENT_OPTIONS.TAB_SIZE);
            LogicalPosition pos = new LogicalPosition(caretLine, caretCol);
            myEditor.getCaretModel().moveToLogicalPosition(pos);
        }
    }

    private static Editor createEditor(VirtualFile file) {
        return FileEditorManager.getInstance(LightCodeInsightTestCase.getProject()).openTextEditor(new OpenFileDescriptor(LightCodeInsightTestCase.getProject(), file, 0), false);
    }

    private static void setupFileEditorAndDocument(String fileName, String fileText) throws IOException {
        LightCodeInsightTestCase.deleteVFile();
        myVFile = LightCodeInsightTestCase.getSourceRoot().createChildData(null, fileName);
        myVFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        VfsUtil.saveText(myVFile, fileText);
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Document document = manager.getDocument(myVFile);
        LightCodeInsightTestCase.assertNotNull((String)("Can't create document for '" + fileName + "'"), (Object)document);
        manager.reloadFromDisk(document);
        myFile = LightCodeInsightTestCase.getPsiManager().findFile(myVFile);
        LightCodeInsightTestCase.assertNotNull((String)("Can't create PsiFile for '" + fileName + "'. Unknown file type most probably."), (Object)myFile);
        LightCodeInsightTestCase.assertTrue((boolean)myFile.isPhysical());
        myEditor = LightCodeInsightTestCase.createEditor(myVFile);
    }

    private static void setupEditorForInjectedLanguage() {
        Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguage((Editor)myEditor, (PsiFile)myFile);
        if (editor instanceof EditorWindow) {
            myFile = ((EditorWindow)editor).getInjectedFile();
            myEditor = editor;
        }
    }

    private static void deleteVFile() {
        if (myVFile != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                public void run() {
                    try {
                        myVFile.delete(this);
                    }
                    catch (IOException e) {
                        LOG.error(e);
                    }
                }
            });
        }
    }

    protected void tearDown() throws Exception {
        VirtualFile[] openFiles;
        FileEditorManager editorManager = FileEditorManager.getInstance(LightCodeInsightTestCase.getProject());
        for (VirtualFile openFile : openFiles = editorManager.getOpenFiles()) {
            editorManager.closeFile(openFile);
        }
        LightCodeInsightTestCase.deleteVFile();
        myEditor = null;
        myFile = null;
        myVFile = null;
        super.tearDown();
    }

    protected void checkResultByFile(@NonNls String filePath) throws Exception {
        this.checkResultByFile(null, filePath, false);
    }

    protected void checkResultByFile(String message, String filePath, boolean ignoreTrailingSpaces) throws Exception {
        LightCodeInsightTestCase.bringRealEditorBack();
        LightCodeInsightTestCase.getProject().getComponent(PostprocessReformattingAspect.class).doPostponedFormatting();
        if (ignoreTrailingSpaces) {
            ((DocumentEx)myEditor.getDocument()).stripTrailingSpaces(false);
        }
        PsiDocumentManager.getInstance(LightCodeInsightTestCase.getProject()).commitAllDocuments();
        String fullPath = this.getTestDataPath() + filePath;
        File ioFile = new File(fullPath);
        LightCodeInsightTestCase.assertTrue((String)LightCodeInsightTestCase.getMessage("Cannot find file " + fullPath, message), (boolean)ioFile.exists());
        String fileText = null;
        try {
            fileText = new String(FileUtil.loadFileText(ioFile, "UTF-8"));
        }
        catch (IOException e) {
            LOG.error(e);
        }
        this.checkResultByText(message, StringUtil.convertLineSeparators(fileText, "\n"), ignoreTrailingSpaces);
    }

    protected void checkResultByText(@NonNls String fileText) {
        this.checkResultByText(null, fileText, false);
    }

    protected void checkResultByText(String message, String fileText, boolean ignoreTrailingSpaces) {
        String newFileText;
        RangeMarker selEndMarker;
        LightCodeInsightTestCase.bringRealEditorBack();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                PsiDocumentManager.getInstance(LightIdeaTestCase.getProject()).commitAllDocuments();
            }
        });
        Document document = EditorFactory.getInstance().createDocument(fileText);
        int caretIndex = fileText.indexOf(CARET_MARKER);
        int selStartIndex = fileText.indexOf(SELECTION_START_MARKER);
        int selEndIndex = fileText.indexOf(SELECTION_END_MARKER);
        RangeMarker caretMarker = caretIndex >= 0 ? document.createRangeMarker(caretIndex, caretIndex) : null;
        RangeMarker selStartMarker = selStartIndex >= 0 ? document.createRangeMarker(selStartIndex, selStartIndex) : null;
        RangeMarker rangeMarker = selEndMarker = selEndIndex >= 0 ? document.createRangeMarker(selEndIndex, selEndIndex) : null;
        if (caretMarker != null) {
            document.deleteString(caretMarker.getStartOffset(), caretMarker.getStartOffset() + CARET_MARKER.length());
        }
        if (selStartMarker != null) {
            document.deleteString(selStartMarker.getStartOffset(), selStartMarker.getStartOffset() + SELECTION_START_MARKER.length());
        }
        if (selEndMarker != null) {
            document.deleteString(selEndMarker.getStartOffset(), selEndMarker.getStartOffset() + SELECTION_END_MARKER.length());
        }
        String newFileText1 = newFileText = document.getText();
        if (ignoreTrailingSpaces) {
            Document document1 = EditorFactory.getInstance().createDocument(newFileText);
            ((DocumentEx)document1).stripTrailingSpaces(false);
            newFileText1 = document1.getText();
        }
        PostprocessReformattingAspect.getInstance((Project)LightCodeInsightTestCase.getProject()).doPostponedFormatting();
        PsiDocumentManager.getInstance(LightCodeInsightTestCase.getProject()).commitAllDocuments();
        LightCodeInsightTestCase.assertEquals((String)LightCodeInsightTestCase.getMessage("Text mismatch", message), (String)newFileText1, (String)myFile.getText());
        this.checkCaretPosition(caretMarker, newFileText, message);
        this.checkSelection(selStartMarker, selEndMarker, newFileText, message);
    }

    private static String getMessage(String engineMessage, String userMessage) {
        if (userMessage == null) {
            return engineMessage;
        }
        StringBuffer buf = new StringBuffer(userMessage);
        buf.append(" [").append(engineMessage).append("]");
        return buf.toString();
    }

    private void checkSelection(RangeMarker selStartMarker, RangeMarker selEndMarker, String newFileText, String message) {
        if (selStartMarker != null && selEndMarker != null) {
            int selStartLine = StringUtil.offsetToLineNumber(newFileText, selStartMarker.getStartOffset());
            int selStartCol = selStartMarker.getStartOffset() - StringUtil.lineColToOffset(newFileText, selStartLine, 0);
            int selEndLine = StringUtil.offsetToLineNumber(newFileText, selEndMarker.getEndOffset());
            int selEndCol = selEndMarker.getEndOffset() - StringUtil.lineColToOffset(newFileText, selEndLine, 0);
            LightCodeInsightTestCase.assertEquals((String)LightCodeInsightTestCase.getMessage("selectionStartLine", message), (int)(selStartLine + 1), (int)(StringUtil.offsetToLineNumber(newFileText, myEditor.getSelectionModel().getSelectionStart()) + 1));
            LightCodeInsightTestCase.assertEquals((String)LightCodeInsightTestCase.getMessage("selectionStartCol", message), (int)(selStartCol + 1), (int)(myEditor.getSelectionModel().getSelectionStart() - StringUtil.lineColToOffset(newFileText, selStartLine, 0) + 1));
            LightCodeInsightTestCase.assertEquals((String)LightCodeInsightTestCase.getMessage("selectionEndLine", message), (int)(selEndLine + 1), (int)(StringUtil.offsetToLineNumber(newFileText, myEditor.getSelectionModel().getSelectionEnd()) + 1));
            LightCodeInsightTestCase.assertEquals((String)LightCodeInsightTestCase.getMessage("selectionEndCol", message), (int)(selEndCol + 1), (int)(myEditor.getSelectionModel().getSelectionEnd() - StringUtil.lineColToOffset(newFileText, selEndLine, 0) + 1));
        } else {
            LightCodeInsightTestCase.assertTrue((String)LightCodeInsightTestCase.getMessage("must not have selection", message), (!myEditor.getSelectionModel().hasSelection() ? 1 : 0) != 0);
        }
    }

    private void checkCaretPosition(RangeMarker caretMarker, String newFileText, String message) {
        if (caretMarker != null) {
            int caretLine = StringUtil.offsetToLineNumber(newFileText, caretMarker.getStartOffset());
            int caretCol = EditorUtil.calcColumnNumber(null, (CharSequence)newFileText, (int)StringUtil.lineColToOffset(newFileText, caretLine, 0), (int)caretMarker.getStartOffset(), (int)CodeStyleSettingsManager.getSettings((Project)LightCodeInsightTestCase.getProject()).JAVA_INDENT_OPTIONS.TAB_SIZE);
            LightCodeInsightTestCase.assertEquals((String)LightCodeInsightTestCase.getMessage("caretLine", message), (int)(caretLine + 1), (int)(LightCodeInsightTestCase.myEditor.getCaretModel().getLogicalPosition().line + 1));
            LightCodeInsightTestCase.assertEquals((String)LightCodeInsightTestCase.getMessage("caretColumn", message), (int)(caretCol + 1), (int)(LightCodeInsightTestCase.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
    }

    public Object getData(String dataId) {
        if (dataId.equals("editor")) {
            return myEditor;
        }
        if (dataId.equals(AnActionEvent.injectedId("editor"))) {
            return InjectedLanguageUtil.getEditorForInjectedLanguage((Editor)LightCodeInsightTestCase.getEditor(), (PsiFile)LightCodeInsightTestCase.getFile());
        }
        if (dataId.equals("psi.File")) {
            return myFile;
        }
        if (dataId.equals(AnActionEvent.injectedId("psi.File"))) {
            Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguage((Editor)LightCodeInsightTestCase.getEditor(), (PsiFile)LightCodeInsightTestCase.getFile());
            return editor instanceof EditorWindow ? ((EditorWindow)editor).getInjectedFile() : LightCodeInsightTestCase.getFile();
        }
        return super.getData(dataId);
    }

    protected static Editor getEditor() {
        return myEditor;
    }

    protected static PsiFile getFile() {
        return myFile;
    }

    protected static VirtualFile getVFile() {
        return myVFile;
    }

    protected static void bringRealEditorBack() {
        PsiDocumentManager.getInstance(LightCodeInsightTestCase.getProject()).commitAllDocuments();
        if (myEditor instanceof EditorWindow) {
            DocumentEx document = ((DocumentWindow)myEditor.getDocument()).getDelegate();
            myFile = PsiDocumentManager.getInstance(LightCodeInsightTestCase.getProject()).getPsiFile((Document)document);
            myEditor = ((EditorWindow)myEditor).getDelegate();
            myVFile = myFile.getVirtualFile();
        }
    }

    protected static void type(char c) {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        TypedAction action = actionManager.getTypedAction();
        action.actionPerformed(LightCodeInsightTestCase.getEditor(), c, DataManager.getInstance().getDataContext());
    }

    protected static void type(@NonNls String s) {
        for (char c : s.toCharArray()) {
            LightCodeInsightTestCase.type(c);
        }
    }

    protected static void backspace() {
        EditorActionManager actionManager = EditorActionManager.getInstance();
        EditorActionHandler actionHandler = actionManager.getActionHandler("EditorBackSpace");
        actionHandler.execute(LightCodeInsightTestCase.getEditor(), DataManager.getInstance().getDataContext());
    }

    protected DataContext getCurrentEditorDataContext() {
        final DataContext defaultContext = DataManager.getInstance().getDataContext();
        DataContext dataContext = new DataContext(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (dataId.equals("editor")) {
                    return LightCodeInsightTestCase.getEditor();
                }
                if (dataId.equals("project")) {
                    return LightIdeaTestCase.getProject();
                }
                if (dataId.equals("psi.File")) {
                    return LightCodeInsightTestCase.getFile();
                }
                if (dataId.equals("psi.Element")) {
                    return LightCodeInsightTestCase.getFile().findElementAt(LightCodeInsightTestCase.getEditor().getCaretModel().getOffset());
                }
                return defaultContext.getData(dataId);
            }
        };
        return dataContext;
    }
}

