/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.deadCode.DeadCodeInspection;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.PsiTestCase;
import java.io.CharArrayReader;
import java.io.File;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class InspectionTestCase
extends PsiTestCase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.testFramework.InspectionTestCase");

    public InspectionManagerEx getManager() {
        return (InspectionManagerEx)InspectionManager.getInstance(this.myProject);
    }

    public void doTest(@NonNls String folderName, LocalInspectionTool tool) throws Exception {
        this.doTest(folderName, (InspectionTool)new LocalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls String folderName, GlobalInspectionTool tool) throws Exception {
        this.doTest(folderName, (InspectionTool)new GlobalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls String folderName, GlobalInspectionTool tool, boolean checkRange) throws Exception {
        this.doTest(folderName, (InspectionTool)new GlobalInspectionToolWrapper(tool), checkRange);
    }

    public void doTest(@NonNls String folderName, GlobalInspectionTool tool, boolean checkRange, boolean runDeadCodeFirst) throws Exception {
        this.doTest(folderName, (InspectionTool)new GlobalInspectionToolWrapper(tool), "java 1.4", checkRange, runDeadCodeFirst);
    }

    public void doTest(@NonNls String folderName, InspectionTool tool) throws Exception {
        this.doTest(folderName, tool, "java 1.4");
    }

    public void doTest(@NonNls String folderName, InspectionTool tool, boolean checkRange) throws Exception {
        this.doTest(folderName, tool, "java 1.4", checkRange);
    }

    public void doTest(@NonNls String folderName, InspectionTool tool, @NonNls String jdkName) throws Exception {
        this.doTest(folderName, tool, jdkName, false);
    }

    public void doTest(@NonNls String folderName, InspectionTool tool, @NonNls String jdkName, boolean checkRange) throws Exception {
        this.doTest(folderName, tool, jdkName, checkRange, false);
    }

    public void doTest(@NonNls String folderName, InspectionTool tool, @NonNls String jdkName, boolean checkRange, boolean runDeadCodeFirst) throws Exception {
        String testDir = this.getTestDataPath() + "/" + folderName;
        this.runTool(testDir, jdkName, tool, runDeadCodeFirst);
        Element root = new Element("problems");
        Document doc = new Document(root);
        tool.updateContent();
        tool.exportResults(root);
        File file = new File(testDir + "/expected.xml");
        Document expectedDocument = JDOMUtil.loadDocument(file);
        InspectionTestCase.compareWithExpected(expectedDocument, doc, checkRange);
    }

    protected void runTool(@NonNls String testDir, @NonNls String jdkName, InspectionTool tool) {
        this.runTool(testDir, jdkName, tool, false);
    }

    protected void runTool(final String testDir, final String jdkName, InspectionTool tool, boolean runDeadCodeFirst) {
        final VirtualFile[] sourceDir = new VirtualFile[1];
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                try {
                    InspectionTestCase.this.setupRootModel(testDir, sourceDir, jdkName);
                }
                catch (Exception e) {
                    LOG.error(e);
                }
            }
        });
        AnalysisScope scope = this.createAnalysisScope(sourceDir[0]);
        InspectionManagerEx inspectionManager = (InspectionManagerEx)InspectionManager.getInstance(this.myProject);
        GlobalInspectionContextImpl globalContext = inspectionManager.createNewGlobalContext(true);
        globalContext.setCurrentScope(scope);
        if (runDeadCodeFirst) {
            InspectionTestCase.runTool((InspectionTool)new DeadCodeInspection(), scope, globalContext, inspectionManager);
        }
        InspectionTestCase.runTool(tool, scope, globalContext, inspectionManager);
    }

    protected AnalysisScope createAnalysisScope(VirtualFile sourceDir) {
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        return new AnalysisScope(psiManager.findDirectory(sourceDir));
    }

    private static void runTool(InspectionTool tool, AnalysisScope scope, GlobalInspectionContextImpl globalContext, InspectionManagerEx inspectionManager) {
        tool.initialize(globalContext);
        ((RefManagerImpl)globalContext.getRefManager()).initializeAnnotators();
        if (tool.isGraphNeeded()) {
            ((RefManagerImpl)tool.getRefManager()).findAllDeclarations();
        }
        tool.runInspection(scope, (InspectionManager)inspectionManager);
        tool.queryExternalUsagesRequests((InspectionManager)inspectionManager);
        do {
            globalContext.processSearchRequests();
        } while (tool.queryExternalUsagesRequests((InspectionManager)inspectionManager));
    }

    protected void setupRootModel(String testDir, VirtualFile[] sourceDir, String jdkName) {
        ProjectJdk jdk;
        VirtualFile projectDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir));
        InspectionTestCase.assertNotNull((Object)projectDir);
        sourceDir[0] = projectDir.findChild("src");
        if (sourceDir[0] == null) {
            sourceDir[0] = projectDir;
        }
        VirtualFile ext_src = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(testDir + "/ext_src"));
        ModuleRootManager rootManager = ModuleRootManager.getInstance(this.myModule);
        ModifiableRootModel rootModel = rootManager.getModifiableModel();
        rootModel.clear();
        ContentEntry contentEntry = rootModel.addContentEntry(projectDir);
        contentEntry.addSourceFolder(sourceDir[0], false);
        if (ext_src != null) {
            contentEntry.addSourceFolder(ext_src, false);
        }
        if ("java 1.5".equals(jdkName)) {
            jdk = JavaSdkImpl.getMockJdk15((String)jdkName);
            this.myPsiManager.setEffectiveLanguageLevel(LanguageLevel.JDK_1_5);
        } else {
            jdk = JavaSdkImpl.getMockJdk((String)jdkName);
        }
        rootModel.setJdk(jdk);
        rootModel.commit();
    }

    @NonNls
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/inspection/";
    }

    protected static void compareWithExpected(Document expectedDoc, Document doc, boolean checkRange) throws Exception {
        ArrayList expectedProblems = new ArrayList(expectedDoc.getRootElement().getChildren("problem"));
        ArrayList reportedProblems = new ArrayList(doc.getRootElement().getChildren("problem"));
        Element[] expectedArrayed = expectedProblems.toArray(new Element[expectedProblems.size()]);
        boolean failed = false;
        block0: for (Element expectedProblem : expectedArrayed) {
            Element[] reportedArrayed;
            for (Element reportedProblem : reportedArrayed = reportedProblems.toArray(new Element[reportedProblems.size()])) {
                if (!InspectionTestCase.compareProblemWithExpected(reportedProblem, expectedProblem, checkRange)) continue;
                expectedProblems.remove(expectedProblem);
                reportedProblems.remove(reportedProblem);
                continue block0;
            }
            Document missing = new Document((Element)expectedProblem.clone());
            System.out.println("The following haven't been reported as expected: " + new String(JDOMUtil.printDocument(missing, "\n")));
            failed = true;
        }
        for (Object reportedProblem1 : reportedProblems) {
            Element reportedProblem = (Element)reportedProblem1;
            Document extra = new Document((Element)reportedProblem.clone());
            System.out.println("The following has been unexpectedly reported: " + new String(JDOMUtil.printDocument(extra, "\n")));
            failed = true;
        }
        InspectionTestCase.assertFalse((boolean)failed);
    }

    private static boolean compareProblemWithExpected(Element reportedProblem, Element expectedProblem, boolean checkRange) throws Exception {
        if (!InspectionTestCase.compareFiles(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestCase.compareLines(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestCase.compareDescriptions(reportedProblem, expectedProblem)) {
            return false;
        }
        return !checkRange || InspectionTestCase.compareTextRange(reportedProblem, expectedProblem);
    }

    private static boolean compareTextRange(Element reportedProblem, Element expectedProblem) {
        Element reportedTextRange = reportedProblem.getChild("entry_point");
        if (reportedTextRange == null) {
            return false;
        }
        Element expectedTextRange = expectedProblem.getChild("entry_point");
        return Comparing.equal(reportedTextRange.getAttributeValue("TYPE"), expectedTextRange.getAttributeValue("TYPE")) && Comparing.equal(reportedTextRange.getAttributeValue("FQNAME"), expectedTextRange.getAttributeValue("FQNAME"));
    }

    private static boolean compareDescriptions(Element reportedProblem, Element expectedProblem) throws Exception {
        String reportedDescription;
        String expectedDescription = expectedProblem.getChildText("description");
        if (expectedDescription.equals(reportedDescription = reportedProblem.getChildText("description"))) {
            return true;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new CharArrayReader(expectedDescription.toCharArray()));
        tokenizer.quoteChar(39);
        int idx = 0;
        while (tokenizer.nextToken() != -1) {
            String word;
            if (tokenizer.sval != null) {
                word = tokenizer.sval;
            } else {
                if (tokenizer.ttype != -2) continue;
                word = Double.toString(tokenizer.nval);
            }
            idx = reportedDescription.indexOf(word, idx);
            if (idx == -1) {
                return false;
            }
            idx += word.length();
        }
        return true;
    }

    private static boolean compareLines(Element reportedProblem, Element expectedProblem) {
        return Comparing.equal(reportedProblem.getChildText("line"), expectedProblem.getChildText("line"));
    }

    private static boolean compareFiles(Element reportedProblem, Element expectedProblem) {
        String reportedFileName = reportedProblem.getChildText("file");
        File reportedFile = new File(reportedFileName);
        return Comparing.equal(reportedFile.getName(), expectedProblem.getChildText("file"));
    }
}

