/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNls
public abstract class IdeaTestCase
extends UsefulTestCase
implements DataProvider {
    protected static final String PROFILE = "Configurable";
    protected static IdeaTestApplication ourApplication;
    protected boolean myRunCommandForTest = false;
    protected ProjectManagerEx myProjectManager;
    protected Project myProject;
    protected Module myModule;
    protected static Collection<File> myFilesToDelete;
    protected boolean myAssertionsInTestDetected;
    protected static final Logger LOG;
    public static Thread ourTestThread;
    private static TestCase ourTestCase;
    public static final long DEFAULT_TEST_TIME = 300L;
    public static long ourTestTime;
    private static final MyThreadGroup MY_THREAD_GROUP;
    private static final String ourOriginalTempDir;
    private static int ourTestCount;

    protected static long getTimeRequired() {
        return 300L;
    }

    protected void initApplication() throws Exception {
        boolean firstTime = ourApplication == null;
        ourApplication = IdeaTestApplication.getInstance();
        ourApplication.setDataProvider((DataProvider)this);
        if (firstTime) {
            IdeaTestCase.cleanPersistedVFSContent();
        }
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFS)ManagingFS.getInstance()).cleanPersistedContents();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overriden without super call.";
            ourTestCase = null;
            IdeaTestCase.fail((String)message);
        }
        ourTestCase = this;
        IdeaLogger.ourErrorsOccurred = null;
        LOG.info(this.getClass().getName() + ".setUp()");
        String tempdirpath = ourOriginalTempDir + "/tsttmp" + ourTestCount + "/";
        IdeaTestCase.setTmpDir(tempdirpath);
        new File(tempdirpath).mkdir();
        this.initApplication();
        myFilesToDelete = new HashSet<File>();
        this.setUpProject();
    }

    public Project getProject() {
        return this.myProject;
    }

    public final PsiManager getPsiManager() {
        return PsiManager.getInstance(this.myProject);
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        LOG.assertTrue(this.myProjectManager != null, "Cannot instaitiate ProjectManager component");
        File projectFile = this.getIprFile();
        myFilesToDelete.add(projectFile);
        LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
        this.myProject = this.myProjectManager.newProject(projectFile.getPath(), false, false);
        ProjectManagerEx.getInstanceEx().setCurrentTestProject(this.myProject);
        this.setUpModule();
        this.setUpJdk();
        ((StartupManagerImpl)StartupManager.getInstance(this.myProject)).runStartupActivities();
    }

    protected File getIprFile() throws IOException {
        return File.createTempFile("temp", ".ipr");
    }

    protected void setUpModule() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                try {
                    IdeaTestCase.this.myModule = IdeaTestCase.this.createMainModule();
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        });
    }

    protected Module createMainModule() throws IOException {
        return this.createModule(this.myProject.getName());
    }

    protected Module createModule(String moduleName) {
        return this.doCreateRealModule(moduleName);
    }

    protected Module doCreateRealModule(String moduleName) {
        VirtualFile baseDir = this.myProject.getBaseDir();
        IdeaTestCase.assertNotNull((Object)baseDir);
        File moduleFile = new File(baseDir.getPath().replace('/', File.separatorChar), moduleName + ".iml");
        try {
            moduleFile.createNewFile();
        }
        catch (IOException e) {
            LOG.error(e);
        }
        myFilesToDelete.add(moduleFile);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleFile);
        Module module = ModuleManager.getInstance(this.myProject).newModule(virtualFile.getPath());
        module.getModuleFile();
        return module;
    }

    private void cleanupApplicationCaches() {
        try {
            LocalFileSystemImpl localFileSystem = (LocalFileSystemImpl)LocalFileSystem.getInstance();
            if (localFileSystem != null) {
                localFileSystem.cleanupForNextTest();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        VirtualFilePointerManagerImpl virtualFilePointerManager = (VirtualFilePointerManagerImpl)VirtualFilePointerManager.getInstance();
        if (virtualFilePointerManager != null) {
            virtualFilePointerManager.cleanupForNextTest();
        }
        this.resetAllFields();
    }

    private static void doPostponedFormatting(final Project project) {
        try {
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        public void run() {
                            PsiDocumentManager.getInstance(project).commitAllDocuments();
                            PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting();
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        InspectionProfileManager.getInstance().deleteProfile(PROFILE);
        try {
            IdeaTestCase.assertNotNull((String)"Application components damaged", (Object)ProjectManager.getInstance());
            ApplicationManager.getApplication().runWriteAction(EmptyRunnable.getInstance());
            FileDocumentManager.getInstance().saveAllDocuments();
            IdeaTestCase.doPostponedFormatting(this.myProject);
            try {
                Disposer.dispose(this.myProject);
                ProjectManagerEx.getInstanceEx().setCurrentTestProject(null);
                UndoManager.getGlobalInstance().dropHistory();
                for (File fileToDelete : myFilesToDelete) {
                    this.delete(fileToDelete);
                }
                FileUtil.asyncDelete(new File(ourOriginalTempDir + "/tsttmp" + ourTestCount));
                ++ourTestCount;
                IdeaTestCase.setTmpDir(ourOriginalTempDir);
                Throwable fromThreadGroup = MY_THREAD_GROUP.popThrowable();
                if (fromThreadGroup != null) {
                    throw new RuntimeException(fromThreadGroup);
                }
                if (!this.myAssertionsInTestDetected) {
                    if (IdeaLogger.ourErrorsOccurred != null) {
                        throw IdeaLogger.ourErrorsOccurred;
                    }
                    IdeaTestCase.assertTrue((String)("Logger errors occurred in " + this.getFullName()), (IdeaLogger.ourErrorsOccurred == null ? 1 : 0) != 0);
                }
                ourApplication.setDataProvider(null);
            }
            finally {
                ourTestCase = null;
            }
            super.tearDown();
            EditorFactory editorFactory = EditorFactory.getInstance();
            Editor[] allEditors = editorFactory.getAllEditors();
            ((EditorFactoryImpl)editorFactory).validateEditorsAreReleased(this.getProject());
            for (Editor editor : allEditors) {
                editorFactory.releaseEditor(editor);
            }
            IdeaTestCase.assertEquals((int)0, (int)allEditors.length);
        }
        finally {
            this.myProjectManager = null;
            this.myProject = null;
            this.myModule = null;
            myFilesToDelete = null;
        }
    }

    protected void resetAllFields() {
        this.resetClassFields(this.getClass());
    }

    @Override
    protected final <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register(this.myProject, disposable);
        return disposable;
    }

    private void resetClassFields(Class<?> aClass) {
        Field[] fields;
        if (aClass == null) {
            return;
        }
        for (Field field : fields = aClass.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if ((modifiers & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            try {
                field.set(this, null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (aClass == IdeaTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private String getFullName() {
        return this.getClass().getName() + "." + this.getName();
    }

    private void delete(File file) {
        boolean b;
        if (file.isDirectory()) {
            File[] files;
            for (File fileToDelete : files = file.listFiles()) {
                this.delete(fileToDelete);
            }
        }
        if (!(b = file.delete()) && file.exists() && !this.myAssertionsInTestDetected) {
            IdeaTestCase.assertTrue((String)("Can't delete " + file.getAbsolutePath() + " in " + this.getFullName()), (boolean)false);
        }
    }

    protected void simulateProjectOpen(Project p) {
        ModuleManagerImpl mm = (ModuleManagerImpl)ModuleManager.getInstance(this.myProject);
        StartupManagerImpl sm = (StartupManagerImpl)StartupManager.getInstance(this.myProject);
        mm.projectOpened();
        this.setUpJdk();
        sm.runProjectConfigurationActivities();
        sm.runStartupActivities();
        sm.runPostStartupActivities();
    }

    protected void setUpJdk() {
        Module[] modules;
        final ProjectJdk jdk = this.getTestProjectJdk();
        for (Module module : modules = ModuleManager.getInstance(this.myProject).getModules()) {
            final ModuleRootManager rootManager = ModuleRootManager.getInstance(module);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                public void run() {
                    ModifiableRootModel rootModel = rootManager.getModifiableModel();
                    rootModel.setJdk(jdk);
                    rootModel.commit();
                }
            });
        }
    }

    protected ProjectJdk getTestProjectJdk() {
        return JavaSdkImpl.getMockJdk((String)"java 1.4");
    }

    public void runBare() throws Throwable {
        final Throwable[] throwable = new Throwable[1];
        Thread thread = new Thread(MY_THREAD_GROUP, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block10: {
                    IdeaTestCase.this.runBareImpl();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                IdeaTestCase.this.cleanupApplicationCaches();
                            }
                        });
                    }
                    catch (Throwable e) {}
                    break block10;
                    catch (Throwable th) {
                        try {
                            throwable[0] = th;
                        }
                        catch (Throwable throwable3) {
                            try {
                                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            throw throwable3;
                        }
                        try {
                            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (Throwable throwable4) {}
                    }
                }
            }
        }, "IDEA Test Case Thread");
        thread.start();
        thread.join();
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    private void runBareImpl() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ourTestThread = Thread.currentThread();
                ourTestTime = IdeaTestCase.getTimeRequired();
                try {
                    IdeaTestCase.this.setUp();
                    try {
                        IdeaTestCase.this.myAssertionsInTestDetected = true;
                        IdeaTestCase.this.runTest();
                        IdeaTestCase.this.myAssertionsInTestDetected = false;
                    }
                    finally {
                        try {
                            IdeaTestCase.this.tearDown();
                        }
                        catch (Throwable th) {
                            th.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    throwables[0] = throwable;
                }
                finally {
                    ourTestThread = null;
                }
            }
        };
        this.runBareRunnable(runnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        if (throwables[0] != null) {
            throw throwables[0];
        }
        IdeaTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(Runnable runnable) throws Throwable, InvocationTargetException {
        SwingUtilities.invokeAndWait(runnable);
    }

    protected void runTest() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    IdeaTestCase.super.runTest();
                }
                catch (InvocationTargetException e) {
                    e.fillInStackTrace();
                    throwables[0] = e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    e.fillInStackTrace();
                    throwables[0] = e;
                }
                catch (Throwable e) {
                    throwables[0] = e;
                }
            }
        };
        this.invokeTestRunnable(runnable);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected void invokeTestRunnable(final Runnable runnable) throws Exception {
        final Exception[] e = new Exception[1];
        Runnable runnable1 = new Runnable(){

            public void run() {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    try {
                        ApplicationManager.getApplication().runWriteAction(runnable);
                    }
                    catch (Exception e1) {
                        e[0] = e1;
                    }
                } else {
                    runnable.run();
                }
            }
        };
        if (this.myRunCommandForTest) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    @Override
    public Object getData(String dataId) {
        if (dataId.equals("project")) {
            return this.myProject;
        }
        if (dataId.equals("editor")) {
            return FileEditorManager.getInstance(this.myProject).getSelectedTextEditor();
        }
        return null;
    }

    public static File createTempDir(@NonNls String prefix) throws IOException {
        File tempDirectory = FileUtil.createTempDirectory(prefix, null);
        myFilesToDelete.add(tempDirectory);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                VirtualFileManager.getInstance().refresh(false);
            }
        });
        return tempDirectory;
    }

    protected static VirtualFile getVirtualFile(File file) {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    protected File createTempDirectory() throws IOException {
        File dir = FileUtil.createTempDirectory("unitTest", null);
        myFilesToDelete.add(dir);
        return dir;
    }

    protected PsiFile getPsiFile(Document document) {
        return PsiDocumentManager.getInstance(this.getProject()).getPsiFile(document);
    }

    private static void setTmpDir(String path) {
        try {
            System.setProperty("java.io.tmpdir", path);
            Class<File> ioFile = File.class;
            Field field = ioFile.getDeclaredField("tmpdir");
            field.setAccessible(true);
            field.set(ioFile, null);
        }
        catch (NoSuchFieldException e) {
            LOG.error(e);
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
        }
    }

    static {
        Logger.setFactory(TestLoggerFactory.getInstance());
        LOG = Logger.getInstance("#com.intellij.testFramework.IdeaTestCase");
        ourTestCase = null;
        ourTestTime = 300L;
        MY_THREAD_GROUP = new MyThreadGroup();
        ourOriginalTempDir = System.getProperty("java.io.tmpdir");
        ourTestCount = 0;
        System.setProperty("jbdt.test.fixture", "com.intellij.designer.dt.IJTestFixture");
    }

    private static class MyThreadGroup
    extends ThreadGroup {
        private Throwable myThrowable;
        @NonNls
        private static final String IDEATEST_THREAD_GROUP = "IDEATest";

        public MyThreadGroup() {
            super(IDEATEST_THREAD_GROUP);
        }

        public void uncaughtException(Thread t, Throwable e) {
            this.myThrowable = e;
            super.uncaughtException(t, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Throwable popThrowable() {
            try {
                Throwable throwable = this.myThrowable;
                return throwable;
            }
            finally {
                this.myThrowable = null;
            }
        }
    }
}

