/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpectedHighlightingData {
    private static final Logger LOG = Logger.getInstance("#com.intellij.testFramework.ExpectedHighlightingData");
    @NonNls
    private static final String ERROR_MARKER = "error";
    @NonNls
    private static final String WARNING_MARKER = "warning";
    @NonNls
    private static final String INFORMATION_MARKER = "weak_warning";
    @NonNls
    private static final String INFO_MARKER = "info";
    @NonNls
    private static final String END_LINE_HIGHLIGHT_MARKER = "EOLError";
    @NonNls
    private static final String END_LINE_WARNING_MARKER = "EOLWarning";
    private final PsiFile myFile;
    protected final Map<String, ExpectedHighlightingSet> highlightingTypes;

    public ExpectedHighlightingData(Document document, boolean checkWarnings, boolean checkInfos) {
        this(document, checkWarnings, false, checkInfos);
    }

    public ExpectedHighlightingData(Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        this(document, checkWarnings, checkWeakWarnings, checkInfos, null);
    }

    public ExpectedHighlightingData(Document document, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, PsiFile file) {
        this.myFile = file;
        this.highlightingTypes = new THashMap();
        this.highlightingTypes.put(ERROR_MARKER, new ExpectedHighlightingSet(HighlightInfoType.ERROR, HighlightSeverity.ERROR, false, true));
        this.highlightingTypes.put(WARNING_MARKER, new ExpectedHighlightingSet(HighlightInfoType.UNUSED_SYMBOL, HighlightSeverity.WARNING, false, checkWarnings));
        this.highlightingTypes.put(INFORMATION_MARKER, new ExpectedHighlightingSet(HighlightInfoType.INFO, HighlightSeverity.INFO, false, checkWeakWarnings));
        this.highlightingTypes.put(INFO_MARKER, new ExpectedHighlightingSet(HighlightInfoType.TODO, HighlightSeverity.INFORMATION, false, checkInfos));
        this.highlightingTypes.put(END_LINE_HIGHLIGHT_MARKER, new ExpectedHighlightingSet(HighlightInfoType.ERROR, HighlightSeverity.ERROR, true, true));
        this.highlightingTypes.put(END_LINE_WARNING_MARKER, new ExpectedHighlightingSet(HighlightInfoType.WARNING, HighlightSeverity.WARNING, true, checkWarnings));
        this.initAdditionalHighlightingTypes();
        this.extractExpectedHighlightsSet(document);
    }

    protected void initAdditionalHighlightingTypes() {
    }

    private void extractExpectedHighlightsSet(Document document) {
        Matcher m;
        String text = document.getText();
        Set<String> markers = this.highlightingTypes.keySet();
        String typesRegex = "";
        for (String marker : markers) {
            typesRegex = typesRegex + (typesRegex.length() == 0 ? "" : "|") + "(?:" + marker + ")";
        }
        String pat = ".*?(<(" + typesRegex + ")(?: descr=\\\"((?:[^\\\"\\\\]|\\\\\\\")*)\\\")?(?: type=\\\"([0-9A-Z_]+)\\\")?(?: foreground=\\\"([0-9xa-f]+)\\\")?(?: background=\\\"([0-9xa-f]+)\\\")?(?: effectcolor=\\\"([0-9xa-f]+)\\\")?(?: effecttype=\\\"([A-Z]+)\\\")?(?: fonttype=\\\"([0-9]+)\\\")?(/)?>)(.*)";
        Pattern p = Pattern.compile(pat, 32);
        block3: while ((m = p.matcher(text)).matches()) {
            int endOffset;
            String content;
            String descr;
            int startOffset = m.start(1);
            String marker = m.group(2);
            ExpectedHighlightingSet expectedHighlightingSet = this.highlightingTypes.get(marker);
            while (!expectedHighlightingSet.enabled) {
                if (!m.find()) break block3;
                marker = m.group(2);
                startOffset = m.start(1);
                expectedHighlightingSet = this.highlightingTypes.get(marker);
            }
            int pos = 3;
            if ((descr = m.group(pos++)) == null) {
                descr = "*";
            } else if (descr.equals("null")) {
                descr = null;
            }
            String typeString = m.group(pos++);
            String foregroundColor = m.group(pos++);
            String backgroundColor = m.group(pos++);
            String effectColor = m.group(pos++);
            String effectType = m.group(pos++);
            String fontType = m.group(pos++);
            String closeTagMarker = m.group(pos++);
            String rest = m.group(pos++);
            if (closeTagMarker == null) {
                Pattern pat2 = Pattern.compile("(.*?)</" + marker + ">(.*)", 32);
                Matcher matcher2 = pat2.matcher(rest);
                LOG.assertTrue(matcher2.matches(), "Cannot find closing </" + marker + ">");
                content = matcher2.group(1);
                endOffset = m.start(pos - 1) + matcher2.start(2);
            } else {
                content = "";
                endOffset = m.start(pos - 1);
            }
            document.replaceString(startOffset, endOffset, content);
            TextAttributes forcedAttributes = null;
            if (foregroundColor != null) {
                forcedAttributes = new TextAttributes(Color.decode(foregroundColor), Color.decode(backgroundColor), Color.decode(effectColor), EffectType.valueOf(effectType), Integer.parseInt(fontType));
            }
            TextRange textRange = new TextRange(startOffset, startOffset + content.length());
            HighlightInfo highlightInfo = HighlightInfo.createHighlightInfo((HighlightInfoType)expectedHighlightingSet.defaultErrorType, (TextRange)textRange, (String)descr, (TextAttributes)forcedAttributes);
            HighlightInfoType type = null;
            if (typeString != null) {
                try {
                    Field field = HighlightInfoType.class.getField(typeString);
                    type = (HighlightInfoType)field.get(null);
                }
                catch (Exception e) {
                    LOG.error(e);
                }
                if (type == null) {
                    LOG.assertTrue(false, "Wrong highlight type: " + typeString);
                }
            }
            highlightInfo.type = type;
            highlightInfo.isAfterEndOfLine = expectedHighlightingSet.endOfLine;
            expectedHighlightingSet.infos.add(highlightInfo);
            text = document.getText();
        }
    }

    public Collection<HighlightInfo> getExtractedHighlightInfos() {
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        Collection<ExpectedHighlightingSet> collection = this.highlightingTypes.values();
        for (ExpectedHighlightingSet set : collection) {
            result.addAll(set.infos);
        }
        return result;
    }

    public void checkResult(Collection<HighlightInfo> infos, String text) {
        String fileName = this.myFile == null ? "" : this.myFile.getName() + ": ";
        String failMessage = "";
        for (HighlightInfo info : infos) {
            if (this.expectedInfosContainsInfo(info)) continue;
            int startOffset = info.startOffset;
            int endOffset = info.endOffset;
            String s = text.substring(startOffset, endOffset);
            String desc = info.description;
            int y1 = StringUtil.offsetToLineNumber(text, startOffset);
            int y2 = StringUtil.offsetToLineNumber(text, endOffset);
            int x1 = startOffset - StringUtil.lineColToOffset(text, y1, 0);
            int x2 = endOffset - StringUtil.lineColToOffset(text, y2, 0);
            if (failMessage.length() != 0) {
                failMessage = failMessage + '\n';
            }
            failMessage = failMessage + fileName + "Extra text fragment highlighted " + "(" + (x1 + 1) + ", " + (y1 + 1) + ")" + "-" + "(" + (x2 + 1) + ", " + (y2 + 1) + ")" + " :'" + s + "'" + (desc == null ? "" : " (" + desc + ")") + " [" + info.type + "]";
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.highlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            Set<HighlightInfo> expInfos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : expInfos) {
                if (ExpectedHighlightingData.infosContainsExpectedInfo(infos, expectedInfo) || !highlightingSet.enabled) continue;
                int startOffset = expectedInfo.startOffset;
                int endOffset = expectedInfo.endOffset;
                String s = text.substring(startOffset, endOffset);
                String desc = expectedInfo.description;
                int y1 = StringUtil.offsetToLineNumber(text, startOffset);
                int y2 = StringUtil.offsetToLineNumber(text, endOffset);
                int x1 = startOffset - StringUtil.lineColToOffset(text, y1, 0);
                int x2 = endOffset - StringUtil.lineColToOffset(text, y2, 0);
                if (failMessage.length() != 0) {
                    failMessage = failMessage + '\n';
                }
                failMessage = failMessage + fileName + "Text fragment was not highlighted " + "(" + (x1 + 1) + ", " + (y1 + 1) + ")" + "-" + "(" + (x2 + 1) + ", " + (y2 + 1) + ")" + " :'" + s + "'" + (desc == null ? "" : " (" + desc + ")");
            }
        }
        if (failMessage.length() > 0) {
            Assert.fail((String)failMessage);
        }
    }

    private static boolean infosContainsExpectedInfo(Collection<HighlightInfo> infos, HighlightInfo expectedInfo) {
        for (HighlightInfo info : infos) {
            if (!ExpectedHighlightingData.infoEquals(expectedInfo, info)) continue;
            return true;
        }
        return false;
    }

    private boolean expectedInfosContainsInfo(HighlightInfo info) {
        if (info.getTextAttributes(null) == TextAttributes.ERASE_MARKER) {
            return true;
        }
        Collection<ExpectedHighlightingSet> expectedHighlights = this.highlightingTypes.values();
        for (ExpectedHighlightingSet highlightingSet : expectedHighlights) {
            if (highlightingSet.severity != info.getSeverity()) continue;
            if (!highlightingSet.enabled) {
                return true;
            }
            Set<HighlightInfo> infos = highlightingSet.infos;
            for (HighlightInfo expectedInfo : infos) {
                if (!ExpectedHighlightingData.infoEquals(expectedInfo, info)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean infoEquals(HighlightInfo expectedInfo, HighlightInfo info) {
        if (expectedInfo == info) {
            return true;
        }
        return !(info.getSeverity() != expectedInfo.getSeverity() || info.startOffset + (info.isAfterEndOfLine ? 1 : 0) != expectedInfo.startOffset || info.endOffset != expectedInfo.endOffset || info.isAfterEndOfLine != expectedInfo.isAfterEndOfLine || expectedInfo.type != null && !expectedInfo.type.equals(info.type) || !Comparing.strEqual("*", expectedInfo.description) && !Comparing.strEqual(info.description, expectedInfo.description) || expectedInfo.forcedTextAttributes != null && !expectedInfo.getTextAttributes(null).equals(info.getTextAttributes(null)));
    }

    protected static class ExpectedHighlightingSet {
        private final boolean endOfLine;
        final boolean enabled;
        final Set<HighlightInfo> infos;
        final HighlightInfoType defaultErrorType;
        final HighlightSeverity severity;

        public ExpectedHighlightingSet(HighlightInfoType defaultErrorType, HighlightSeverity severity, boolean endOfLine, boolean enabled) {
            this.endOfLine = endOfLine;
            this.enabled = enabled;
            this.infos = new THashSet();
            this.defaultErrorType = defaultErrorType;
            this.severity = severity;
        }
    }
}

