/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.testFramework.builders.JavaModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.IdeaTestFixtureFactory;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractVcsTestCase {
    protected Project myProject;
    protected VirtualFile myWorkingCopyDir;
    protected File myClientBinaryPath;
    protected IdeaProjectTestFixture myProjectFixture;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RunResult runClient(String exeName, @Nullable String stdin, @Nullable File workingDir, String[] commandLine) throws IOException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(new File(this.myClientBinaryPath, exeName).toString());
        Collections.addAll(arguments, commandLine);
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(arguments);
        if (workingDir != null) {
            builder.directory(workingDir);
        }
        Process clientProcess = builder.start();
        final RunResult result = new RunResult();
        if (stdin != null) {
            OutputStream outputStream = clientProcess.getOutputStream();
            try {
                byte[] bytes = stdin.getBytes();
                outputStream.write(bytes);
            }
            finally {
                outputStream.close();
            }
        }
        OSProcessHandler handler = new OSProcessHandler(clientProcess, ""){

            public Charset getCharset() {
                return CharsetToolkit.getDefaultSystemCharset();
            }
        };
        handler.addProcessListener(new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                if (outputType == ProcessOutputTypes.STDOUT) {
                    result.stdOut = result.stdOut + event.getText();
                } else if (outputType == ProcessOutputTypes.STDERR) {
                    result.stdErr = result.stdErr + event.getText();
                }
            }
        });
        handler.startNotify();
        handler.waitFor();
        result.exitCode = clientProcess.exitValue();
        return result;
    }

    protected void initProject(final File clientRoot) throws Exception {
        TestFixtureBuilder<IdeaProjectTestFixture> testFixtureBuilder = IdeaTestFixtureFactory.getFixtureFactory().createFixtureBuilder();
        this.myProjectFixture = testFixtureBuilder.getFixture();
        testFixtureBuilder.addModule(JavaModuleFixtureBuilder.class).addContentRoot(clientRoot.toString());
        this.myProjectFixture.setUp();
        this.myProject = this.myProjectFixture.getProject();
        ((ProjectComponent)((Object)ChangeListManager.getInstance(this.myProject))).projectOpened();
        ((ProjectComponent)((Object)VcsDirtyScopeManager.getInstance(this.myProject))).projectOpened();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            public void run() {
                AbstractVcsTestCase.this.myWorkingCopyDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(clientRoot);
                assert (AbstractVcsTestCase.this.myWorkingCopyDir != null);
            }
        });
    }

    protected void activateVCS(String vcsName) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        vcsManager.setDirectoryMapping(this.myWorkingCopyDir.getPath(), vcsName);
        vcsManager.updateActiveVcss();
        AbstractVcs vcs = vcsManager.findVcsByName(vcsName);
        Assert.assertEquals((long)1L, (long)vcsManager.getRootsUnderVcs(vcs).length);
    }

    protected VirtualFile createFileInCommand(String name, @Nullable String content) {
        return this.createFileInCommand(this.myWorkingCopyDir, name, content);
    }

    protected VirtualFile createFileInCommand(final VirtualFile parent, final String name, final @Nullable String content) {
        final Ref result = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            public void run() {
                try {
                    VirtualFile file = parent.createChildData(this, name);
                    if (content != null) {
                        file.setBinaryContent(CharsetToolkit.getUtf8Bytes(content));
                    }
                    result.set(file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "", null);
        return (VirtualFile)result.get();
    }

    protected VirtualFile createDirInCommand(final VirtualFile parent, final String name) {
        final Ref result = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            public void run() {
                try {
                    VirtualFile dir = parent.createChildDirectory(this, name);
                    result.set(dir);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "", null);
        return (VirtualFile)result.get();
    }

    protected void tearDownProject() throws Exception {
        if (this.myProject != null) {
            ((ProjectComponent)((Object)VcsDirtyScopeManager.getInstance(this.myProject))).projectClosed();
            ((ProjectComponent)((Object)ChangeListManager.getInstance(this.myProject))).projectClosed();
            ((ProjectComponent)((Object)ProjectLevelVcsManager.getInstance(this.myProject))).projectClosed();
            this.myProject = null;
        }
        if (this.myProjectFixture != null) {
            this.myProjectFixture.tearDown();
            this.myProjectFixture = null;
        }
    }

    protected void setStandardConfirmation(String vcsName, VcsConfiguration.StandardConfirmation op, VcsShowConfirmationOption.Value value) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance(this.myProject);
        AbstractVcs vcs = vcsManager.findVcsByName(vcsName);
        VcsShowConfirmationOption option = vcsManager.getStandardConfirmation(op, vcs);
        option.setValue(value);
    }

    protected static void verify(RunResult runResult) {
        Assert.assertEquals((String)runResult.stdErr, (long)0L, (long)runResult.exitCode);
    }

    protected static void verify(RunResult runResult, String ... stdoutLines) {
        AbstractVcsTestCase.verify(runResult, false, stdoutLines);
    }

    protected static void verifySorted(RunResult runResult, String ... stdoutLines) {
        AbstractVcsTestCase.verify(runResult, true, stdoutLines);
    }

    private static void verify(RunResult runResult, boolean sorted, String ... stdoutLines) {
        AbstractVcsTestCase.verify(runResult);
        Object[] lines = new LineTokenizer(runResult.stdOut).execute();
        if (sorted) {
            Arrays.sort(lines);
        }
        Assert.assertEquals((String)runResult.stdOut, (long)stdoutLines.length, (long)lines.length);
        for (int i = 0; i < stdoutLines.length; ++i) {
            Assert.assertEquals((Object)stdoutLines[i], (Object)AbstractVcsTestCase.compressWhitespace((String)lines[i]));
        }
    }

    private static String compressWhitespace(String line) {
        while (line.indexOf("  ") > 0) {
            line = line.replace("  ", " ");
        }
        return line.trim();
    }

    protected VcsDirtyScope getAllDirtyScope() {
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance(this.myProject);
        dirtyScopeManager.markEverythingDirty();
        List<VcsDirtyScope> scopes = dirtyScopeManager.retrieveScopes();
        Assert.assertEquals((long)1L, (long)scopes.size());
        return scopes.get(0);
    }

    protected VcsDirtyScope getDirtyScopeForFile(VirtualFile file) {
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance(this.myProject);
        dirtyScopeManager.retrieveScopes();
        dirtyScopeManager.fileDirty(file);
        List<VcsDirtyScope> scopes = dirtyScopeManager.retrieveScopes();
        Assert.assertEquals((long)1L, (long)scopes.size());
        return scopes.get(0);
    }

    protected void renameFileInCommand(VirtualFile file, String newName) {
        AbstractVcsTestCase.renameFileInCommand(this.myProject, file, newName);
    }

    public static void renameFileInCommand(Project project, final VirtualFile file, final String newName) {
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            public void run() {
                try {
                    file.rename(this, newName);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "", null);
    }

    protected void renamePsiInCommand(final PsiNamedElement element, final String newName) {
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            public void run() {
                try {
                    element.setName(newName);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "", null);
    }

    protected void deleteFileInCommand(VirtualFile file) {
        AbstractVcsTestCase.deleteFileInCommand(this.myProject, file);
    }

    public static void deleteFileInCommand(Project project, final VirtualFile file) {
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            public void run() {
                try {
                    file.delete(this);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, "", file);
    }

    protected void copyFileInCommand(final VirtualFile file, final String toName) {
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            public void run() {
                try {
                    file.copy(this, file.getParent(), toName);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "", null);
    }

    protected void moveFileInCommand(VirtualFile file, VirtualFile newParent) {
        AbstractVcsTestCase.moveFileInCommand(this.myProject, file, newParent);
    }

    public static void moveFileInCommand(Project project, final VirtualFile file, final VirtualFile newParent) {
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            public void run() {
                try {
                    file.move(this, newParent);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, "", null);
    }

    protected void verifyChange(Change c, String beforePath, String afterPath) {
        if (beforePath == null) {
            Assert.assertNull((Object)c.getBeforeRevision());
        } else {
            this.verifyRevision(c.getBeforeRevision(), beforePath);
        }
        if (afterPath == null) {
            Assert.assertNull((Object)c.getAfterRevision());
        } else {
            this.verifyRevision(c.getAfterRevision(), afterPath);
        }
    }

    private void verifyRevision(ContentRevision beforeRevision, String beforePath) {
        File beforeFile = new File(this.myWorkingCopyDir.getPath(), beforePath);
        String beforeFullPath = FileUtil.toSystemIndependentName(beforeFile.getPath());
        String beforeRevPath = FileUtil.toSystemIndependentName(beforeRevision.getFile().getPath());
        Assert.assertTrue((boolean)beforeFullPath.equalsIgnoreCase(beforeRevPath));
    }

    public static void sortChanges(List<Change> changes) {
        Collections.sort(changes, new Comparator<Change>(){

            @Override
            public int compare(Change o1, Change o2) {
                String p1 = FileUtil.toSystemIndependentName(ChangesUtil.getFilePath(o1).getPath());
                String p2 = FileUtil.toSystemIndependentName(ChangesUtil.getFilePath(o2).getPath());
                return p1.compareTo(p2);
            }
        });
    }

    protected static class RunResult {
        public int exitCode = -1;
        public String stdOut = "";
        public String stdErr = "";

        protected RunResult() {
        }
    }
}

