/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.Nullable;

public class MoveRenameUsageInfo
extends UsageInfo {
    private SmartPsiElementPointer myReferencedElementPointer = null;
    private PsiElement myReferencedElement;
    private PsiReference myReference;
    private RangeMarker myReferenceRangeMarker = null;

    public MoveRenameUsageInfo(PsiReference reference, PsiElement referencedElement) {
        this(reference.getElement(), reference, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element, PsiReference reference, PsiElement referencedElement) {
        super(element);
        this.init(element, reference, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element, PsiReference reference, int startOffset, int endOffset, PsiElement referencedElement, boolean nonCodeUsage) {
        super(element, startOffset, endOffset, nonCodeUsage);
        this.init(element, reference, referencedElement);
    }

    private void init(PsiElement element, PsiReference reference, PsiElement referencedElement) {
        Project project = element.getProject();
        this.myReferencedElement = referencedElement;
        if (referencedElement != null) {
            this.myReferencedElementPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(referencedElement);
        }
        if (reference == null) {
            reference = element.getReference();
        }
        if (reference == null) {
            reference = element.getContainingFile().findReferenceAt(element.getTextRange().getStartOffset());
        }
        this.myReference = reference;
        if (reference != null) {
            Document document = PsiDocumentManager.getInstance(project).getDocument(element.getContainingFile());
            int elementStart = element.getTextRange().getStartOffset();
            this.myReferenceRangeMarker = document.createRangeMarker(elementStart + reference.getRangeInElement().getStartOffset(), elementStart + reference.getRangeInElement().getEndOffset());
        }
    }

    @Nullable
    public PsiElement getUpToDateReferencedElement() {
        return this.myReferencedElementPointer == null ? null : (PsiElement)this.myReferencedElementPointer.getElement();
    }

    @Nullable
    public PsiElement getReferencedElement() {
        return this.myReferencedElement;
    }

    @Nullable
    public PsiReference getReference() {
        PsiElement element;
        if (this.myReference != null && (element = this.myReference.getElement()) != null && !(element instanceof PsiFile) && element.isValid()) {
            return this.myReference;
        }
        if (this.myReferenceRangeMarker == null) {
            return null;
        }
        element = this.getElement();
        if (element == null) {
            return null;
        }
        int start = this.myReferenceRangeMarker.getStartOffset() - element.getTextRange().getStartOffset();
        int end = this.myReferenceRangeMarker.getEndOffset() - element.getTextRange().getStartOffset();
        PsiReference reference = element.findReferenceAt(start);
        if (reference == null) {
            return null;
        }
        TextRange rangeInElement = reference.getRangeInElement();
        if (rangeInElement.getStartOffset() != start || rangeInElement.getEndOffset() != end) {
            return null;
        }
        return reference;
    }
}

