/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictsDialog
extends DialogWrapper {
    private String[] myConflictDescriptions;

    public ConflictsDialog(Project project, Collection<String> conflictDescriptions) {
        this(project, conflictDescriptions.toArray(new String[conflictDescriptions.size()]));
    }

    public ConflictsDialog(Project project, String ... conflictDescriptions) {
        super(project, true);
        this.myConflictDescriptions = conflictDescriptions;
        this.setTitle(RefactoringBundle.message("problems.detected.title", new Object[0]));
        this.setOKButtonText(RefactoringBundle.message("continue.button", new Object[0]));
        this.init();
    }

    @Override
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), new CancelAction()};
    }

    @Override
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String contentType = "text/html";
        JEditorPane messagePane = new JEditorPane("text/html", "");
        messagePane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(messagePane);
        scrollPane.setPreferredSize(new Dimension(500, 400));
        panel.add((Component)new JLabel(RefactoringBundle.message("the.following.problems.were.found", new Object[0])), "North");
        panel.add((Component)scrollPane, "Center");
        StringBuffer buf = new StringBuffer();
        for (String description : this.myConflictDescriptions) {
            buf.append(description);
            buf.append("<br><br>");
        }
        messagePane.setText(buf.toString());
        return panel;
    }

    @Override
    protected JComponent createSouthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)super.createSouthPanel(), "Center");
        panel.add((Component)new JLabel(RefactoringBundle.message("do.you.wish.to.ignore.them.and.continue", new Object[0])), "West");
        return panel;
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(RefactoringBundle.message("cancel.button", new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent e) {
            ConflictsDialog.this.doCancelAction();
        }
    }
}

