/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameInputValidatorRegistry {
    private static RenameInputValidatorRegistry ourInstance = new RenameInputValidatorRegistry();
    private List<Pair<ElementFilter, Condition<String>>> myValidators = new ArrayList<Pair<ElementFilter, Condition<String>>>();

    public static RenameInputValidatorRegistry getInstance() {
        return ourInstance;
    }

    private RenameInputValidatorRegistry() {
    }

    public void registerInputValidator(@NotNull ElementFilter filter, @NotNull Condition<String> validator) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/RenameInputValidatorRegistry.registerInputValidator must not be null");
        }
        if (validator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/rename/RenameInputValidatorRegistry.registerInputValidator must not be null");
        }
        this.myValidators.add(new Pair<ElementFilter, Condition<String>>(filter, validator));
    }

    @Nullable
    public Condition<String> getInputValidator(PsiElement element) {
        for (Pair<ElementFilter, Condition<String>> pair : this.myValidators) {
            if (!((ElementFilter)pair.first).isAcceptable(element, element)) continue;
            return (Condition)pair.second;
        }
        return null;
    }
}

