/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleCachedValueProvider<T, F extends PsiFile> {
    private final Key<Value> myKey;

    public SimpleCachedValueProvider(@NonNls String keyName) {
        this.myKey = new Key(keyName);
    }

    @Nullable
    public T getValue(F file) {
        Value value = file.getUserData(this.myKey);
        if (value == null) {
            value = new Value();
            file.putUserData(this.myKey, (Value)value);
        }
        return value.getValue(file);
    }

    protected abstract T updateValue(F var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Value {
        private long myModificationStamp;
        private boolean myWritable;
        @Nullable
        private T myValue;

        private Value() {
        }

        @Nullable
        protected T getValue(F file) {
            if (file.getModificationStamp() != this.myModificationStamp || file.isWritable() != this.myWritable) {
                this.myValue = SimpleCachedValueProvider.this.updateValue(file);
                this.myModificationStamp = file.getModificationStamp();
                this.myWritable = file.isWritable();
            }
            return this.myValue;
        }
    }
}

