/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassLevelDeclarationStatement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.meta.PsiMetaBaseOwner;
import com.intellij.psi.meta.PsiMetaDataBase;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.IsConstantExpressionVisitor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PsiUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PsiUtil");
    public static final int ACCESS_LEVEL_PUBLIC = 4;
    public static final int ACCESS_LEVEL_PROTECTED = 3;
    public static final int ACCESS_LEVEL_PACKAGE_LOCAL = 2;
    public static final int ACCESS_LEVEL_PRIVATE = 1;
    public static final Key<Boolean> VALID_VOID_TYPE_IN_CODE_FRAGMENT = Key.create("VALID_VOID_TYPE_IN_CODE_FRAGMENT");
    public static final Key<PsiElement> ORIGINAL_KEY = Key.create("ORIGINAL_KEY");
    public static final PsiParser NULL_PARSER = new PsiParser(){

        @NotNull
        public ASTNode parse(IElementType root, PsiBuilder builder) {
            throw new IllegalAccessError();
        }
    };
    public static final PsiElement NULL_PSI_ELEMENT = new PsiElement(){

        @Override
        @NotNull
        public Project getProject() {
            throw new PsiInvalidElementAccessException(this);
        }

        @Override
        @NotNull
        public Language getLanguage() {
            throw new IllegalAccessError();
        }

        @Override
        public PsiManager getManager() {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public PsiElement[] getChildren() {
            PsiElement[] psiElementArray = new PsiElement[]{};
            if (psiElementArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil$2.getChildren must not return null");
            }
            return psiElementArray;
        }

        @Override
        public PsiElement getParent() {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getFirstChild() {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getLastChild() {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getNextSibling() {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getPrevSibling() {
            return null;
        }

        @Override
        public PsiFile getContainingFile() {
            throw new PsiInvalidElementAccessException(this);
        }

        @Override
        public TextRange getTextRange() {
            return null;
        }

        @Override
        public int getStartOffsetInParent() {
            return 0;
        }

        @Override
        public int getTextLength() {
            return 0;
        }

        @Override
        public PsiElement findElementAt(int offset) {
            return null;
        }

        @Override
        @Nullable
        public PsiReference findReferenceAt(int offset) {
            return null;
        }

        @Override
        public int getTextOffset() {
            return 0;
        }

        @Override
        public String getText() {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public char[] textToCharArray() {
            char[] cArray = new char[]{};
            if (cArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil$2.textToCharArray must not return null");
            }
            return cArray;
        }

        @Override
        public PsiElement getNavigationElement() {
            return null;
        }

        @Override
        public PsiElement getOriginalElement() {
            return null;
        }

        @Override
        public boolean textMatches(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.textMatches must not be null");
            }
            return false;
        }

        @Override
        public boolean textMatches(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.textMatches must not be null");
            }
            return false;
        }

        @Override
        public boolean textContains(char c) {
            return false;
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.accept must not be null");
            }
        }

        @Override
        public void acceptChildren(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.acceptChildren must not be null");
            }
        }

        @Override
        public PsiElement copy() {
            return null;
        }

        @Override
        public PsiElement add(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.add must not be null");
            }
            return null;
        }

        @Override
        public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.addBefore must not be null");
            }
            return null;
        }

        @Override
        public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.addAfter must not be null");
            }
            return null;
        }

        @Override
        public void checkAdd(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.checkAdd must not be null");
            }
        }

        @Override
        public PsiElement addRange(PsiElement first, PsiElement last) {
            return null;
        }

        @Override
        public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) {
            if (first == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.addRangeBefore must not be null");
            }
            if (last == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.addRangeBefore must not be null");
            }
            return null;
        }

        @Override
        public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) {
            return null;
        }

        @Override
        public void delete() {
        }

        @Override
        public void checkDelete() {
        }

        @Override
        public void deleteChildRange(PsiElement first, PsiElement last) {
        }

        @Override
        public PsiElement replace(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.replace must not be null");
            }
            return null;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        @Nullable
        public PsiReference getReference() {
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public PsiReference[] getReferences() {
            PsiReference[] psiReferenceArray = new PsiReference[]{};
            if (psiReferenceArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil$2.getReferences must not return null");
            }
            return psiReferenceArray;
        }

        @Override
        public <T> T getCopyableUserData(Key<T> key) {
            return null;
        }

        @Override
        public <T> void putCopyableUserData(Key<T> key, T value) {
        }

        @Override
        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull PsiSubstitutor substitutor, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.processDeclarations must not be null");
            }
            if (substitutor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.processDeclarations must not be null");
            }
            if (place == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/PsiUtil$2.processDeclarations must not be null");
            }
            return false;
        }

        @Override
        public PsiElement getContext() {
            return null;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public GlobalSearchScope getResolveScope() {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil$2.getResolveScope must not return null");
            }
            return globalSearchScope;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public SearchScope getUseScope() {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil$2.getUseScope must not return null");
            }
            return globalSearchScope;
        }

        @Override
        public ASTNode getNode() {
            return null;
        }

        @Override
        public <T> T getUserData(Key<T> key) {
            return null;
        }

        @Override
        public <T> void putUserData(Key<T> key, T value) {
        }

        @Override
        public Icon getIcon(int flags) {
            return null;
        }
    };
    private static final String[] accessModifiers = new String[]{"private", "packageLocal", "protected", "public"};
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY = Key.create("FORCE_LANGUAGE_LEVEL");
    public static final Comparator<PsiElement> BY_POSITION = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement o1, PsiElement o2) {
            return PsiUtil.compareElementsByPosition(o1, o2);
        }
    };

    private PsiUtil() {
    }

    public static boolean isOnAssignmentLeftHand(PsiExpression expr) {
        PsiElement parent = expr.getParent();
        return parent instanceof PsiAssignmentExpression && expr.equals(((PsiAssignmentExpression)parent).getLExpression());
    }

    public static boolean isAccessibleFromPackage(@NotNull PsiModifierListOwner element, @NotNull PsiPackage aPackage) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isAccessibleFromPackage must not be null");
        }
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isAccessibleFromPackage must not be null");
        }
        if (element.hasModifierProperty("public")) {
            return true;
        }
        if (element.hasModifierProperty("private")) {
            return false;
        }
        return element.getManager().isInPackage(element, aPackage);
    }

    public static boolean isAccessedForWriting(PsiExpression expr) {
        if (PsiUtil.isOnAssignmentLeftHand(expr)) {
            return true;
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof PsiPrefixExpression) {
            IElementType tokenType = ((PsiPrefixExpression)parent).getOperationTokenType();
            return tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS;
        }
        if (parent instanceof PsiPostfixExpression) {
            IElementType tokenType = ((PsiPostfixExpression)parent).getOperationTokenType();
            return tokenType == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS;
        }
        return false;
    }

    public static boolean isAccessedForReading(PsiExpression expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof PsiAssignmentExpression && expr.equals(((PsiAssignmentExpression)parent).getLExpression())) {
            return ((PsiAssignmentExpression)parent).getOperationSign().getTokenType() != JavaTokenType.EQ;
        }
        return true;
    }

    public static boolean isAccessible(PsiMember member, PsiElement place, PsiClass accessObjectClass) {
        return place.getManager().getResolveHelper().isAccessible(member, place, accessObjectClass);
    }

    public static JavaResolveResult getAccessObjectClass(PsiExpression accessObject) {
        if (accessObject instanceof PsiSuperExpression) {
            PsiJavaCodeReferenceElement qualifier = ((PsiSuperExpression)accessObject).getQualifier();
            if (qualifier != null) {
                JavaResolveResult result = qualifier.advancedResolve(false);
                PsiElement resolve = result.getElement();
                if (resolve instanceof PsiClass) {
                    PsiClass psiClass;
                    PsiSubstitutor substitutor;
                    if (resolve instanceof PsiTypeParameter) {
                        PsiClassType parameterType = resolve.getManager().getElementFactory().createType((PsiTypeParameter)resolve);
                        PsiType superType = result.getSubstitutor().substitute(parameterType);
                        if (superType instanceof PsiArrayType) {
                            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(accessObject);
                            return resolve.getManager().getElementFactory().getArrayClassType(((PsiArrayType)superType).getComponentType(), languageLevel).resolveGenerics();
                        }
                        if (superType instanceof PsiClassType) {
                            PsiClassType type = (PsiClassType)superType;
                            substitutor = type.resolveGenerics().getSubstitutor();
                            psiClass = type.resolve();
                        } else {
                            psiClass = null;
                            substitutor = PsiSubstitutor.EMPTY;
                        }
                    } else {
                        psiClass = (PsiClass)resolve;
                        substitutor = PsiSubstitutor.EMPTY;
                    }
                    if (psiClass != null) {
                        return new CandidateInfo(psiClass, substitutor);
                    }
                    return JavaResolveResult.EMPTY;
                }
                return JavaResolveResult.EMPTY;
            }
            PsiElement scope = accessObject.getContext();
            PsiElement lastParent = accessObject;
            while (scope != null) {
                if (scope instanceof PsiClass) {
                    if (scope instanceof PsiAnonymousClass && lastParent instanceof PsiExpressionList) {
                        lastParent = scope;
                        scope = scope.getContext();
                        continue;
                    }
                    return new CandidateInfo(scope, PsiSubstitutor.EMPTY);
                }
                lastParent = scope;
                scope = scope.getContext();
            }
            return JavaResolveResult.EMPTY;
        }
        PsiType type = accessObject.getType();
        if (!(type instanceof PsiClassType)) {
            return JavaResolveResult.EMPTY;
        }
        return ((PsiClassType)type).resolveGenerics();
    }

    public static boolean isConstantExpression(PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        IsConstantExpressionVisitor visitor = new IsConstantExpressionVisitor();
        expression.accept(visitor);
        return visitor.myIsConstant;
    }

    public static void addException(PsiMethod method, @NonNls String exceptionFQName) throws IncorrectOperationException {
        PsiClass exceptionClass = method.getManager().findClass(exceptionFQName, method.getResolveScope());
        PsiUtil.addException(method, exceptionClass, exceptionFQName);
    }

    public static void addException(PsiMethod method, PsiClass exceptionClass) throws IncorrectOperationException {
        PsiUtil.addException(method, exceptionClass, exceptionClass.getQualifiedName());
    }

    private static void addException(PsiMethod method, PsiClass exceptionClass, String exceptionName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref;
        PsiJavaCodeReferenceElement[] refs;
        PsiReferenceList throwsList = method.getThrowsList();
        for (PsiJavaCodeReferenceElement ref2 : refs = throwsList.getReferenceElements()) {
            if (ref2.isReferenceTo(exceptionClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)ref2.resolve();
            if (exceptionClass == null || aClass == null) continue;
            if (aClass.isInheritor(exceptionClass, true)) {
                PsiJavaCodeReferenceElement ref1;
                PsiElementFactory factory = method.getManager().getElementFactory();
                if (exceptionName != null) {
                    ref1 = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
                } else {
                    PsiClassType type = factory.createType(exceptionClass);
                    ref1 = factory.createReferenceElementByType(type);
                }
                ref2.replace(ref1);
                return;
            }
            if (!exceptionClass.isInheritor(aClass, true)) continue;
            return;
        }
        PsiElementFactory factory = method.getManager().getElementFactory();
        if (exceptionName != null) {
            ref = factory.createReferenceElementByFQClassName(exceptionName, method.getResolveScope());
        } else {
            PsiClassType type = factory.createType(exceptionClass);
            ref = factory.createReferenceElementByType(type);
        }
        throwsList.add(ref);
    }

    public static void removeException(PsiMethod method, @NonNls String exceptionClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = method.getThrowsList().getReferenceElements()) {
            if (!ref.getCanonicalText().equals(exceptionClass)) continue;
            ref.delete();
        }
    }

    public static boolean isVariableNameUnique(String name, PsiElement place) {
        PsiResolveHelper helper = place.getManager().getResolveHelper();
        return helper.resolveReferencedVariable(name, place) == null;
    }

    public static void updatePackageStatement(PsiFile file) throws IncorrectOperationException {
        if (!(file instanceof PsiJavaFile) || PsiUtil.isInJspFile(file)) {
            return;
        }
        PsiManager manager = file.getManager();
        PsiElementFactory factory = manager.getElementFactory();
        PsiDirectory dir = file.getContainingDirectory();
        if (dir == null) {
            return;
        }
        PsiPackage aPackage = dir.getPackage();
        if (aPackage == null) {
            return;
        }
        String packageName = aPackage.getQualifiedName();
        PsiPackageStatement statement = ((PsiJavaFile)file).getPackageStatement();
        if (statement != null) {
            if (packageName.length() > 0) {
                statement.getPackageReference().bindToElement(aPackage);
            } else {
                statement.delete();
            }
        } else if (packageName.length() > 0) {
            String text = "package " + packageName + ";";
            String ext = StdFileTypes.JAVA.getDefaultExtension();
            PsiJavaFile dummyFile = (PsiJavaFile)factory.createFileFromText("_Dummy_." + ext, text);
            statement = dummyFile.getPackageStatement();
            if (statement == null) {
                throw new IncorrectOperationException();
            }
            file.add(statement);
        }
    }

    public static PsiElement getTopLevelEnclosingCodeBlock(PsiElement element, PsiElement scope) {
        PsiElement blockSoFar = null;
        while (element != null) {
            PsiElement parent;
            if (element instanceof PsiCodeBlock || element instanceof PsiForStatement || element instanceof PsiForeachStatement) {
                blockSoFar = element;
            }
            if ((parent = element.getParent()) instanceof PsiMethod && parent.getParent() instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)parent.getParent()) || parent instanceof PsiClassInitializer && !(parent.getParent() instanceof PsiAnonymousClass)) break;
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                blockSoFar = element;
            }
            if (parent instanceof JspClassLevelDeclarationStatement) {
                parent = parent.getParent();
            }
            if (element instanceof PsiClass && !PsiUtil.isLocalOrAnonymousClass((PsiClass)element)) break;
            if (PsiUtil.isInJspFile(element) && element instanceof PsiFile) {
                return element;
            }
            if (element == scope) break;
            element = parent;
        }
        return blockSoFar;
    }

    public static boolean isInJspFile(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language == StdLanguages.JSP || language == StdLanguages.JSPX;
    }

    public static boolean isLocalOrAnonymousClass(PsiClass psiClass) {
        return psiClass instanceof PsiAnonymousClass || PsiUtil.isLocalClass(psiClass);
    }

    public static boolean isLocalClass(PsiClass psiClass) {
        PsiElement parent = psiClass.getParent();
        return parent instanceof PsiDeclarationStatement && parent.getParent() instanceof PsiCodeBlock;
    }

    @Nullable
    public static PsiElement getVariableCodeBlock(PsiVariable variable, PsiElement context) {
        PsiElement codeBlock = null;
        if (variable instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)variable).getDeclarationScope();
            if (declarationScope instanceof PsiCatchSection) {
                codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
            } else if (declarationScope instanceof PsiForeachStatement) {
                codeBlock = ((PsiForeachStatement)declarationScope).getBody();
            } else if (declarationScope instanceof PsiMethod) {
                codeBlock = ((PsiMethod)declarationScope).getBody();
            }
        } else {
            if (variable instanceof PsiLocalVariable && variable.getParent() instanceof PsiForStatement) {
                return variable.getParent();
            }
            if (variable instanceof PsiField && context != null) {
                PsiClass aClass = ((PsiField)variable).getContainingClass();
                while (context != null && context.getParent() != aClass) {
                    if (!((context = context.getParent()) instanceof JspClassLevelDeclarationStatement)) continue;
                    return null;
                }
                return context instanceof PsiMethod ? ((PsiMethod)context).getBody() : (context instanceof PsiClassInitializer ? ((PsiClassInitializer)context).getBody() : null);
            }
            PsiElement scope = variable.getParent() == null ? null : variable.getParent().getParent();
            codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(variable, scope);
            if (codeBlock != null && codeBlock.getParent() instanceof PsiSwitchStatement) {
                codeBlock = codeBlock.getParent().getParent();
            }
        }
        return codeBlock;
    }

    public static boolean isIncrementDecrementOperation(PsiElement element) {
        IElementType sign;
        return element instanceof PsiPostfixExpression ? (sign = ((PsiPostfixExpression)element).getOperationSign().getTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS : element instanceof PsiPrefixExpression && ((sign = ((PsiPrefixExpression)element).getOperationSign().getTokenType()) == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS);
    }

    public static int getAccessLevel(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.getAccessLevel must not be null");
        }
        if (modifierList.hasModifierProperty("private")) {
            return 1;
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            return 2;
        }
        if (modifierList.hasModifierProperty("protected")) {
            return 3;
        }
        return 4;
    }

    @Nullable
    public static String getAccessModifier(int accessLevel) {
        return accessLevel > accessModifiers.length ? null : accessModifiers[accessLevel - 1];
    }

    @Nullable
    public static PsiFile findRelativeFile(String uri, PsiElement base) {
        if (base instanceof PsiFile) {
            PsiFile baseFile = (PsiFile)base;
            if (baseFile.getOriginalFile() != null) {
                return PsiUtil.findRelativeFile(uri, baseFile.getOriginalFile());
            }
            VirtualFile file = VfsUtil.findRelativeFile(uri, baseFile.getVirtualFile());
            if (file == null) {
                return null;
            }
            return base.getManager().findFile(file);
        }
        if (base instanceof PsiDirectory) {
            PsiDirectory baseDir = (PsiDirectory)base;
            VirtualFile file = VfsUtil.findRelativeFile(uri, baseDir.getVirtualFile());
            if (file == null) {
                return null;
            }
            return base.getManager().findFile(file);
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findRelativeDirectory(String uri, PsiElement base) {
        if (base instanceof PsiFile) {
            PsiFile baseFile = (PsiFile)base;
            if (baseFile.getOriginalFile() != null) {
                return PsiUtil.findRelativeDirectory(uri, baseFile.getOriginalFile());
            }
            VirtualFile file = VfsUtil.findRelativeFile(uri, baseFile.getVirtualFile());
            if (file == null) {
                return null;
            }
            return base.getManager().findDirectory(file);
        }
        if (base instanceof PsiDirectory) {
            PsiDirectory baseDir = (PsiDirectory)base;
            VirtualFile file = VfsUtil.findRelativeFile(uri, baseDir.getVirtualFile());
            if (file == null) {
                return null;
            }
            return base.getManager().findDirectory(file);
        }
        return null;
    }

    public static boolean isStatement(PsiElement element) {
        PsiElement parent = element.getParent();
        if (element instanceof PsiExpressionListStatement) {
            PsiExpression[] expressions;
            if (!(parent instanceof PsiForStatement)) {
                return false;
            }
            PsiForStatement forStatement = (PsiForStatement)parent;
            if (element != forStatement.getInitialization() && element != forStatement.getUpdate()) {
                return false;
            }
            PsiExpressionList expressionList = ((PsiExpressionListStatement)element).getExpressionList();
            for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                if (PsiUtil.isStatement(expression)) continue;
                return false;
            }
            return true;
        }
        if (element instanceof PsiExpressionStatement) {
            return PsiUtil.isStatement(((PsiExpressionStatement)element).getExpression());
        }
        if (element instanceof PsiDeclarationStatement) {
            if (parent instanceof PsiCodeBlock) {
                return true;
            }
            if (parent instanceof PsiCodeFragment) {
                return true;
            }
            if (!(parent instanceof PsiForStatement) || ((PsiForStatement)parent).getBody() == element) {
                return false;
            }
        }
        if (element instanceof PsiStatement) {
            return true;
        }
        if (element instanceof PsiAssignmentExpression) {
            return true;
        }
        if (PsiUtil.isIncrementDecrementOperation(element)) {
            return true;
        }
        if (element instanceof PsiMethodCallExpression) {
            return true;
        }
        if (element instanceof PsiNewExpression) {
            return !(((PsiNewExpression)element).getType() instanceof PsiArrayType);
        }
        return element instanceof PsiCodeBlock;
    }

    @Nullable
    public static PsiElement getEnclosingStatement(PsiElement element) {
        while (element != null) {
            if (element.getParent() instanceof PsiCodeBlock) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiElement getElementInclusiveRange(PsiElement scope, TextRange range) {
        PsiElement psiElement;
        for (psiElement = scope.findElementAt(range.getStartOffset()); psiElement != null && !psiElement.getTextRange().contains(range); psiElement = psiElement.getParent()) {
            if (psiElement != scope) continue;
            return null;
        }
        return psiElement;
    }

    @Nullable
    public static PsiClass resolveClassInType(PsiType type) {
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveClassInType(((PsiArrayType)type).getComponentType());
        }
        return null;
    }

    public static PsiClassType.ClassResolveResult resolveGenericsClassInType(PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            return classType.resolveGenerics();
        }
        if (type instanceof PsiArrayType) {
            return PsiUtil.resolveGenericsClassInType(((PsiArrayType)type).getComponentType());
        }
        return PsiClassType.ClassResolveResult.EMPTY;
    }

    public static PsiType convertAnonymousToBaseType(PsiType type) {
        PsiClass psiClass = PsiUtil.resolveClassInType(type);
        if (psiClass instanceof PsiAnonymousClass) {
            int dims = type.getArrayDimensions();
            type = ((PsiAnonymousClass)psiClass).getBaseClassType();
            while (dims != 0) {
                type = type.createArrayType();
                --dims;
            }
        }
        return type;
    }

    public static String getName(PsiElement element) {
        PsiMetaDataBase data;
        String name = null;
        if (element instanceof PsiMetaBaseOwner && (data = ((PsiMetaBaseOwner)((Object)element)).getMetaData()) != null) {
            name = data.getName(element);
        }
        if (name == null && element instanceof PsiNamedElement) {
            name = ((PsiNamedElement)element).getName();
        }
        return name;
    }

    public static boolean isApplicable(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpressionList argList) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList) != 1;
    }

    public static boolean isApplicable(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpression[] argList) {
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, argList, PsiUtil.getLanguageLevel(method)) != 1;
    }

    public static int getApplicabilityLevel(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpressionList argList) {
        PsiExpression[] args = argList.getExpressions();
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(argList);
        return PsiUtil.getApplicabilityLevel(method, substitutorForMethod, args, languageLevel);
    }

    private static int getApplicabilityLevel(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiExpression[] args, LanguageLevel languageLevel) {
        PsiParameter[] parms = method.getParameterList().getParameters();
        if (args.length < parms.length - 1) {
            return 1;
        }
        if (!PsiUtil.areFirstArgumentsApplicable(args, parms, languageLevel, substitutorForMethod)) {
            return 1;
        }
        if (args.length == parms.length) {
            if (parms.length == 0) {
                return 3;
            }
            PsiType parmType = PsiUtil.getParameterType(parms[parms.length - 1], languageLevel, substitutorForMethod);
            PsiType argType = args[args.length - 1].getType();
            if (argType == null) {
                return 1;
            }
            if (TypeConversionUtil.isAssignable(parmType, argType)) {
                return 3;
            }
        }
        if (method.isVarArgs() && languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0) {
            if (args.length < parms.length) {
                return 2;
            }
            PsiParameter lastParameter = parms[parms.length - 1];
            if (!lastParameter.isVarArgs()) {
                return 1;
            }
            PsiType lastParmType = PsiUtil.getParameterType(lastParameter, languageLevel, substitutorForMethod);
            if (!(lastParmType instanceof PsiArrayType)) {
                return 1;
            }
            lastParmType = ((PsiArrayType)lastParmType).getComponentType();
            for (int i = parms.length - 1; i < args.length; ++i) {
                PsiType argType = args[i].getType();
                if (argType != null && TypeConversionUtil.isAssignable(lastParmType, argType)) continue;
                return 1;
            }
            return 2;
        }
        return 1;
    }

    private static boolean areFirstArgumentsApplicable(PsiExpression[] args, PsiParameter[] parms, LanguageLevel languageLevel, PsiSubstitutor substitutorForMethod) {
        for (int i = 0; i < parms.length - 1; ++i) {
            PsiExpression arg = args[i];
            PsiType type = arg.getType();
            if (type == null) {
                return false;
            }
            PsiParameter parameter = parms[i];
            PsiType substitutedParmType = PsiUtil.getParameterType(parameter, languageLevel, substitutorForMethod);
            if (TypeConversionUtil.isAssignable(substitutedParmType, type)) continue;
            return false;
        }
        return true;
    }

    private static PsiType getParameterType(PsiParameter parameter, LanguageLevel languageLevel, PsiSubstitutor substitutor) {
        PsiType parmType = parameter.getType();
        if (parmType instanceof PsiClassType) {
            parmType = ((PsiClassType)parmType).setLanguageLevel(languageLevel);
        }
        return substitutor.substitute(parmType);
    }

    public static boolean equalOnClass(PsiSubstitutor s1, PsiSubstitutor s2, PsiClass aClass) {
        return PsiUtil.equalOnEquivalentClasses(s1, aClass, s2, aClass);
    }

    public static boolean equalOnEquivalentClasses(PsiSubstitutor s1, PsiClass aClass, PsiSubstitutor s2, PsiClass bClass) {
        PsiTypeParameter[] typeParameters2;
        if (aClass.hasTypeParameters() != bClass.hasTypeParameters()) {
            return true;
        }
        PsiTypeParameter[] typeParameters1 = aClass.getTypeParameters();
        if (typeParameters1.length != (typeParameters2 = bClass.getTypeParameters()).length) {
            return false;
        }
        for (int i = 0; i < typeParameters1.length; ++i) {
            if (Comparing.equal(s1.substitute(typeParameters1[i]), s2.substitute(typeParameters2[i]))) continue;
            return false;
        }
        if (aClass.hasModifierProperty("static")) {
            return true;
        }
        PsiClass containingClass1 = aClass.getContainingClass();
        PsiClass containingClass2 = bClass.getContainingClass();
        if (containingClass1 != null && containingClass2 != null) {
            return PsiUtil.equalOnEquivalentClasses(s1, containingClass1, s2, containingClass2);
        }
        return containingClass1 == null && containingClass2 == null;
    }

    public static boolean isCompileTimeConstant(PsiField field) {
        return field.hasModifierProperty("final") && (TypeConversionUtil.isPrimitiveAndNotNull(field.getType()) || field.getType().equalsToText("java.lang.String")) && field.hasInitializer() && PsiUtil.isConstantExpression(field.getInitializer());
    }

    public static boolean allMethodsHaveSameSignature(PsiMethod[] methods) {
        if (methods.length == 0) {
            return true;
        }
        MethodSignature methodSignature = methods[0].getSignature(PsiSubstitutor.EMPTY);
        for (int i = 1; i < methods.length; ++i) {
            PsiMethod method = methods[i];
            if (methodSignature.equals(method.getSignature(PsiSubstitutor.EMPTY))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiExpression deparenthesizeExpression(PsiExpression expression) {
        while (true) {
            if (expression instanceof PsiParenthesizedExpression) {
                expression = ((PsiParenthesizedExpression)expression).getExpression();
                continue;
            }
            if (!(expression instanceof PsiTypeCastExpression)) break;
            expression = ((PsiTypeCastExpression)expression).getOperand();
        }
        return expression;
    }

    public static boolean isInnerClass(PsiClass aClass) {
        return !aClass.hasModifierProperty("static") && aClass.getContainingClass() != null;
    }

    @Nullable
    public static PsiElement findModifierInList(@NotNull PsiModifierList modifierList, @NonNls String modifier) {
        PsiElement[] children;
        if (modifierList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.findModifierInList must not be null");
        }
        for (PsiElement child : children = modifierList.getChildren()) {
            if (!child.getText().equals(modifier)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static PsiClass getTopLevelClass(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.getTopLevelClass must not be null");
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiJavaFile) {
            PsiClass[] classes;
            for (PsiClass aClass : classes = ((PsiJavaFile)file).getClasses()) {
                if (!PsiTreeUtil.isAncestor(aClass, element, false)) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    public static PsiModifierListOwner getEnclosingStaticElement(PsiElement place, PsiClass aClass) {
        LOG.assertTrue(aClass == null || PsiTreeUtil.isAncestor(aClass, place, false));
        for (PsiElement parent = place; parent != aClass && !(parent instanceof PsiFile); parent = parent.getParent()) {
            if (!(parent instanceof PsiModifierListOwner) || !((PsiModifierListOwner)parent).hasModifierProperty("static")) continue;
            return (PsiModifierListOwner)parent;
        }
        return null;
    }

    @Nullable
    public static PsiType getTypeByPsiElement(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    public static int getRootIndex(PsiElement root) {
        ASTNode node;
        for (node = root.getNode(); node != null && node.getTreeParent() != null; node = node.getTreeParent()) {
        }
        if (node != null) {
            root = node.getPsi();
        }
        PsiFile containingFile = root.getContainingFile();
        PsiFile[] psiRoots = containingFile.getPsiRoots();
        for (int i = 0; i < psiRoots.length; ++i) {
            if (root != psiRoots[i]) continue;
            return i;
        }
        throw new RuntimeException("invalid element");
    }

    public static boolean isJspLanguage(Language baseLanguage) {
        return baseLanguage == StdLanguages.JSP || baseLanguage == StdLanguages.JSPX;
    }

    public static JspFile getJspFile(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiFile psiFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
        return psiFile instanceof JspFile ? (JspFile)psiFile : null;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        if (element instanceof PsiFileSystemItem) {
            return ((PsiFileSystemItem)element).getVirtualFile();
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        return containingFile.getVirtualFile();
    }

    public static PsiType captureToplevelWildcards(PsiType type, PsiElement context) {
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)type).resolveGenerics();
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                Iterator<PsiTypeParameter> iterator = PsiUtil.typeParametersIterator(aClass);
                PsiSubstitutor substitutor = result.getSubstitutor();
                HashMap<PsiTypeParameter, PsiCapturedWildcardType> substitutionMap = null;
                while (iterator.hasNext()) {
                    PsiTypeParameter typeParameter = iterator.next();
                    PsiType substituted = substitutor.substitute(typeParameter);
                    if (!(substituted instanceof PsiWildcardType)) continue;
                    if (substitutionMap == null) {
                        substitutionMap = new HashMap<PsiTypeParameter, PsiCapturedWildcardType>(substitutor.getSubstitutionMap());
                    }
                    substitutionMap.put(typeParameter, PsiCapturedWildcardType.create((PsiWildcardType)substituted, context));
                }
                if (substitutionMap != null) {
                    PsiElementFactory factory = aClass.getManager().getElementFactory();
                    PsiSubstitutor newSubstitutor = factory.createSubstitutor(substitutionMap);
                    return factory.createType(aClass, newSubstitutor);
                }
            }
        } else if (type instanceof PsiArrayType) {
            return PsiUtil.captureToplevelWildcards(((PsiArrayType)type).getComponentType(), context).createArrayType();
        }
        return type;
    }

    public static boolean isInsideJavadocComment(PsiElement element) {
        return PsiTreeUtil.getParentOfType(element, PsiDocComment.class, true, true) != null;
    }

    public static Iterator<PsiTypeParameter> typeParametersIterator(@NotNull PsiTypeParameterListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.typeParametersIterator must not be null");
        }
        return new TypeParameterIterator(owner);
    }

    public static boolean canBeOverriden(PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        if (parentClass == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (method.hasModifierProperty("final")) {
            return false;
        }
        if (method.hasModifierProperty("private")) {
            return false;
        }
        if (parentClass instanceof PsiAnonymousClass) {
            return false;
        }
        return !parentClass.hasModifierProperty("final");
    }

    public static PsiElement[] mapElements(ResolveResult[] candidates) {
        PsiElement[] result = new PsiElement[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            result[i] = candidates[i].getElement();
        }
        return result;
    }

    public static boolean hasErrorElementChild(PsiElement element) {
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiMember findEnclosingConstructorOrInitializer(PsiElement expression) {
        PsiMember parent = (PsiMember)PsiTreeUtil.getParentOfType(expression, PsiClassInitializer.class, PsiMethod.class);
        if (parent instanceof PsiMethod && !((PsiMethod)parent).isConstructor()) {
            return null;
        }
        return parent;
    }

    public static boolean checkName(PsiElement element, String name, PsiElement context) {
        PsiMetaDataBase data;
        if (element instanceof PsiMetaBaseOwner && (data = ((PsiMetaBaseOwner)((Object)element)).getMetaData()) != null) {
            return name.equals(data.getName(context));
        }
        return element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName());
    }

    public static boolean isRawSubstitutor(@NotNull PsiTypeParameterListOwner owner, PsiSubstitutor substitutor) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.isRawSubstitutor must not be null");
        }
        Iterator<PsiTypeParameter> iterator = PsiUtil.typeParametersIterator(owner);
        while (iterator.hasNext()) {
            PsiTypeParameter parameter = iterator.next();
            if (substitutor.substitute(parameter) != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnderPsiRoot(PsiFile root, PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == root) {
            return true;
        }
        for (PsiFile psiRoot : root.getPsiRoots()) {
            if (containingFile != psiRoot) continue;
            return true;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(root.getProject()).getInjectionHost(element);
        if (host != null) {
            return PsiUtil.isUnderPsiRoot(root, host);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Language getLanguageAtOffset(@NotNull PsiFile file, int offset) {
        int decremented;
        Language language;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.getLanguageAtOffset must not be null");
        }
        PsiElement elt = file.findElementAt(offset);
        if (elt == null) {
            language = file.getLanguage();
            if (language == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageAtOffset must not return null");
            return language;
        }
        if (elt instanceof PsiWhiteSpace && (decremented = elt.getTextRange().getStartOffset() - 1) >= 0) {
            language = PsiUtil.getLanguageAtOffset(file, decremented);
            if (language == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageAtOffset must not return null");
            return language;
        }
        language = PsiUtil.findLanguageFromElement(elt, file);
        if (language != null) return language;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageAtOffset must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Language findLanguageFromElement(PsiElement elt, PsiFile file) {
        Language language;
        Language language2 = elt.getLanguage();
        if (PsiUtil.isInJspFile(file) && language2 == StdLanguages.XML) {
            ASTNode root = PsiUtil.getRoot(elt.getNode());
            language = root.getPsi().getLanguage();
            if (language == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.findLanguageFromElement must not return null");
            return language;
        }
        language = language2;
        if (language != null) return language;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.findLanguageFromElement must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ASTNode getRoot(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.getRoot must not be null");
        }
        ASTNode child = node;
        while (true) {
            ASTNode parent;
            if ((parent = child.getTreeParent()) == null) {
                ASTNode aSTNode = child;
                if (aSTNode == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getRoot must not return null");
                }
                return aSTNode;
            }
            child = parent;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        LanguageLevel languageLevel;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.getLanguageLevel must not be null");
        }
        if (element instanceof PsiDirectory) {
            languageLevel = ((PsiDirectory)element).getLanguageLevel();
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageLevel must not return null");
            return languageLevel;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            languageLevel = element.getManager().getEffectiveLanguageLevel();
            if (languageLevel == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageLevel must not return null");
            return languageLevel;
        }
        if (!(file instanceof PsiJavaFile)) {
            PsiElement context = file.getContext();
            if (!(context != null ? (languageLevel = PsiUtil.getLanguageLevel(context)) != null : (languageLevel = element.getManager().getEffectiveLanguageLevel()) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageLevel must not return null");
            return languageLevel;
        }
        languageLevel = ((PsiJavaFile)file).getLanguageLevel();
        if (languageLevel != null) return languageLevel;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtil.getLanguageLevel must not return null");
    }

    public static boolean isInstantiatable(PsiClass clazz) {
        return !clazz.hasModifierProperty("abstract") && clazz.hasModifierProperty("public") && PsiUtil.hasDefaultConstructor(clazz);
    }

    public static boolean hasDefaultConstructor(PsiClass clazz) {
        PsiMethod[] constructors = clazz.getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod cls : constructors) {
                if (!cls.hasModifierProperty("public") || cls.getParameterList().getParametersCount() != 0) continue;
                return true;
            }
        } else {
            PsiClass superClass = clazz.getSuperClass();
            return superClass == null || PsiUtil.hasDefaultConstructor(superClass);
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psiElement, Class<? extends T> elementClass) {
        T parent;
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtil.getOriginalElement must not be null");
        }
        PsiFile psiFile = psiElement.getContainingFile();
        PsiFile originalFile = psiFile.getOriginalFile();
        if (originalFile == null) {
            return psiElement;
        }
        TextRange range = psiElement.getTextRange();
        PsiElement element = originalFile.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        T next = parent = PsiTreeUtil.getParentOfType(element, elementClass, false);
        while (next != null && next.getTextLength() <= maxLength) {
            parent = next;
            next = PsiTreeUtil.getParentOfType(next, elementClass, true);
        }
        return parent;
    }

    public static int compareElementsByPosition(PsiElement element1, PsiElement element2) {
        if (element1 != null && element2 != null) {
            PsiFile psiFile2;
            PsiFile psiFile1 = element1.getContainingFile();
            if (Comparing.equal(psiFile1, psiFile2 = element2.getContainingFile())) {
                TextRange textRange1 = element1.getTextRange();
                TextRange textRange2 = element2.getTextRange();
                if (textRange1 != null && textRange2 != null) {
                    return textRange1.getStartOffset() - textRange2.getStartOffset();
                }
            } else if (psiFile1 != null && psiFile2 != null) {
                String name1 = psiFile1.getName();
                LOG.assertTrue(name1 != null);
                String name2 = psiFile2.getName();
                LOG.assertTrue(name2 != null);
                return name1.compareToIgnoreCase(name2);
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeParameterIterator
    implements Iterator<PsiTypeParameter> {
        private int myIndex;
        private PsiTypeParameterListOwner myCurrentOwner;
        private boolean myNextObtained;
        private PsiTypeParameter[] myCurrentParams;
        private PsiTypeParameter myNext;

        private TypeParameterIterator(PsiTypeParameterListOwner owner) {
            this.myCurrentOwner = owner;
            this.obtainCurrentParams(owner);
            this.myNextObtained = false;
        }

        private void obtainCurrentParams(PsiTypeParameterListOwner owner) {
            this.myCurrentParams = owner.getTypeParameters();
            this.myIndex = this.myCurrentParams.length - 1;
        }

        @Override
        public boolean hasNext() {
            this.nextElement();
            return this.myNext != null;
        }

        @Override
        public PsiTypeParameter next() {
            this.nextElement();
            if (this.myNext == null) {
                throw new NoSuchElementException();
            }
            this.myNextObtained = false;
            return this.myNext;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("TypeParameterIterator.remove");
        }

        private void nextElement() {
            if (this.myNextObtained) {
                return;
            }
            if (this.myIndex >= 0) {
                this.myNext = this.myCurrentParams[this.myIndex--];
                this.myNextObtained = true;
                return;
            }
            if (this.myCurrentOwner.hasModifierProperty("static") || this.myCurrentOwner.getContainingClass() == null) {
                this.myNext = null;
                this.myNextObtained = true;
                return;
            }
            this.myCurrentOwner = this.myCurrentOwner.getContainingClass();
            this.obtainCurrentParams(this.myCurrentOwner);
            this.nextElement();
        }
    }
}

