/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionCache;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsiTreeUtil {
    private static final Key<Integer> INDEX = Key.create("PsiTreeUtil.copyElements.INDEX");
    private static final Key<Object> MARKER = Key.create("PsiTreeUtil.copyElements.INDEX");

    public static boolean isAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.isAncestor must not be null");
        }
        if (ancestor == null) {
            return false;
        }
        boolean stopAtFileLevel = !(element instanceof PsiFile) && !(element instanceof PsiDirectory);
        PsiElement psiElement = parent = strict ? element.getParent() : element;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent instanceof PsiFile) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isContextAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        PsiElement parent;
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.isContextAncestor must not be null");
        }
        if (ancestor == null) {
            return false;
        }
        boolean stopAtFileLevel = !(element instanceof PsiFile) && !(element instanceof PsiDirectory);
        PsiElement psiElement = parent = strict ? element.getContext() : element;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            if (stopAtFileLevel && parent instanceof PsiFile) {
                return false;
            }
            parent = parent.getContext();
        }
        return false;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findCommonParent must not be null");
        }
        if (elements.length == 0) {
            return null;
        }
        PsiElement toReturn = null;
        for (PsiElement element : elements) {
            if (element == null) continue;
            PsiElement psiElement = toReturn = toReturn == null ? element : PsiTreeUtil.findCommonParent(toReturn, element);
            if (toReturn != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent2;
        PsiElement parent1;
        if (element1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findCommonParent must not be null");
        }
        if (element2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findCommonParent must not be null");
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        ArrayList<PsiElement> parents1 = PsiTreeUtil.getParents(element1, topLevel);
        ArrayList<PsiElement> parents2 = PsiTreeUtil.getParents(element2, topLevel);
        int size = Math.min(parents1.size(), parents2.size());
        PsiElement parent = topLevel;
        for (int i = 1; i <= size && (parent1 = parents1.get(parents1.size() - i)).equals(parent2 = parents2.get(parents2.size() - i)); ++i) {
            parent = parent1;
        }
        return parent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static ArrayList<PsiElement> getParents(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getParents must not be null");
        }
        ArrayList<PsiElement> parents = new ArrayList<PsiElement>();
        for (PsiElement parent = element; parent != topLevel && parent != null; parent = parent.getParent()) {
            parents.add(parent);
        }
        ArrayList<PsiElement> arrayList = parents;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiTreeUtil.getParents must not return null");
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement findCommonContext(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findCommonContext must not be null");
        }
        if (elements.length == 0) {
            return null;
        }
        PsiElement toReturn = elements[0];
        for (int i = 1; i < elements.length; ++i) {
            if ((toReturn = PsiTreeUtil.findCommonContext(toReturn, elements[i])) != null) continue;
            return null;
        }
        return toReturn;
    }

    @Nullable
    public static PsiElement findCommonContext(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiElement parent2;
        PsiElement parent1;
        if (element1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findCommonContext must not be null");
        }
        if (element2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findCommonContext must not be null");
        }
        if (element1 == element2) {
            return element1;
        }
        PsiFile containingFile = element1.getContainingFile();
        PsiFile topLevel = containingFile == element2.getContainingFile() ? containingFile : null;
        ArrayList<PsiElement> parents1 = PsiTreeUtil.getContexts(element1, topLevel);
        ArrayList<PsiElement> parents2 = PsiTreeUtil.getContexts(element2, topLevel);
        int size = Math.min(parents1.size(), parents2.size());
        PsiElement parent = topLevel;
        for (int i = 1; i <= size && (parent1 = parents1.get(parents1.size() - i)).equals(parent2 = parents2.get(parents2.size() - i)); ++i) {
            parent = parent1;
        }
        return parent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static ArrayList<PsiElement> getContexts(@NotNull PsiElement element, @Nullable PsiElement topLevel) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getContexts must not be null");
        }
        ArrayList<PsiElement> parents = new ArrayList<PsiElement>();
        for (PsiElement parent = element; parent != topLevel && parent != null; parent = parent.getContext()) {
            parents.add(parent);
        }
        ArrayList<PsiElement> arrayList = parents;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiTreeUtil.getContexts must not return null");
        }
        return arrayList;
    }

    @Nullable
    public static <T extends PsiElement> T getChildOfType(@NotNull PsiElement element, @NotNull Class<T> aClass) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getChildOfType must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getChildOfType must not be null");
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PsiTreeUtil.instanceOf(aClass, child)) continue;
            return (T)child;
        }
        return null;
    }

    private static boolean instanceOf(Class aClass, PsiElement child) {
        if (aClass == PsiClass.class) {
            return child instanceof PsiClass;
        }
        if (aClass == PsiMethod.class) {
            return child instanceof PsiMethod;
        }
        if (aClass == PsiField.class) {
            return child instanceof PsiField;
        }
        if (aClass == PsiMember.class) {
            return child instanceof PsiMember;
        }
        if (aClass == PsiDocCommentOwner.class) {
            return child instanceof PsiDocCommentOwner;
        }
        if (aClass == PsiStatement.class) {
            return child instanceof PsiStatement;
        }
        if (aClass == PsiCodeBlock.class) {
            return child instanceof PsiCodeBlock;
        }
        if (aClass == PsiClassInitializer.class) {
            return child instanceof PsiClassInitializer;
        }
        if (aClass == XmlTag.class) {
            return child instanceof XmlTag;
        }
        if (aClass == XmlDocument.class) {
            return child instanceof XmlDocument;
        }
        return aClass.isInstance(child);
    }

    @Nullable
    public static <T extends PsiElement> T getChildOfAnyType(@NotNull PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getChildOfAnyType must not be null");
        }
        if (classes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getChildOfAnyType must not be null");
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            for (Class<? extends T> aClass : classes) {
                if (!PsiTreeUtil.instanceOf(aClass, child)) continue;
                return (T)child;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getNextSiblingOfType(@NotNull PsiElement sibling, @NotNull Class<T> aClass) {
        if (sibling == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getNextSiblingOfType must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getNextSiblingOfType must not be null");
        }
        for (PsiElement child = sibling.getNextSibling(); child != null; child = child.getNextSibling()) {
            if (!PsiTreeUtil.instanceOf(aClass, child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getPrevSiblingOfType(@NotNull PsiElement sibling, @NotNull Class<T> aClass) {
        if (sibling == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getPrevSiblingOfType must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getPrevSiblingOfType must not be null");
        }
        for (PsiElement child = sibling.getPrevSibling(); child != null; child = child.getPrevSibling()) {
            if (!PsiTreeUtil.instanceOf(aClass, child)) continue;
            return (T)child;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getParentOfType must not be null");
        }
        return PsiTreeUtil.getParentOfType(element, aClass, true);
    }

    @Nullable
    public static <T extends PsiElement> T getContextOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getContextOfType must not be null");
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getContext();
        }
        while (element != null && !PsiTreeUtil.instanceOf(aClass, element)) {
            element = element.getContext();
        }
        return (T)element;
    }

    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getParentOfType must not be null");
        }
        return PsiTreeUtil.getParentOfType(element, aClass, strict, !ReflectionCache.isAssignable(PsiDirectory.class, aClass));
    }

    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict, boolean stopAtFileLevel) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getParentOfType must not be null");
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null && !PsiTreeUtil.instanceOf(aClass, element)) {
            if (stopAtFileLevel && element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return (T)element;
    }

    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getParentOfType must not be null");
        }
        if (stopAt == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getParentOfType must not be null");
        }
        if (element == null) {
            return null;
        }
        if (strict) {
            element = element.getParent();
        }
        while (element != null && !PsiTreeUtil.instanceOf(aClass, element)) {
            for (Class<? extends PsiElement> stopClass : stopAt) {
                if (!PsiTreeUtil.instanceOf(stopClass, element)) continue;
                return null;
            }
            element = element.getParent();
        }
        return (T)element;
    }

    @Nullable
    public static PsiElement skipSiblingsForward(@Nullable PsiElement element, Class ... elementClasses) {
        if (elementClasses == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.skipSiblingsForward must not be null");
        }
        if (element == null) {
            return null;
        }
        block0: for (PsiElement e = element.getNextSibling(); e != null; e = e.getNextSibling()) {
            for (Class aClass : elementClasses) {
                if (PsiTreeUtil.instanceOf(aClass, e)) continue block0;
            }
            return e;
        }
        return null;
    }

    @Nullable
    public static PsiElement skipSiblingsBackward(@Nullable PsiElement element, Class ... elementClasses) {
        if (elementClasses == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.skipSiblingsBackward must not be null");
        }
        if (element == null) {
            return null;
        }
        block0: for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            for (Class aClass : elementClasses) {
                if (PsiTreeUtil.instanceOf(aClass, e)) continue block0;
            }
            return e;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getParentOfType(PsiElement element, Class<? extends T> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getParentOfType must not be null");
        }
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        return PsiTreeUtil.getNonStrictParentOfType(parent, classes);
    }

    @Nullable
    public static <T extends PsiElement> T getNonStrictParentOfType(@NotNull PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getNonStrictParentOfType must not be null");
        }
        if (classes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getNonStrictParentOfType must not be null");
        }
        boolean canRunOutOfTheFile = false;
        for (Class<? extends T> aClass : classes) {
            canRunOutOfTheFile |= ReflectionCache.isAssignable(PsiDirectory.class, aClass);
        }
        for (PsiElement run = element; run != null; run = run.getParent()) {
            for (Class<? extends T> aClass : classes) {
                if (!PsiTreeUtil.instanceOf(aClass, run)) continue;
                return (T)run;
            }
            if (!canRunOutOfTheFile && run instanceof PsiFile) break;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement[] collectElements(@Nullable PsiElement element, @NotNull PsiElementFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.collectElements must not be null");
        }
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(filter);
        PsiTreeUtil.processElements(element, processor);
        PsiElement[] psiElementArray = processor.toArray();
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiTreeUtil.collectElements must not return null");
        }
        return psiElementArray;
    }

    public static boolean processElements(@Nullable PsiElement element, @NotNull PsiElementProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.processElements must not be null");
        }
        if (element == null) {
            return true;
        }
        if (!processor.execute(element)) {
            return false;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PsiTreeUtil.processElements(child, processor)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement[] copyElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.copyElements must not be null");
        }
        ArrayList<PsiElement> roots = new ArrayList<PsiElement>();
        int i = 0;
        while (true) {
            boolean failed;
            PsiElement rootCandidate;
            if (i < elements.length) {
                rootCandidate = elements[i];
                failed = false;
            } else {
                for (i = 0; i < elements.length; ++i) {
                    PsiElement element = elements[i];
                    element.putCopyableUserData(INDEX, i);
                }
                PsiElement[] newRoots = new PsiElement[roots.size()];
                for (int i2 = 0; i2 < roots.size(); ++i2) {
                    PsiElement root = (PsiElement)roots.get(i2);
                    newRoots[i2] = root.copy();
                }
                PsiElement[] result = new PsiElement[elements.length];
                for (PsiElement newRoot : newRoots) {
                    PsiTreeUtil.decodeIndices(newRoot, result);
                }
                if (result == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiTreeUtil.copyElements must not return null");
                }
                return result;
            }
            for (int j = 0; j < elements.length; ++j) {
                PsiElement element = elements[j];
                if (i == j || !PsiTreeUtil.isAncestor(element, rootCandidate, true)) continue;
                failed = true;
                break;
            }
            if (!failed) {
                roots.add(rootCandidate);
            }
            ++i;
        }
    }

    private static void decodeIndices(@NotNull PsiElement element, @NotNull PsiElement[] result) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.decodeIndices must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.decodeIndices must not be null");
        }
        Integer data = element.getCopyableUserData(INDEX);
        if (data != null) {
            element.putCopyableUserData(INDEX, null);
            int index = data;
            result[index] = element;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiTreeUtil.decodeIndices(child, result);
        }
    }

    public static void mark(@NotNull PsiElement element, @NotNull Object marker) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.mark must not be null");
        }
        if (marker == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.mark must not be null");
        }
        element.putCopyableUserData(MARKER, marker);
    }

    @Nullable
    public static PsiElement releaseMark(@NotNull PsiElement root, @NotNull Object marker) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.releaseMark must not be null");
        }
        if (marker == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.releaseMark must not be null");
        }
        if (marker.equals(root.getCopyableUserData(MARKER))) {
            root.putCopyableUserData(MARKER, null);
            return root;
        }
        for (PsiElement child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement result = PsiTreeUtil.releaseMark(child, marker);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtOffset(@NotNull PsiFile file, int offset, @NotNull Class<T> clazz, boolean strictStart) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findElementOfClassAtOffset must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findElementOfClassAtOffset must not be null");
        }
        PsiFile[] psiRoots = file.getPsiRoots();
        PsiElement result = null;
        for (PsiFile root : psiRoots) {
            T parent;
            PsiElement elementAt = root.findElementAt(offset);
            if (elementAt == null || (parent = PsiTreeUtil.getParentOfType(elementAt, clazz)) == null) continue;
            TextRange range = parent.getTextRange();
            if (strictStart && range.getStartOffset() != offset || result != null && result.getTextRange().getEndOffset() <= range.getEndOffset()) continue;
            result = parent;
        }
        return (T)result;
    }

    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull Class<T> clazz) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findElementOfClassAtRange must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.findElementOfClassAtRange must not be null");
        }
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement result = null;
        for (Language lang : viewProvider.getPrimaryLanguages()) {
            T run;
            PsiElement elementAt = viewProvider.findElementAt(startOffset, lang);
            T prev = run = PsiTreeUtil.getParentOfType(elementAt, clazz, false);
            while (run != null && run.getTextRange().getStartOffset() == startOffset && run.getTextRange().getEndOffset() <= endOffset) {
                prev = run;
                run = PsiTreeUtil.getParentOfType(run, clazz);
            }
            if (prev == null) continue;
            int elementStartOffset = prev.getTextRange().getStartOffset();
            int elementEndOffset = prev.getTextRange().getEndOffset();
            if (elementStartOffset != startOffset || elementEndOffset > endOffset || result != null && result.getTextRange().getEndOffset() >= elementEndOffset) continue;
            result = prev;
        }
        return (T)result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement getDeepestFirst(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getDeepestFirst must not be null");
        }
        PsiElement res = elt;
        while (true) {
            PsiElement firstChild;
            if ((firstChild = res.getFirstChild()) == null) {
                PsiElement psiElement = res;
                if (psiElement == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiTreeUtil.getDeepestFirst must not return null");
                }
                return psiElement;
            }
            res = firstChild;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement getDeepestLast(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.getDeepestLast must not be null");
        }
        PsiElement res = elt;
        while (true) {
            PsiElement lastChild;
            if ((lastChild = res.getLastChild()) == null) {
                PsiElement psiElement = res;
                if (psiElement == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiTreeUtil.getDeepestLast must not return null");
                }
                return psiElement;
            }
            res = lastChild;
        }
    }

    public static PsiElement prevLeaf(PsiElement current) {
        PsiElement prevSibling = current.getPrevSibling();
        if (prevSibling != null) {
            return PsiTreeUtil.lastChild(prevSibling);
        }
        PsiElement parent = current.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.prevLeaf(parent);
    }

    public static PsiElement nextLeaf(PsiElement current) {
        PsiElement nextSibling = current.getNextSibling();
        if (nextSibling != null) {
            return PsiTreeUtil.firstChild(nextSibling);
        }
        PsiElement parent = current.getParent();
        if (parent == null || parent instanceof PsiFile) {
            return null;
        }
        return PsiTreeUtil.nextLeaf(parent);
    }

    public static PsiElement lastChild(PsiElement element) {
        if (element.getLastChild() != null) {
            return PsiTreeUtil.lastChild(element.getLastChild());
        }
        return element;
    }

    public static PsiElement firstChild(PsiElement element) {
        if (element.getFirstChild() != null) {
            return PsiTreeUtil.firstChild(element.getFirstChild());
        }
        return element;
    }

    public static PsiElement prevLeaf(PsiErrorElement element, boolean skipEmptyElements) {
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf(element);
        while (skipEmptyElements && prevLeaf != null && prevLeaf.getTextLength() == 0) {
            prevLeaf = PsiTreeUtil.prevLeaf(prevLeaf);
        }
        return prevLeaf;
    }

    public static PsiElement nextLeaf(PsiErrorElement element, boolean skipEmptyElements) {
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf(element);
        while (skipEmptyElements && nextLeaf != null && nextLeaf.getTextLength() == 0) {
            nextLeaf = PsiTreeUtil.nextLeaf(nextLeaf);
        }
        return nextLeaf;
    }

    public static boolean hasErrorElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiTreeUtil.hasErrorElements must not be null");
        }
        if (element instanceof PsiErrorElement) {
            return true;
        }
        for (PsiElement child : element.getChildren()) {
            if (!PsiTreeUtil.hasErrorElements(child)) continue;
            return true;
        }
        return false;
    }
}

