/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.containers.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsiSuperMethodUtil {
    private PsiSuperMethodUtil() {
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor) {
        return PsiSuperMethodUtil.findConstructorInSuper(constructor, new HashSet<PsiMethod>());
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor, Set<PsiMethod> visited) {
        PsiClass superClass;
        PsiClass containingClass;
        PsiElement firstChild;
        PsiStatement[] statements;
        if (visited.contains(constructor)) {
            return null;
        }
        visited.add(constructor);
        PsiCodeBlock body = constructor.getBody();
        if (body != null && (statements = body.getStatements()).length > 0 && (firstChild = statements[0].getFirstChild()) instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)firstChild).getMethodExpression();
            String text = methodExpr.getText();
            if (text.equals("super")) {
                PsiElement superConstructor = methodExpr.resolve();
                if (superConstructor instanceof PsiMethod) {
                    return (PsiMethod)superConstructor;
                }
            } else if (text.equals("this")) {
                PsiElement resolved = methodExpr.resolve();
                if (resolved instanceof PsiMethod) {
                    return PsiSuperMethodUtil.findConstructorInSuper((PsiMethod)resolved, visited);
                }
                return null;
            }
        }
        if ((containingClass = constructor.getContainingClass()) != null && (superClass = containingClass.getSuperClass()) != null) {
            MethodSignature defConstructor = MethodSignatureUtil.createMethodSignature(superClass.getName(), PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            return MethodSignatureUtil.findMethodBySignature(superClass, defConstructor, false);
        }
        return null;
    }
}

