/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMatcher;
import com.intellij.psi.util.PsiMatcherExpression;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;

public class PsiMatcherImpl
implements PsiMatcher {
    private PsiElement myElement;

    public PsiMatcherImpl(PsiElement element) {
        this.myElement = element;
    }

    public PsiMatcher parent(PsiMatcherExpression e) {
        this.myElement = this.myElement.getParent();
        if (this.myElement == null || e != null && e.match(this.myElement) != Boolean.TRUE) {
            return NullPsiMatcherImpl.INSTANCE;
        }
        return this;
    }

    public PsiMatcher firstChild(PsiMatcherExpression e) {
        PsiElement[] children;
        PsiElement[] arr$ = children = this.myElement.getChildren();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            PsiElement child;
            this.myElement = child = arr$[i$];
            if (e != null && e.match(this.myElement) != Boolean.TRUE) continue;
            return this;
        }
        return NullPsiMatcherImpl.INSTANCE;
    }

    public PsiMatcher ancestor(PsiMatcherExpression e) {
        while (this.myElement != null) {
            Boolean res;
            Boolean bl = res = e == null ? Boolean.TRUE : e.match(this.myElement);
            if (res == Boolean.TRUE) break;
            if (res == null) {
                return NullPsiMatcherImpl.INSTANCE;
            }
            this.myElement = this.myElement.getParent();
        }
        if (this.myElement == null) {
            return NullPsiMatcherImpl.INSTANCE;
        }
        return this;
    }

    public PsiMatcher descendant(PsiMatcherExpression e) {
        PsiElement[] children;
        PsiElement[] arr$ = children = this.myElement.getChildren();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            PsiMatcher grandChild;
            Boolean res;
            PsiElement child;
            this.myElement = child = arr$[i$];
            Boolean bl = res = e == null ? Boolean.TRUE : e.match(this.myElement);
            if (res == Boolean.TRUE) {
                return this;
            }
            if (res != Boolean.FALSE || (grandChild = this.descendant(e)) == NullPsiMatcherImpl.INSTANCE) continue;
            return grandChild;
        }
        return NullPsiMatcherImpl.INSTANCE;
    }

    public PsiMatcher dot(PsiMatcherExpression e) {
        return e == null || e.match(this.myElement) == Boolean.TRUE ? this : NullPsiMatcherImpl.INSTANCE;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public static PsiMatcherExpression hasModifier(final String modifier, final boolean shouldHave) {
        return new PsiMatcherExpression(){

            public Boolean match(PsiElement element) {
                PsiModifierListOwner owner;
                PsiModifierListOwner psiModifierListOwner = owner = element instanceof PsiModifierListOwner ? (PsiModifierListOwner)element : null;
                if (owner != null && owner.hasModifierProperty(modifier) == shouldHave) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    public static PsiMatcherExpression hasText(final String text) {
        return new PsiMatcherExpression(){

            public Boolean match(PsiElement element) {
                if (element.getTextLength() != text.length()) {
                    return Boolean.FALSE;
                }
                return text.equals(element.getText());
            }
        };
    }

    public static PsiMatcherExpression hasText(final String ... texts) {
        if (texts == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiMatcherImpl.hasText must not be null");
        }
        return new PsiMatcherExpression(){

            public Boolean match(PsiElement element) {
                String text = element.getText();
                return ArrayUtil.find(texts, text) != -1;
            }
        };
    }

    public static PsiMatcherExpression hasClass(final Class aClass) {
        return new PsiMatcherExpression(){

            public Boolean match(PsiElement element) {
                if (aClass.isAssignableFrom(element.getClass())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    public static PsiMatcherExpression hasClass(final Class[] classes) {
        return new PsiMatcherExpression(){

            public Boolean match(PsiElement element) {
                for (Class aClass : classes) {
                    if (!aClass.isAssignableFrom(element.getClass())) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    public static PsiMatcherExpression hasName(final String name) {
        return new PsiMatcherExpression(){

            public Boolean match(PsiElement element) {
                if (element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName())) {
                    return Boolean.TRUE;
                }
                if (element instanceof XmlTag && name.equals(((XmlTag)element).getName())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    public static PsiMatcherExpression hasTagValue(final String value) {
        return new PsiMatcherExpression(){

            public Boolean match(PsiElement element) {
                if (element instanceof XmlTag && value.equals(((XmlTag)element).getValue().getTrimmedText())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
    }

    public static PsiMatcherExpression isConstructor(final boolean shouldBe) {
        return new PsiMatcherExpression(){

            public Boolean match(PsiElement element) {
                return element instanceof PsiMethod && ((PsiMethod)element).isConstructor() == shouldBe;
            }
        };
    }

    private static class NullPsiMatcherImpl
    implements PsiMatcher {
        private static final NullPsiMatcherImpl INSTANCE = new NullPsiMatcherImpl();

        private NullPsiMatcherImpl() {
        }

        public PsiMatcher parent(PsiMatcherExpression e) {
            return this;
        }

        public PsiMatcher firstChild(PsiMatcherExpression e) {
            return this;
        }

        public PsiMatcher ancestor(PsiMatcherExpression e) {
            return this;
        }

        public PsiMatcher descendant(PsiMatcherExpression e) {
            return this;
        }

        public PsiMatcher dot(PsiMatcherExpression e) {
            return this;
        }

        public PsiElement getElement() {
            return null;
        }
    }
}

