/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFormatUtil {
    public static final int SHOW_NAME = 1;
    public static final int SHOW_TYPE = 2;
    public static final int TYPE_AFTER = 4;
    public static final int SHOW_MODIFIERS = 8;
    public static final int MODIFIERS_AFTER = 16;
    public static final int SHOW_REDUNDANT_MODIFIERS = 32;
    public static final int SHOW_PACKAGE_LOCAL = 64;
    public static final int SHOW_INITIALIZER = 128;
    public static final int SHOW_PARAMETERS = 256;
    public static final int SHOW_THROWS = 512;
    public static final int SHOW_EXTENDS_IMPLEMENTS = 1024;
    public static final int SHOW_FQ_NAME = 2048;
    public static final int SHOW_CONTAINING_CLASS = 4096;
    public static final int SHOW_FQ_CLASS_NAMES = 8192;
    public static final int JAVADOC_MODIFIERS_ONLY = 16384;
    public static final int SHOW_ANONYMOUS_CLASS_VERBOSE = 32768;
    public static final int SHOW_RAW_TYPE = 65536;
    public static final int MAX_PARAMS_TO_SHOW = 7;

    public static String formatVariable(PsiVariable variable, int options, PsiSubstitutor substitutor) {
        PsiExpression initializer;
        String modifiers;
        String name;
        StringBuilder buffer = new StringBuilder();
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            buffer.append(PsiFormatUtil.formatModifiers(variable, options));
        }
        if ((options & 2) != 0 && (options & 4) == 0) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor));
        }
        if (variable instanceof PsiField && (options & 0x1000) != 0) {
            PsiClass aClass = ((PsiField)variable).getContainingClass();
            if (aClass != null) {
                String className;
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
                if ((className = aClass.getName()) != null) {
                    if ((options & 0x800) != 0) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(className);
                        }
                    } else {
                        buffer.append(className);
                    }
                    buffer.append('.');
                }
            }
            if ((options & 1) != 0) {
                buffer.append(variable.getName());
            }
        } else if ((options & 1) != 0 && (name = variable.getName()) != null) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(name);
        }
        if ((options & 2) != 0 && (options & 4) != 0) {
            if ((options & 1) != 0 && variable.getName() != null) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(variable.getType(), options, substitutor));
        }
        if ((options & 8) != 0 && (options & 0x10) != 0 && (modifiers = PsiFormatUtil.formatModifiers(variable, options)).length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(modifiers);
        }
        if ((options & 0x80) != 0 && (initializer = variable.getInitializer()) != null) {
            int index2;
            buffer.append(" = ");
            String text = initializer.getText();
            int index1 = text.lastIndexOf(10);
            if (index1 < 0) {
                index1 = text.length();
            }
            if ((index2 = text.lastIndexOf(13)) < 0) {
                index2 = text.length();
            }
            int index = Math.min(index1, index2);
            buffer.append(text.substring(0, index));
            if (index < text.length()) {
                buffer.append(" ...");
            }
        }
        return buffer.toString();
    }

    public static String formatMethod(PsiMethod method, PsiSubstitutor substitutor, int options, int parameterOptions) {
        return PsiFormatUtil.formatMethod(method, substitutor, options, parameterOptions, 7);
    }

    public static String formatMethod(PsiMethod method, PsiSubstitutor substitutor, int options, int parameterOptions, int paramsToShow) {
        String throwsText;
        String modifiers;
        PsiType type;
        StringBuilder buffer = new StringBuilder();
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            buffer.append(PsiFormatUtil.formatModifiers(method, options));
        }
        if ((options & 2) != 0 && (options & 4) == 0 && (type = method.getReturnType()) != null) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(PsiFormatUtil.formatType(type, options, substitutor));
        }
        if ((options & 0x1000) != 0) {
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                String name;
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
                if ((name = aClass.getName()) != null) {
                    if ((options & 0x800) != 0) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(name);
                        }
                    } else {
                        buffer.append(name);
                    }
                    buffer.append('.');
                }
            }
            if ((options & 1) != 0) {
                buffer.append(method.getName());
            }
        } else if ((options & 1) != 0) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(method.getName());
        }
        if ((options & 0x100) != 0) {
            buffer.append('(');
            PsiParameter[] parms = method.getParameterList().getParameters();
            for (int i = 0; i < Math.min(parms.length, paramsToShow); ++i) {
                PsiParameter parm = parms[i];
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(PsiFormatUtil.formatVariable(parm, parameterOptions, substitutor));
            }
            if (parms.length > paramsToShow) {
                buffer.append(", ...");
            }
            buffer.append(')');
        }
        if ((options & 2) != 0 && (options & 4) != 0 && (type = method.getReturnType()) != null) {
            if (buffer.length() > 0) {
                buffer.append(':');
            }
            buffer.append(PsiFormatUtil.formatType(type, options, substitutor));
        }
        if ((options & 8) != 0 && (options & 0x10) != 0 && (modifiers = PsiFormatUtil.formatModifiers(method, options)).length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(modifiers);
        }
        if ((options & 0x200) != 0 && (throwsText = PsiFormatUtil.formatReferenceList(method.getThrowsList(), options)).length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append("throws ");
            buffer.append(throwsText);
        }
        return buffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String formatClass(@NotNull PsiClass aClass, int options) {
        String modifiers;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiFormatUtil.formatClass must not be null");
        }
        StringBuilder buffer = new StringBuilder();
        if ((options & 8) != 0 && (options & 0x10) == 0) {
            buffer.append(PsiFormatUtil.formatModifiers(aClass, options));
        }
        if ((options & 1) != 0) {
            if (aClass instanceof PsiAnonymousClass && (options & 0x8000) != 0) {
                PsiClassType baseClassReference = ((PsiAnonymousClass)aClass).getBaseClassType();
                PsiClass baseClass = baseClassReference.resolve();
                String name = baseClass == null ? baseClassReference.getPresentableText() : PsiFormatUtil.formatClass(baseClass, options);
                buffer.append(PsiBundle.message("anonymous.class.derived.display", name));
            } else {
                String name = aClass.getName();
                if (name != null) {
                    if (buffer.length() > 0) {
                        buffer.append(' ');
                    }
                    if ((options & 0x800) != 0) {
                        String qName = aClass.getQualifiedName();
                        if (qName != null) {
                            buffer.append(qName);
                        } else {
                            buffer.append(aClass.getName());
                        }
                    } else {
                        buffer.append(aClass.getName());
                    }
                }
            }
        }
        if ((options & 8) != 0 && (options & 0x10) != 0 && (modifiers = PsiFormatUtil.formatModifiers(aClass, options)).length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(modifiers);
        }
        if ((options & 0x400) != 0) {
            String implementsText;
            String extendsText = PsiFormatUtil.formatReferenceList(aClass.getExtendsList(), options);
            if (extendsText.length() > 0) {
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
                buffer.append("extends ");
                buffer.append(extendsText);
            }
            if ((implementsText = PsiFormatUtil.formatReferenceList(aClass.getImplementsList(), options)).length() > 0) {
                if (buffer.length() > 0) {
                    buffer.append(' ');
                }
                buffer.append("implements ");
                buffer.append(implementsText);
            }
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiFormatUtil.formatClass must not return null");
        }
        return string;
    }

    public static String formatModifiers(PsiElement element, int options) throws IllegalArgumentException {
        PsiModifierList list;
        boolean isInterface = false;
        if (element instanceof PsiVariable) {
            list = ((PsiVariable)element).getModifierList();
        } else if (element instanceof PsiMethod) {
            list = ((PsiMethod)element).getModifierList();
        } else if (element instanceof PsiClass) {
            isInterface = ((PsiClass)element).isInterface();
            list = ((PsiClass)element).getModifierList();
            if (list == null) {
                return "";
            }
        } else if (element instanceof PsiClassInitializer) {
            list = ((PsiClassInitializer)element).getModifierList();
            if (list == null) {
                return "";
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (list == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if ((options & 0x20) != 0 ? list.hasModifierProperty("public") : list.hasExplicitModifier("public")) {
            PsiFormatUtil.appendModifier(buffer, "public");
        }
        if (list.hasModifierProperty("protected")) {
            PsiFormatUtil.appendModifier(buffer, "protected");
        }
        if (list.hasModifierProperty("private")) {
            PsiFormatUtil.appendModifier(buffer, "private");
        }
        if ((options & 0x20) != 0 ? list.hasModifierProperty("packageLocal") : list.hasExplicitModifier("packageLocal")) {
            if (element instanceof PsiClass && element.getParent() instanceof PsiDeclarationStatement) {
                PsiFormatUtil.appendModifier(buffer, PsiBundle.message("local.class.preposition", new Object[0]));
            } else {
                PsiFormatUtil.appendModifier(buffer, PsiBundle.message("package.local.visibility", new Object[0]));
            }
        }
        if ((options & 0x20) != 0 ? list.hasModifierProperty("static") : list.hasExplicitModifier("static")) {
            PsiFormatUtil.appendModifier(buffer, "static");
        }
        if (!isInterface && ((options & 0x20) != 0 ? list.hasModifierProperty("abstract") : list.hasExplicitModifier("abstract"))) {
            PsiFormatUtil.appendModifier(buffer, "abstract");
        }
        if ((options & 0x20) != 0 ? list.hasModifierProperty("final") : list.hasExplicitModifier("final")) {
            PsiFormatUtil.appendModifier(buffer, "final");
        }
        if (list.hasModifierProperty("native") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "native");
        }
        if (list.hasModifierProperty("synchronized") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "synchronized");
        }
        if (list.hasModifierProperty("strictfp") && (options & 0x4000) == 0) {
            PsiFormatUtil.appendModifier(buffer, "strictfp");
        }
        if (list.hasModifierProperty("transient") && element instanceof PsiVariable) {
            PsiFormatUtil.appendModifier(buffer, "transient");
        }
        if (list.hasModifierProperty("volatile")) {
            PsiFormatUtil.appendModifier(buffer, "volatile");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private static void appendModifier(StringBuilder buffer, String modifier) {
        buffer.append(modifier);
        buffer.append(' ');
    }

    public static String formatReferenceList(PsiReferenceList list, int options) {
        StringBuilder buffer = new StringBuilder();
        PsiJavaCodeReferenceElement[] refs = list.getReferenceElements();
        for (int i = 0; i < refs.length; ++i) {
            PsiJavaCodeReferenceElement ref = refs[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(PsiFormatUtil.formatReference(ref, options));
        }
        return buffer.toString();
    }

    public static String formatType(PsiType type, int options, PsiSubstitutor substitutor) {
        type = substitutor.substitute(type);
        if ((options & 0x10000) != 0) {
            type = TypeConversionUtil.erasure(type);
        }
        if ((options & 0x2000) != 0) {
            return type.getInternalCanonicalText();
        }
        return type.getPresentableText();
    }

    public static String formatReference(PsiJavaCodeReferenceElement ref, int options) {
        if ((options & 0x2000) != 0) {
            return ref.getCanonicalText();
        }
        return ref.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getExternalName(PsiModifierListOwner owner) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            PsiMethod psiMethod;
            if (owner instanceof PsiClass) {
                ClassUtil.formatClassName((PsiClass)owner, builder);
                String string = builder.toString();
                return string;
            }
            PsiClass psiClass = PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class, false);
            assert (psiClass != null);
            ClassUtil.formatClassName(psiClass, builder);
            if (owner instanceof PsiMethod) {
                String string = builder.toString() + " " + PsiFormatUtil.formatMethod((PsiMethod)owner, PsiSubstitutor.EMPTY, 10499, 8195);
                return string;
            }
            if (owner instanceof PsiField) {
                String string = builder.toString() + " " + ((PsiField)owner).getName();
                return string;
            }
            if (owner instanceof PsiParameter && (psiMethod = PsiTreeUtil.getParentOfType((PsiElement)owner, PsiMethod.class)) != null) {
                String string = builder.toString() + " " + PsiFormatUtil.formatMethod(psiMethod, PsiSubstitutor.EMPTY, 10499, 8195) + " " + PsiFormatUtil.formatVariable((PsiVariable)owner, 1, PsiSubstitutor.EMPTY);
                return string;
            }
        }
        finally {
            StringBuilderSpinAllocator.dispose(builder);
        }
        return null;
    }
}

