/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.util.IncorrectOperationException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PropertyUtil");

    private PropertyUtil() {
    }

    public static boolean isSimplePropertyGetter(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        PsiType returnType = method.getReturnType();
        if (methodName.startsWith("get") && methodName.length() > "get".length()) {
            if (Character.isLowerCase(methodName.charAt("get".length())) && (methodName.length() == "get".length() + 1 || Character.isLowerCase(methodName.charAt("get".length() + 1)))) {
                return false;
            }
            if (returnType != null && returnType == PsiType.VOID) {
                return false;
            }
        } else if (methodName.startsWith("is")) {
            if (returnType != null && returnType != PsiType.BOOLEAN) {
                return false;
            }
        } else {
            return false;
        }
        return method.getParameterList().getParametersCount() == 0;
    }

    public static boolean isSimplePropertySetter(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        if (!methodName.startsWith("set") || methodName.length() <= "set".length()) {
            return false;
        }
        if (Character.isLowerCase(methodName.charAt("set".length()))) {
            return false;
        }
        if (method.getParameterList().getParametersCount() != 1) {
            return false;
        }
        return method.getReturnType() == null || method.getReturnType() == PsiType.VOID;
    }

    @Nullable
    public static String getPropertyName(PsiMethod method) {
        if (PropertyUtil.isSimplePropertyGetter(method)) {
            return PropertyUtil.getPropertyNameByGetter(method);
        }
        if (PropertyUtil.isSimplePropertySetter(method)) {
            return PropertyUtil.getPropertyNameBySetter(method);
        }
        return null;
    }

    public static String getPropertyNameByGetter(PsiMethod getterMethod) {
        String methodName = getterMethod.getName();
        return methodName.startsWith("get") ? StringUtil.decapitalize(methodName.substring(3)) : StringUtil.decapitalize(methodName.substring(2));
    }

    public static String getPropertyNameBySetter(PsiMethod setterMethod) {
        String methodName = setterMethod.getName();
        return Introspector.decapitalize(methodName.substring(3));
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertyGetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertyGetter(method) || !PropertyUtil.getPropertyNameByGetter(method).equals(propertyName) || !type.equals(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    public static boolean isSimplePropertyAccessor(PsiMethod method) {
        return PropertyUtil.isSimplePropertyGetter(method) || PropertyUtil.isSimplePropertySetter(method);
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName, boolean isStatic, boolean checkSuperClasses) {
        if (aClass == null) {
            return null;
        }
        PsiMethod[] methods = checkSuperClasses ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findPropertySetterWithType(String propertyName, boolean isStatic, PsiType type, Iterator<PsiMethod> methods) {
        while (methods.hasNext()) {
            PsiType methodType;
            PsiMethod method = methods.next();
            if (method.hasModifierProperty("static") != isStatic || !PropertyUtil.isSimplePropertySetter(method) || !PropertyUtil.getPropertyNameBySetter(method).equals(propertyName) || !type.equals(methodType = method.getParameterList().getParameters()[0].getType())) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyField(Project project, PsiClass aClass, String propertyName, boolean isStatic) {
        PsiField[] fields;
        for (PsiField field : fields = aClass.getAllFields()) {
            if (field.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtil.suggestPropertyName(project, field))) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiField findPropertyFieldWithType(Project project, String propertyName, boolean isStatic, PsiType type, Iterator<PsiField> fields) {
        while (fields.hasNext()) {
            PsiField field = fields.next();
            if (field.hasModifierProperty("static") != isStatic || !propertyName.equals(PropertyUtil.suggestPropertyName(project, field)) || !type.equals(field.getType())) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(@NonNls String methodName) {
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    public static String suggestGetterName(String propertyName, PsiType propertyType) {
        return PropertyUtil.suggestGetterName(propertyName, propertyType, null);
    }

    public static String suggestGetterName(String propertyName, PsiType propertyType, String existingGetterName) {
        StringBuffer name = new StringBuffer(StringUtil.capitalize(propertyName));
        if (propertyType == PsiType.BOOLEAN) {
            if (existingGetterName == null || !existingGetterName.startsWith("get")) {
                name.insert(0, "is");
            } else {
                name.insert(0, "get");
            }
        } else {
            name.insert(0, "get");
        }
        return name.toString();
    }

    public static String suggestSetterName(String propertyName) {
        StringBuffer name = new StringBuffer(StringUtil.capitalize(propertyName));
        name.insert(0, "set");
        return name.toString();
    }

    public static String[] getReadableProperties(PsiClass aClass, boolean includeSuperClass) {
        ArrayList<String> result = new ArrayList<String>();
        PsiMethod[] methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertyGetter(method)) continue;
            result.add(PropertyUtil.getPropertyName(method));
        }
        return result.toArray(new String[result.size()]);
    }

    public static String[] getWritableProperties(PsiClass aClass, boolean includeSuperClass) {
        ArrayList<String> result = new ArrayList<String>();
        PsiMethod[] methods = includeSuperClass ? aClass.getAllMethods() : aClass.getMethods();
        for (PsiMethod method : methods) {
            if ("java.lang.Object".equals(method.getContainingClass().getQualifiedName()) || !PropertyUtil.isSimplePropertySetter(method)) continue;
            result.add(PropertyUtil.getPropertyName(method));
        }
        return result.toArray(new String[result.size()]);
    }

    public static PsiMethod generateGetterPrototype(PsiField field) {
        PsiElementFactory factory = field.getManager().getElementFactory();
        Project project = field.getProject();
        String name = field.getName();
        String getName = PropertyUtil.suggestGetterName(project, field);
        try {
            PsiMethod getMethod = factory.createMethod(getName, field.getType());
            getMethod.getModifierList().setModifierProperty("public", true);
            if (field.hasModifierProperty("static")) {
                getMethod.getModifierList().setModifierProperty("static", true);
            }
            PropertyUtil.annotateWithNullableStuff(field, factory, getMethod);
            PsiCodeBlock body = factory.createCodeBlockFromText("{\nreturn " + name + ";\n}", null);
            getMethod.getBody().replace(body);
            getMethod = (PsiMethod)CodeStyleManager.getInstance(project).reformat(getMethod);
            return getMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    public static PsiMethod generateSetterPrototype(PsiField field) {
        return PropertyUtil.generateSetterPrototype(field, field.getContainingClass());
    }

    public static PsiMethod generateSetterPrototype(PsiField field, PsiClass containingClass) {
        Project project = field.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project);
        PsiElementFactory factory = field.getManager().getElementFactory();
        String name = field.getName();
        boolean isStatic = field.hasModifierProperty("static");
        VariableKind kind = codeStyleManager.getVariableKind(field);
        String propertyName = codeStyleManager.variableNameToPropertyName(name, kind);
        String setName = PropertyUtil.suggestSetterName(project, field);
        try {
            PsiMethod setMethod = factory.createMethod(setName, PsiType.VOID);
            String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            PsiParameter param = factory.createParameter(parameterName, field.getType());
            PropertyUtil.annotateWithNullableStuff(field, factory, param);
            setMethod.getParameterList().add(param);
            setMethod.getModifierList().setModifierProperty("public", true);
            setMethod.getModifierList().setModifierProperty("static", isStatic);
            StringBuffer buffer = new StringBuffer();
            buffer.append("{\n");
            if (name.equals(parameterName)) {
                if (!isStatic) {
                    buffer.append("this.");
                } else {
                    String className = containingClass.getName();
                    if (className != null) {
                        buffer.append(className);
                        buffer.append(".");
                    }
                }
            }
            buffer.append(name);
            buffer.append("=");
            buffer.append(parameterName);
            buffer.append(";\n}");
            PsiCodeBlock body = factory.createCodeBlockFromText(buffer.toString(), null);
            setMethod.getBody().replace(body);
            setMethod = (PsiMethod)codeStyleManager.reformat(setMethod);
            return setMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    private static void annotateWithNullableStuff(PsiModifierListOwner field, PsiElementFactory factory, PsiModifierListOwner listOwner) throws IncorrectOperationException {
        if (AnnotationUtil.isAnnotated(field, "org.jetbrains.annotations.NotNull", false)) {
            PropertyUtil.annotate(factory, listOwner, "org.jetbrains.annotations.NotNull");
        } else if (AnnotationUtil.isAnnotated(field, "org.jetbrains.annotations.Nullable", false)) {
            PropertyUtil.annotate(factory, listOwner, "org.jetbrains.annotations.Nullable");
        }
    }

    private static void annotate(PsiElementFactory factory, PsiModifierListOwner listOwner, String annotationQName) throws IncorrectOperationException {
        PsiModifierList modifierList = listOwner.getModifierList();
        LOG.assertTrue(modifierList != null);
        modifierList.addAfter(factory.createAnnotationFromText("@" + annotationQName, listOwner), null);
    }

    public static String suggestPropertyName(Project project, PsiField field) {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project);
        VariableKind kind = codeStyleManager.getVariableKind(field);
        return codeStyleManager.variableNameToPropertyName(field.getName(), kind);
    }

    public static String suggestGetterName(Project project, PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(project, field);
        return PropertyUtil.suggestGetterName(propertyName, field.getType());
    }

    public static String suggestSetterName(Project project, PsiField field) {
        String propertyName = PropertyUtil.suggestPropertyName(project, field);
        return PropertyUtil.suggestSetterName(propertyName);
    }

    @Nullable
    public static String suggestPropertyAccessor(String name, PsiMethod accessorTemplate) {
        if (PropertyUtil.isSimplePropertyGetter(accessorTemplate)) {
            PsiType type = accessorTemplate.getReturnType();
            return PropertyUtil.suggestGetterName(name, type, accessorTemplate.getName());
        }
        if (PropertyUtil.isSimplePropertySetter(accessorTemplate)) {
            return PropertyUtil.suggestSetterName(name);
        }
        return null;
    }

    @Nullable
    public static String getPropertyName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return PropertyUtil.getPropertyName((PsiMethod)member);
        }
        if (member instanceof PsiField) {
            return member.getName();
        }
        return null;
    }

    @Nullable
    public static PsiType getPropertyType(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getType();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnType();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getType();
            }
        }
        return null;
    }

    @Nullable
    public static PsiTypeElement getPropertyTypeElement(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getTypeElement();
        }
        if (member instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)member;
            if (PropertyUtil.isSimplePropertyGetter(psiMethod)) {
                return psiMethod.getReturnTypeElement();
            }
            if (PropertyUtil.isSimplePropertySetter(psiMethod)) {
                return psiMethod.getParameterList().getParameters()[0].getTypeElement();
            }
        }
        return null;
    }

    @Nullable
    public static PsiIdentifier getPropertyNameIdentifier(PsiMember member) {
        if (member instanceof PsiField) {
            return ((PsiField)member).getNameIdentifier();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).getNameIdentifier();
        }
        return null;
    }
}

