/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureHandMade;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSignatureUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.MethodSignatureUtil");
    public static final TObjectHashingStrategy<MethodSignatureBackedByPsiMethod> METHOD_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<MethodSignatureBackedByPsiMethod>(){

        public int computeHashCode(MethodSignatureBackedByPsiMethod signature) {
            return signature.getMethod().hashCode();
        }

        public boolean equals(MethodSignatureBackedByPsiMethod s1, MethodSignatureBackedByPsiMethod s2) {
            return s1.getMethod().equals(s2.getMethod());
        }
    };
    public static final TObjectHashingStrategy<MethodSignature> METHOD_PARAMETERS_ERASURE_EQUALITY = new MethodParametersErasureEquality();

    private MethodSignatureUtil() {
    }

    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        return new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor);
    }

    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameterList, @NotNull PsiSubstitutor substitutor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        return new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor);
    }

    public static boolean areSignaturesEqual(PsiMethod method1, PsiMethod method2) {
        return method1.getSignature(PsiSubstitutor.EMPTY).equals(method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesEqual(MethodSignature method1, MethodSignature method2) {
        if (method2 == method1) {
            return true;
        }
        if (MethodSignatureUtil.checkDifferentSignaturesLightweight(method1, method2)) {
            return false;
        }
        PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method1, method2);
        return MethodSignatureUtil.checkSignaturesEqualInner(method1, method2, unifyingSubstitutor);
    }

    private static boolean checkSignaturesEqualInner(MethodSignature subSignature, MethodSignature superSignature, PsiSubstitutor unifyingSubstitutor) {
        if (unifyingSubstitutor == null) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type2;
            PsiType type1 = unifyingSubstitutor.substitute(subParameterTypes[i]);
            if (Comparing.equal(type1, type2 = unifyingSubstitutor.substitute(superParameterTypes[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkDifferentSignaturesLightweight(MethodSignature sig1, MethodSignature sig2) {
        PsiType[] parameterTypes2;
        String name2;
        String name1 = sig1.getName();
        if (!name1.equals(name2 = sig2.getName())) {
            return true;
        }
        PsiType[] parameterTypes1 = sig1.getParameterTypes();
        if (parameterTypes1.length != (parameterTypes2 = sig2.getParameterTypes()).length) {
            return true;
        }
        for (int i = 0; i < parameterTypes1.length; ++i) {
            PsiType type1 = parameterTypes1[i];
            PsiType type2 = parameterTypes2[i];
            if (type1 instanceof PsiPrimitiveType != type2 instanceof PsiPrimitiveType) {
                return true;
            }
            if (!(type1 instanceof PsiPrimitiveType) || type1.equals(type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSuperMethod(PsiMethod superMethodCandidate, PsiMethod derivedMethod) {
        PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
        PsiClass derivedClass = derivedMethod.getContainingClass();
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClassCandidate, derivedClass, PsiSubstitutor.EMPTY);
        MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
        MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.isSubsignature(superSignature, derivedSignature);
    }

    @Nullable
    public static PsiMethod findMethodInSuperClassBySignatureInDerived(@NotNull PsiClass aClass, @NotNull PsiClass superClass, MethodSignature signature, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived must not be null");
        }
        if (superClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived must not be null");
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(superClass, superSubstitutor, signature, checkDeep);
    }

    @Nullable
    private static PsiMethod doFindMethodInSuperClassBySignatureInDerived(PsiClass superClass, PsiSubstitutor superSubstitutor, MethodSignature signature, boolean checkDeep) {
        PsiClass clazz;
        PsiMethod[] methods;
        String name = signature.getName();
        for (PsiMethod method : methods = superClass.findMethodsByName(name, false)) {
            if (!MethodSignatureUtil.isSubsignature(method.getSignature(superSubstitutor), signature)) continue;
            return method;
        }
        if (checkDeep && (clazz = superClass.getSuperClass()) != null) {
            PsiSubstitutor substitutor1 = TypeConversionUtil.getSuperClassSubstitutor(clazz, superClass, superSubstitutor);
            return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(clazz, substitutor1, signature, true);
        }
        return null;
    }

    public static PsiMethod findMethodBySignature(PsiClass aClass, PsiMethod pattenMethod, boolean checkBases) {
        return MethodSignatureUtil.findMethodBySignature(aClass, pattenMethod.getSignature(PsiSubstitutor.EMPTY), checkBases);
    }

    public static PsiMethod findMethodBySignature(PsiClass aClass, MethodSignature methodSignature, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(methodSignature.getName(), checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!methodSignature.equals(foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperSignature(PsiClass aClass, MethodSignature methodSignature, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(methodSignature.getName(), checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!MethodSignatureUtil.isSubsignature(methodSignature, foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    public static PsiMethod findMethodBySuperMethod(PsiClass aClass, PsiMethod method, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(method.getName(), checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            MethodSignature superSignature;
            PsiMethod candidate = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature candidateSignature = candidate.getSignature(substitutor);
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor(method.getContainingClass(), candidate.getContainingClass(), substitutor);
            if (superSubstitutor == null || !MethodSignatureUtil.isSubsignature(superSignature = method.getSignature(superSubstitutor), candidateSignature)) continue;
            return candidate;
        }
        return null;
    }

    public static boolean hasOverloads(PsiMethod method) {
        return MethodSignatureUtil.getOverloads(method).length > 1;
    }

    public static PsiMethod[] getOverloads(PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return new PsiMethod[]{method};
        }
        return aClass.findMethodsByName(method.getName(), false);
    }

    public static boolean areParametersErasureEqual(PsiMethod method1, PsiMethod method2) {
        return METHOD_PARAMETERS_ERASURE_EQUALITY.equals((Object)method1.getSignature(PsiSubstitutor.EMPTY), (Object)method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static PsiSubstitutor getSuperMethodSignatureSubstitutor(MethodSignature methodSignature, MethodSignature superMethodSignature) {
        PsiSubstitutor result = MethodSignatureUtil.getSuperMethodSignatureSubstitutorImpl(methodSignature, superMethodSignature);
        if (result == null) {
            return null;
        }
        PsiTypeParameter[] typeParameters1 = methodSignature.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = superMethodSignature.getTypeParameters();
        PsiSubstitutor substitutor1 = methodSignature.getSubstitutor();
        for (int i = 0; i < typeParameters1.length; ++i) {
            PsiClassType[] supers2;
            PsiTypeParameter typeParameter1 = typeParameters1[i];
            PsiTypeParameter typeParameter2 = typeParameters2[i];
            PsiClassType[] supers1 = typeParameter1.getSuperTypes();
            if (supers1.length != (supers2 = typeParameter2.getSuperTypes()).length) {
                return null;
            }
            for (int j = 0; j < supers1.length; ++j) {
                PsiType type2;
                PsiType type1 = substitutor1.substitute(supers1[j]);
                if (type1.equals(type2 = result.substitute(supers2[j]))) continue;
                return null;
            }
        }
        return result;
    }

    private static PsiSubstitutor getSuperMethodSignatureSubstitutorImpl(MethodSignature signature1, MethodSignature signature2) {
        PsiTypeParameter[] typeParameters2;
        PsiTypeParameter[] typeParameters1 = signature1.getTypeParameters();
        if (typeParameters1.length != (typeParameters2 = signature2.getTypeParameters()).length) {
            return null;
        }
        PsiSubstitutor result = signature2.getSubstitutor();
        for (int i = 0; i < typeParameters1.length; ++i) {
            PsiElementFactory factory = typeParameters1[i].getManager().getElementFactory();
            result = result.put(typeParameters2[i], factory.createType(typeParameters1[i]));
        }
        return result;
    }

    public static PsiSubstitutor combineSubstitutors(PsiSubstitutor substitutor1, PsiSubstitutor substitutor2) {
        PsiTypeParameter[] typeParameters;
        if (substitutor1 == PsiSubstitutor.EMPTY) {
            return substitutor2;
        }
        for (PsiTypeParameter typeParameter : typeParameters = substitutor1.getSubstitutionMap().keySet().toArray(PsiTypeParameter.EMPTY_ARRAY)) {
            PsiClass resolved;
            PsiType type = substitutor1.substitute(typeParameter);
            PsiType otherSubstituted = type instanceof PsiClassType ? ((resolved = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter ? substitutor2.substitute((PsiTypeParameter)resolved) : substitutor2.substitute(type)) : substitutor2.substitute(type);
            substitutor1 = substitutor1.put(typeParameter, otherSubstituted);
        }
        return substitutor1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiMethod[] convertMethodSignaturesToMethods(List<MethodSignatureBackedByPsiMethod> sameNameMethodList) {
        PsiMethod[] methods = new PsiMethod[sameNameMethodList.size()];
        for (int i = 0; i < sameNameMethodList.size(); ++i) {
            methods[i] = sameNameMethodList.get(i).getMethod();
        }
        if (methods == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.convertMethodSignaturesToMethods must not return null");
        }
        return methods;
    }

    public static boolean isSubsignature(MethodSignature superSignature, MethodSignature subSignature) {
        if (subSignature == superSignature) {
            return true;
        }
        if (MethodSignatureUtil.checkDifferentSignaturesLightweight(superSignature, subSignature)) {
            return false;
        }
        PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(superSignature, subSignature);
        if (MethodSignatureUtil.checkSignaturesEqualInner(superSignature, subSignature, unifyingSubstitutor)) {
            return true;
        }
        if (subSignature.getTypeParameters().length > 0) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type1 = subParameterTypes[i];
            PsiType type2 = TypeConversionUtil.erasure(superParameterTypes[i]);
            if (Comparing.equal(type1, type2)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodParametersErasureEquality
    implements TObjectHashingStrategy<MethodSignature> {
        private MethodParametersErasureEquality() {
        }

        public int computeHashCode(MethodSignature signature) {
            int result = signature.getName().hashCode();
            return result += 37 * signature.getParameterTypes().length;
        }

        public boolean equals(MethodSignature method1, MethodSignature method2) {
            PsiType[] parameterTypes2;
            if (!method1.getName().equals(method2.getName())) {
                return false;
            }
            PsiType[] parameterTypes1 = method1.getParameterTypes();
            if (parameterTypes1.length != (parameterTypes2 = method2.getParameterTypes()).length) {
                return false;
            }
            PsiSubstitutor substitutor1 = method1.getSubstitutor();
            PsiSubstitutor substitutor2 = method2.getSubstitutor();
            for (int i = 0; i < parameterTypes1.length; ++i) {
                PsiType type2;
                PsiType type1 = TypeConversionUtil.erasure(substitutor1.substitute(parameterTypes1[i]), substitutor1);
                if (Comparing.equal(type1, type2 = TypeConversionUtil.erasure(substitutor2.substitute(parameterTypes2[i]), substitutor2))) continue;
                return false;
            }
            return true;
        }
    }
}

