/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodSignatureBase
implements MethodSignature {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.MethodSignatureBase");
    private final PsiSubstitutor mySubstitutor;
    private final PsiType[] myParameterTypes;
    protected final PsiTypeParameter[] myTypeParameters;

    protected MethodSignatureBase(PsiSubstitutor substitutor, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameters) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBase.<init> must not be null");
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBase.<init> must not be null");
        }
        this.mySubstitutor = substitutor;
        this.myParameterTypes = parameterTypes.length == 0 ? PsiType.EMPTY_ARRAY : new PsiType[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiType type = parameterTypes[i];
            if (type instanceof PsiEllipsisType) {
                type = ((PsiEllipsisType)type).toArrayType();
            }
            this.myParameterTypes[i] = substitutor.substitute(type);
        }
        this.myTypeParameters = typeParameters;
    }

    protected MethodSignatureBase(PsiSubstitutor substitutor, PsiParameterList parameterList, @Nullable PsiTypeParameterList typeParameterList) {
        LOG.assertTrue(substitutor != null);
        this.mySubstitutor = substitutor;
        if (parameterList != null) {
            PsiParameter[] parameters = parameterList.getParameters();
            this.myParameterTypes = parameters.length == 0 ? PsiType.EMPTY_ARRAY : new PsiType[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                PsiType type = parameters[i].getType();
                if (type instanceof PsiEllipsisType) {
                    type = ((PsiEllipsisType)type).toArrayType();
                }
                this.myParameterTypes[i] = substitutor.substitute(type);
            }
        } else {
            this.myParameterTypes = PsiType.EMPTY_ARRAY;
        }
        this.myTypeParameters = typeParameterList == null ? PsiTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
    }

    @NotNull
    public PsiType[] getParameterTypes() {
        if (this.myParameterTypes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBase.getParameterTypes must not return null");
        }
        return this.myParameterTypes;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (this.myTypeParameters == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBase.getTypeParameters must not return null");
        }
        return this.myTypeParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)o;
        return MethodSignatureUtil.areSignaturesEqual(methodSignature, this);
    }

    public int hashCode() {
        PsiType firstParamType;
        int result = this.getName().hashCode();
        PsiType[] parameterTypes = this.getParameterTypes();
        result += 37 * parameterTypes.length;
        PsiType psiType = firstParamType = parameterTypes.length != 0 ? parameterTypes[0] : null;
        if (firstParamType != null) {
            result += firstParamType.hashCode();
        }
        return result;
    }

    public String toString() {
        String s = "MethodSignature: ";
        PsiTypeParameter[] typeParameters = this.getTypeParameters();
        if (typeParameters.length != 0) {
            String sep = "<";
            for (PsiTypeParameter typeParameter : typeParameters) {
                s = s + sep + typeParameter.getName();
                sep = ", ";
            }
            s = s + ">";
        }
        s = s + this.getName() + "(" + Arrays.asList(this.getParameterTypes()) + ")";
        return s;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBase.getSubstitutor must not return null");
        }
        return psiSubstitutor;
    }
}

