/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class MethodSignatureBackedByPsiMethod
extends MethodSignatureBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.MethodSignatureBackedByPsiMethod");
    private final PsiMethod myMethod;
    private final boolean myIsRaw;
    private final boolean myIsInGenericContext;

    protected MethodSignatureBackedByPsiMethod(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean isRaw, boolean isInGenericContext, PsiType[] parameterTypes, PsiTypeParameter[] methodTypeParameters) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBackedByPsiMethod.<init> must not be null");
        }
        super(substitutor, parameterTypes, methodTypeParameters);
        this.myIsRaw = isRaw;
        this.myIsInGenericContext = isInGenericContext;
        if (!method.isValid()) {
            LOG.error("Invalid method: " + method);
        }
        this.myMethod = method;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getName() {
        String string = this.myMethod.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBackedByPsiMethod.getName must not return null");
        }
        return string;
    }

    public boolean isRaw() {
        return this.myIsRaw;
    }

    public boolean isInGenericContext() {
        return this.myIsInGenericContext;
    }

    public boolean equals(Object o) {
        if (o instanceof MethodSignatureBackedByPsiMethod && ((MethodSignatureBackedByPsiMethod)o).myMethod == this.myMethod) {
            return true;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiMethod getMethod() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBackedByPsiMethod.getMethod must not return null");
        }
        return psiMethod;
    }

    public static MethodSignatureBackedByPsiMethod create(PsiMethod method, PsiSubstitutor substitutor) {
        boolean isRaw = PsiUtil.isRawSubstitutor(method, substitutor);
        PsiTypeParameter[] methodTypeParameters = method.getTypeParameters();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiType[] parameterTypes = new PsiType[parameters.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = parameters[i].getType();
        }
        boolean isInGenericContext = false;
        if (isRaw) {
            for (PsiTypeParameter typeParameter : methodTypeParameters) {
                substitutor = substitutor.put(typeParameter, null);
            }
            methodTypeParameters = PsiTypeParameter.EMPTY_ARRAY;
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[i] = TypeConversionUtil.erasure(parameterTypes[i]);
            }
            isInGenericContext = false;
        } else {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                Iterator<PsiTypeParameter> iterator = PsiUtil.typeParametersIterator(containingClass);
                while (iterator.hasNext()) {
                    if (substitutor.substitute(iterator.next()) == null) continue;
                    isInGenericContext = true;
                    break;
                }
            }
        }
        return new MethodSignatureBackedByPsiMethod(method, substitutor, isRaw, isInGenericContext, parameterTypes, methodTypeParameters);
    }
}

