/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InheritanceUtil {
    public static boolean isInheritor(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep) {
        if (candidateClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        return candidateClass.isInheritor(baseClass, checkDeep);
    }

    public static boolean isInheritorOrSelf(@Nullable PsiClass aClass, @Nullable PsiClass baseClass, boolean checkDeep) {
        if (aClass == null || baseClass == null) {
            return false;
        }
        PsiManager manager = aClass.getManager();
        return manager.areElementsEquivalent(baseClass, aClass) || aClass.isInheritor(baseClass, checkDeep);
    }

    public static boolean isCorrectDescendant(@Nullable PsiClass aClass, @Nullable PsiClass baseClass, boolean checkDeep) {
        return InheritanceUtil.isInheritorOrSelf(aClass, baseClass, checkDeep);
    }
}

