/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className) {
        if (className != null) {
            int i = className.lastIndexOf(46);
            return i == -1 ? "" : className.substring(0, i);
        }
        return null;
    }

    public static String extractClassName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/ClassUtil.extractClassName must not be null");
        }
        int i = fqName.lastIndexOf(46);
        return i == -1 ? fqName : fqName.substring(i + 1);
    }

    public static String createNewClassQualifiedName(String qualifiedName, String className) {
        if (className == null) {
            return null;
        }
        if (qualifiedName == null || qualifiedName.length() == 0) {
            return className;
        }
        return qualifiedName + "." + ClassUtil.extractClassName(className);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (containingDirectory.isSourceRoot()) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass, StringBuilder buf) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/ClassUtil.formatClassName must not be null");
        }
        String qName = aClass.getQualifiedName();
        if (qName != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass));
                String name = aClass.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    public static int getNonQualifiedClassIdx(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/ClassUtil.getNonQualifiedClassIdx must not be null");
        }
        final int[] result = new int[]{-1};
        PsiClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class);
        if (containingClass != null) {
            containingClass.accept(new PsiRecursiveElementVisitor(){
                private int myCurrentIdx = 0;

                public void visitElement(PsiElement element) {
                    if (result[0] == -1) {
                        super.visitElement(element);
                    }
                }

                public void visitClass(PsiClass aClass) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (psiClass == aClass) {
                            result[0] = this.myCurrentIdx;
                        }
                    }
                }
            });
        }
        return result[0];
    }

    public static PsiClass findNonQualifiedClassByIndex(String indexName, @NotNull PsiClass containingClass) {
        if (containingClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/ClassUtil.findNonQualifiedClassByIndex must not be null");
        }
        return ClassUtil.findNonQualifiedClassByIndex(indexName, containingClass, false);
    }

    public static PsiClass findNonQualifiedClassByIndex(String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        if (containingClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/ClassUtil.findNonQualifiedClassByIndex must not be null");
        }
        String prefix = ClassUtil.getDigitPrefix(indexName);
        final int idx = prefix.length() > 0 ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result = new PsiClass[1];
        containingClass.accept(new PsiRecursiveElementVisitor(){
            private int myCurrentIdx = 0;

            public void visitElement(PsiElement element) {
                if (result[0] == null) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                if (!jvmCompatible) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual(name, aClass.getName())) {
                            result[0] = aClass;
                        }
                    }
                    return;
                }
                if (aClass == containingClass) {
                    super.visitClass(aClass);
                    return;
                }
                if (aClass.getQualifiedName() == null && Comparing.strEqual(name, aClass.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result[0] = aClass;
                    }
                }
            }

            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDigitPrefix(String indexName) {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            char c;
            for (int i = 0; i < indexName.length() && Character.isDigit(c = indexName.charAt(i)); ++i) {
                builder.append(c);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose(builder);
        }
    }

    @Nullable
    public static PsiClass findPsiClass(PsiManager psiManager, String externalName) {
        return ClassUtil.findPsiClass(psiManager, externalName, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(PsiManager psiManager, String externalName, PsiClass psiClass, boolean jvmCompatible) {
        int topIdx = externalName.indexOf(36);
        if (topIdx > -1) {
            if (psiClass == null) {
                psiClass = psiManager.findClass(externalName.substring(0, topIdx), GlobalSearchScope.allScope(psiManager.getProject()));
            }
            if (psiClass == null) {
                return null;
            }
            externalName = externalName.substring(topIdx + 1);
            return ClassUtil.findSubclass(psiManager, externalName, psiClass, jvmCompatible);
        }
        return psiManager.findClass(externalName, GlobalSearchScope.allScope(psiManager.getProject()));
    }

    @Nullable
    private static PsiClass findSubclass(PsiManager psiManager, String externalName, PsiClass psiClass, boolean jvmCompatible) {
        int nextIdx = externalName.indexOf("$");
        if (nextIdx > -1) {
            PsiClass anonymousClass = ClassUtil.findNonQualifiedClassByIndex(externalName.substring(0, nextIdx), psiClass, jvmCompatible);
            if (anonymousClass == null) {
                return null;
            }
            return ClassUtil.findPsiClass(psiManager, externalName.substring(nextIdx), anonymousClass, jvmCompatible);
        }
        return ClassUtil.findNonQualifiedClassByIndex(externalName, psiClass, jvmCompatible);
    }

    @Nullable
    public static String getJVMClassName(PsiClass aClass) {
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return null;
        }
        return ClassUtil.replaceDotsWithDollars(qName, aClass);
    }

    private static String replaceDotsWithDollars(String qName, PsiClass aClass) {
        int dotIndex;
        StringBuilder qNameBuffer = new StringBuilder(qName);
        int fromIndex = qNameBuffer.length();
        PsiElement parent = aClass.getParent();
        while (parent instanceof PsiClass && (dotIndex = qNameBuffer.lastIndexOf(".", fromIndex)) >= 0) {
            qNameBuffer.replace(dotIndex, dotIndex + 1, "$");
            fromIndex = dotIndex - 1;
            parent = parent.getParent();
        }
        return qNameBuffer.toString();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(PsiManager manager, String jvmClassName) {
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }
}

