/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.Function;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachedValuesManager {
    public abstract <T> CachedValue<T> createCachedValue(CachedValueProvider<T> var1, boolean var2);

    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    public <T> CachedValue<T> createCachedValue(CachedValueProvider<T> provider) {
        return this.createCachedValue(provider, true);
    }

    @Nullable
    public <T, D extends UserDataHolder> T getCachedValue(D dataHolder, Key<CachedValue<T>> key, Function<D, CachedValueProvider<T>> providerFactory, boolean trackValue) {
        CachedValue<T> value = dataHolder.getUserData(key);
        if (value == null) {
            CachedValueProvider<T> provider = providerFactory.fun(dataHolder);
            value = this.createCachedValue(provider, trackValue);
            dataHolder.putUserData(key, value);
        }
        return value.getValue();
    }

    @Nullable
    public <T, D extends UserDataHolder> T getCachedValue(D dataHolder, Key<CachedValue<T>> key, CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value = dataHolder.getUserData(key);
        if (value == null) {
            value = this.createCachedValue(provider, trackValue);
            dataHolder.putUserData(key, value);
        }
        return value.getValue();
    }

    @Nullable
    public <T, D extends UserDataHolder, P> T getParameterizedCachedValue(D dataHolder, Key<ParameterizedCachedValue<T, P>> key, ParameterizedCachedValueProvider<T, P> provider, boolean trackValue, P parameter) {
        ParameterizedCachedValue<T, P> value = dataHolder.getUserData(key);
        if (value == null) {
            value = this.createParameterizedCachedValue(provider, trackValue);
            dataHolder.putUserData(key, value);
        }
        return value.getValue(parameter);
    }
}

