/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.psi.tree.IElementType;

public class TokenSet {
    public static final TokenSet EMPTY = new TokenSet();
    private final boolean[] mySet = new boolean[IElementType.getAllocatedTypesCount()];

    public IElementType[] getTypes() {
        int elementCount = 0;
        for (boolean bit : this.mySet) {
            if (!bit) continue;
            ++elementCount;
        }
        IElementType[] types = new IElementType[elementCount];
        int count = 0;
        for (short i = 1; i < this.mySet.length; i = (short)(i + 1)) {
            if (!this.mySet[i]) continue;
            types[count++] = IElementType.find(i);
        }
        return types;
    }

    public static TokenSet create(IElementType ... types) {
        TokenSet set = new TokenSet();
        for (IElementType type : types) {
            if (type == null) continue;
            set.mySet[type.getIndex()] = true;
        }
        return set;
    }

    public static TokenSet orSet(TokenSet ... sets) {
        TokenSet newSet = new TokenSet();
        for (TokenSet set : sets) {
            for (int i = 0; i < newSet.mySet.length && i < set.mySet.length; ++i) {
                int n = i;
                newSet.mySet[n] = newSet.mySet[n] | set.mySet[i];
            }
        }
        return newSet;
    }

    public static TokenSet andSet(TokenSet a, TokenSet b) {
        TokenSet set = new TokenSet();
        int andSize = Math.max(set.mySet.length, Math.max(a.mySet.length, b.mySet.length));
        for (int i = 0; i < andSize; ++i) {
            set.mySet[i] = a.mySet[i] && b.mySet[i];
        }
        return set;
    }

    public boolean isInSet(IElementType t) {
        return this.contains(t);
    }

    public boolean contains(IElementType t) {
        if (t == null) {
            return false;
        }
        short i = t.getIndex();
        return 0 <= i && i < this.mySet.length && this.mySet[i];
    }
}

