/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.Query;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperMethodsSearch
extends ExtensibleQueryFactory<MethodSignatureBackedByPsiMethod, SearchParameters> {
    public static SuperMethodsSearch SUPER_METHODS_SEARCH_INSTANCE = new SuperMethodsSearch();

    private SuperMethodsSearch() {
    }

    public static Query<MethodSignatureBackedByPsiMethod> search(PsiMethod derivedMethod, PsiClass psiClass, boolean checkBases, boolean allowStaticMethod) {
        SearchParameters parameters = new SearchParameters(derivedMethod, psiClass, checkBases, allowStaticMethod);
        return SUPER_METHODS_SEARCH_INSTANCE.createUniqueResultsQuery(parameters, MethodSignatureUtil.METHOD_BASED_HASHING_STRATEGY);
    }

    public static class SearchParameters {
        private final PsiMethod myMethod;
        @Nullable
        private final PsiClass myClass;
        private final boolean myCheckBases;
        private final boolean myAllowStaticMethod;

        public SearchParameters(PsiMethod method, @Nullable PsiClass aClass, boolean checkBases, boolean allowStaticMethod) {
            this.myCheckBases = checkBases;
            this.myClass = aClass;
            this.myMethod = method;
            this.myAllowStaticMethod = allowStaticMethod;
        }

        public final boolean isCheckBases() {
            return this.myCheckBases;
        }

        public final PsiMethod getMethod() {
            return this.myMethod;
        }

        @Nullable
        public final PsiClass getPsiClass() {
            return this.myClass;
        }

        public final boolean isAllowStaticMethod() {
            return this.myAllowStaticMethod;
        }
    }
}

