/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import gnu.trove.TObjectHashingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ReferencesSearch INSTANCE = new ReferencesSearch();
    private static final TObjectHashingStrategy<PsiReference> HASHING_STRATEGY = new TObjectHashingStrategy<PsiReference>(){

        public int computeHashCode(PsiReference object) {
            if (object == null) {
                return 0;
            }
            PsiElement element = object.getElement();
            PsiFile file = element.getContainingFile();
            return file.hashCode() + 31 * (element.getTextOffset() + object.getRangeInElement().getStartOffset());
        }

        public boolean equals(PsiReference o1, PsiReference o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            PsiElement e1 = o1.getElement();
            PsiElement e2 = o2.getElement();
            if (!e1.getManager().areElementsEquivalent(e1.getContainingFile(), e2.getContainingFile())) {
                return false;
            }
            return e1.getTextOffset() + o1.getRangeInElement().getStartOffset() == e2.getTextOffset() + o2.getRangeInElement().getStartOffset();
        }
    };

    private ReferencesSearch() {
    }

    public static Query<PsiReference> search(PsiElement element) {
        return ReferencesSearch.search(element, GlobalSearchScope.projectScope(element.getProject()), false);
    }

    public static Query<PsiReference> search(PsiElement element, SearchScope searchScope) {
        return ReferencesSearch.search(element, searchScope, false);
    }

    public static Query<PsiReference> search(PsiElement element, SearchScope searchScope, boolean ignoreAccessScope) {
        return ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope));
    }

    public static Query<PsiReference> search(SearchParameters parameters) {
        return INSTANCE.createUniqueResultsQuery(parameters, HASHING_STRATEGY);
    }

    public static class SearchParameters {
        private final PsiElement myElementToSearch;
        private final SearchScope myScope;
        private final boolean myIgnoreAccessScope;

        public SearchParameters(PsiElement elementToSearch, SearchScope scope, boolean ignoreAccessScope) {
            this.myElementToSearch = elementToSearch;
            this.myScope = scope;
            this.myIgnoreAccessScope = ignoreAccessScope;
        }

        public PsiElement getElementToSearch() {
            return this.myElementToSearch;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isIgnoreAccessScope() {
            return this.myIgnoreAccessScope;
        }

        public SearchScope getEffectiveSearchScope() {
            if (!this.myIgnoreAccessScope) {
                SearchScope accessScope = this.myElementToSearch.getUseScope();
                return this.myScope.intersectWith(accessScope);
            }
            return this.myScope;
        }
    }
}

