/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverridingMethodsSearch
extends ExtensibleQueryFactory<PsiMethod, SearchParameters> {
    public static OverridingMethodsSearch INSTANCE = new OverridingMethodsSearch();

    private OverridingMethodsSearch() {
    }

    public static Query<PsiMethod> search(PsiMethod method, SearchScope scope, boolean checkDeep) {
        if (OverridingMethodsSearch.cannotBeOverriden(method)) {
            return EmptyQuery.getEmptyQuery();
        }
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(method, scope, checkDeep));
    }

    private static boolean cannotBeOverriden(PsiMethod method) {
        PsiClass parentClass = method.getContainingClass();
        return parentClass == null || method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private") || parentClass instanceof PsiAnonymousClass || parentClass.hasModifierProperty("final");
    }

    public static Query<PsiMethod> search(PsiMethod method, boolean checkDeep) {
        return OverridingMethodsSearch.search(method, method.getUseScope(), checkDeep);
    }

    public static Query<PsiMethod> search(PsiMethod method) {
        return OverridingMethodsSearch.search(method, true);
    }

    public static class SearchParameters {
        private final PsiMethod myMethod;
        private final SearchScope myScope;
        private final boolean myCheckDeep;

        public SearchParameters(PsiMethod aClass, SearchScope scope, boolean checkDeep) {
            this.myMethod = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
        }

        public PsiMethod getMethod() {
            return this.myMethod;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        public SearchScope getScope() {
            return this.myScope;
        }
    }
}

