/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static MethodReferencesSearch INSTANCE = new MethodReferencesSearch();

    private MethodReferencesSearch() {
    }

    public static Query<PsiReference> search(PsiMethod method, SearchScope scope, boolean strictSignatureSearch) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(method, scope, strictSignatureSearch));
    }

    public static Query<PsiReference> search(PsiMethod method, boolean strictSignatureSearch) {
        return MethodReferencesSearch.search(method, GlobalSearchScope.allScope(method.getProject()), strictSignatureSearch);
    }

    public static Query<PsiReference> search(PsiMethod method) {
        return MethodReferencesSearch.search(method, true);
    }

    public static class SearchParameters {
        private final PsiMethod myMethod;
        private final SearchScope myScope;
        private final boolean myStrictSignatureSearch;

        public SearchParameters(PsiMethod aClass, SearchScope scope, boolean strict) {
            this.myMethod = aClass;
            this.myScope = scope;
            this.myStrictSignatureSearch = strict;
        }

        public PsiMethod getMethod() {
            return this.myMethod;
        }

        public boolean isStrictSignatureSearch() {
            return this.myStrictSignatureSearch;
        }

        public SearchScope getScope() {
            return this.myScope;
        }
    }
}

