/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.util.Query;
import com.intellij.util.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexPatternSearch
extends QueryFactory<IndexPatternOccurrence, SearchParameters> {
    public static IndexPatternSearch INDEX_PATTERN_SEARCH_INSTANCE;

    protected IndexPatternSearch() {
    }

    public static Query<IndexPatternOccurrence> search(PsiFile file, IndexPattern pattern) {
        SearchParameters parameters = new SearchParameters(file, pattern);
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static Query<IndexPatternOccurrence> search(PsiFile file, IndexPattern pattern, int startOffset, int endOffset) {
        SearchParameters parameters = new SearchParameters(file, pattern);
        parameters.setRange(new TextRange(startOffset, endOffset));
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static Query<IndexPatternOccurrence> search(PsiFile file, IndexPatternProvider patternProvider) {
        SearchParameters parameters = new SearchParameters(file, patternProvider);
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static Query<IndexPatternOccurrence> search(PsiFile file, IndexPatternProvider patternProvider, int startOffset, int endOffset) {
        SearchParameters parameters = new SearchParameters(file, patternProvider);
        parameters.setRange(new TextRange(startOffset, endOffset));
        return INDEX_PATTERN_SEARCH_INSTANCE.createQuery(parameters);
    }

    public static int getOccurrencesCount(PsiFile file, IndexPatternProvider patternProvider) {
        return INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, patternProvider);
    }

    public static int getOccurrencesCount(PsiFile file, IndexPattern pattern) {
        return INDEX_PATTERN_SEARCH_INSTANCE.getOccurrencesCountImpl(file, pattern);
    }

    protected abstract int getOccurrencesCountImpl(PsiFile var1, IndexPatternProvider var2);

    protected abstract int getOccurrencesCountImpl(PsiFile var1, IndexPattern var2);

    public static class SearchParameters {
        private PsiFile myFile;
        private IndexPattern myPattern;
        private IndexPatternProvider myPatternProvider;
        private TextRange myRange;

        public SearchParameters(PsiFile file, IndexPattern pattern) {
            this.myFile = file;
            this.myPattern = pattern;
        }

        public SearchParameters(PsiFile file, IndexPatternProvider patternProvider) {
            this.myFile = file;
            this.myPatternProvider = patternProvider;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        public IndexPattern getPattern() {
            return this.myPattern;
        }

        public IndexPatternProvider getPatternProvider() {
            return this.myPatternProvider;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public void setRange(TextRange range) {
            this.myRange = range;
        }
    }
}

