/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.SimpleSmartExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleQueryFactory<Result, Parameters>
extends QueryFactory<Result, Parameters> {
    private final NotNullLazyValue<SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>> myPoint = new NotNullLazyValue<SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        protected SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>> compute() {
            SimpleSmartExtensionPoint simpleSmartExtensionPoint = new SimpleSmartExtensionPoint<QueryExecutor<Result, Parameters>>(new SmartList()){

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                protected ExtensionPoint<QueryExecutor<Result, Parameters>> getExtensionPoint() {
                    String epName = ExtensibleQueryFactory.this.getClass().getName();
                    int pos = epName.lastIndexOf(46);
                    if (pos >= 0) {
                        epName = epName.substring(pos + 1);
                    }
                    epName = "com.intellij." + StringUtil.decapitalize(epName);
                    ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(epName);
                    if (extensionPoint == null) {
                        throw new IllegalStateException("@NotNull method com/intellij/psi/search/searches/ExtensibleQueryFactory$1$1.getExtensionPoint must not return null");
                    }
                    return extensionPoint;
                }
            };
            if (simpleSmartExtensionPoint == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/searches/ExtensibleQueryFactory$1.compute must not return null");
            }
            return simpleSmartExtensionPoint;
        }
    };

    public void registerExecutor(final QueryExecutor<Result, Parameters> queryExecutor, Disposable parentDisposable) {
        this.registerExecutor(queryExecutor);
        Disposer.register(parentDisposable, new Disposable(){

            public void dispose() {
                ExtensibleQueryFactory.this.unregisterExecutor(queryExecutor);
            }
        });
    }

    @Override
    public void registerExecutor(QueryExecutor<Result, Parameters> queryExecutor) {
        this.myPoint.getValue().addExplicitExtension(queryExecutor);
    }

    @Override
    public void unregisterExecutor(QueryExecutor<Result, Parameters> queryExecutor) {
        this.myPoint.getValue().removeExplicitExtension(queryExecutor);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected List<QueryExecutor<Result, Parameters>> getExecutors() {
        List list = this.myPoint.getValue().getExtensions();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/searches/ExtensibleQueryFactory.getExecutors must not return null");
        }
        return list;
    }
}

