/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.Stack;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.search.searches.ClassInheritorsSearch");
    public static ClassInheritorsSearch INSTANCE = new ClassInheritorsSearch();

    private ClassInheritorsSearch() {
    }

    public static Query<PsiClass> search(PsiClass aClass, SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(aClass, scope, checkDeep, checkInheritance, includeAnonymous));
    }

    public static Query<PsiClass> search(PsiClass aClass, SearchScope scope, boolean checkDeep, boolean checkInheritance) {
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, checkInheritance, true);
    }

    public static Query<PsiClass> search(PsiClass aClass, SearchScope scope, boolean checkDeep) {
        return ClassInheritorsSearch.search(aClass, scope, checkDeep, true);
    }

    public static Query<PsiClass> search(PsiClass aClass, boolean checkDeep) {
        return ClassInheritorsSearch.search(aClass, aClass.getUseScope(), checkDeep);
    }

    public static Query<PsiClass> search(PsiClass aClass) {
        return ClassInheritorsSearch.search(aClass, true);
    }

    private static boolean processInheritors(final Processor<PsiClass> consumer, PsiClass baseClass, final SearchScope searchScope, final boolean checkDeep, final boolean checkInheritance, boolean includeAnonymous) {
        LOG.assertTrue(searchScope != null);
        if (baseClass instanceof PsiAnonymousClass) {
            return true;
        }
        if (ClassInheritorsSearch.isFinal(baseClass)) {
            return true;
        }
        final Ref<Object> currentBase = Ref.create(null);
        final Stack<PsiClass> stack = new Stack<PsiClass>();
        HashSet<PsiClass> processed = new HashSet<PsiClass>();
        Processor<PsiClass> processor = new Processor<PsiClass>(){

            @Override
            public boolean process(final PsiClass candidate) {
                final Ref result = new Ref();
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    public void run() {
                        if ((checkInheritance || checkDeep && !(candidate instanceof PsiAnonymousClass)) && !candidate.isInheritor((PsiClass)currentBase.get(), false)) {
                            result.set(true);
                            return;
                        }
                        if (PsiSearchScopeUtil.isInScope(searchScope, candidate)) {
                            if (candidate instanceof PsiAnonymousClass) {
                                result.set(consumer.process(candidate));
                            } else if (!consumer.process(candidate)) {
                                result.set(false);
                            }
                        }
                    }
                });
                if (!result.isNull()) {
                    return (Boolean)result.get();
                }
                if (checkDeep && !(candidate instanceof PsiAnonymousClass) && !ClassInheritorsSearch.isFinal(candidate)) {
                    stack.push(candidate);
                }
                return true;
            }
        };
        stack.push(baseClass);
        GlobalSearchScope scope = GlobalSearchScope.allScope(baseClass.getProject());
        while (!stack.isEmpty()) {
            PsiClass psiClass = (PsiClass)stack.pop();
            if (processed.contains(psiClass)) continue;
            processed.add(psiClass);
            currentBase.set(psiClass);
            if (DirectClassInheritorsSearch.search(psiClass, scope, includeAnonymous).forEach(processor)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFinal(final PsiClass baseClass) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return baseClass.hasModifierProperty("final");
            }
        });
    }

    static {
        INSTANCE.registerExecutor(new QueryExecutor<PsiClass, SearchParameters>(){

            @Override
            public boolean execute(SearchParameters p, Processor<PsiClass> consumer) {
                PsiClass baseClass = p.getClassToProcess();
                SearchScope searchScope = p.getScope();
                LOG.assertTrue(searchScope != null);
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress != null) {
                    progress.pushState();
                    String className = baseClass.getName();
                    progress.setText(className != null ? PsiBundle.message("psi.search.inheritors.of.class.progress", className) : PsiBundle.message("psi.search.inheritors.progress", new Object[0]));
                }
                boolean result = ClassInheritorsSearch.processInheritors(consumer, baseClass, searchScope, p.isCheckDeep(), p.isCheckInheritance(), p.isIncludeAnonymous());
                if (progress != null) {
                    progress.popState();
                }
                return result;
            }
        });
    }

    public static class SearchParameters {
        private final PsiClass myClass;
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final boolean myCheckInheritance;
        private final boolean myIncludeAnonymous;

        public SearchParameters(PsiClass aClass, SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
            this.myClass = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myCheckInheritance = checkInheritance;
            this.myIncludeAnonymous = includeAnonymous;
        }

        public PsiClass getClassToProcess() {
            return this.myClass;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean isIncludeAnonymous() {
            return this.myIncludeAnonymous;
        }
    }
}

