/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PatternPackageSet
implements PackageSet {
    @NonNls
    public static final String SCOPE_TEST = "test";
    @NonNls
    public static final String SCOPE_SOURCE = "src";
    @NonNls
    public static final String SCOPE_LIBRARY = "lib";
    @NonNls
    public static final String SCOPE_FILE = "file";
    @NonNls
    public static final String SCOPE_PROBLEM = "problem";
    public static final String SCOPE_ANY = "";
    private Pattern myPattern;
    private Pattern myModulePattern;
    private String myAspectJSyntaxPattern;
    private String myPathPattern;
    private Pattern myFilePattern;
    private String myScope;
    private String myModulePatternText;
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.search.scope.packageSet.PatternPackageSet");

    public PatternPackageSet(@Nullable String aspectPattern, String scope, String modulePattern, @NonNls String filePattern) {
        this.myAspectJSyntaxPattern = aspectPattern;
        this.myPathPattern = filePattern;
        this.myScope = scope;
        this.myModulePatternText = modulePattern;
        this.myModulePattern = modulePattern == null || modulePattern.length() == 0 ? null : Pattern.compile(StringUtil.replace(modulePattern, "*", ".*"));
        Pattern pattern = this.myPattern = aspectPattern != null ? Pattern.compile(PatternPackageSet.convertToRegexp(aspectPattern, '.')) : null;
        if (filePattern != null) {
            this.myFilePattern = Pattern.compile(PatternPackageSet.convertToRegexp(filePattern, '/'));
        }
    }

    public boolean contains(PsiFile file, NamedScopesHolder holder) {
        Project project = file.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return this.matchesScope(file, fileIndex) && (this.myPattern == null || this.myPattern.matcher(PatternPackageSet.getPackageName(file, fileIndex)).matches());
    }

    private boolean matchesScope(PsiFile file, ProjectFileIndex fileIndex) {
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        boolean isSource = fileIndex.isInSourceContent(vFile);
        if (this.myScope == SCOPE_ANY) {
            return fileIndex.isInContent(vFile) && this.matchesModule(vFile, fileIndex);
        }
        if (this.myScope == SCOPE_SOURCE) {
            return isSource && !fileIndex.isInTestSourceContent(vFile) && this.matchesModule(vFile, fileIndex);
        }
        if (this.myScope == SCOPE_LIBRARY) {
            return fileIndex.isInLibraryClasses(vFile) || fileIndex.isInLibrarySource(vFile);
        }
        if (this.myScope == SCOPE_FILE) {
            return fileIndex.isInContent(vFile) && this.fileMatcher(vFile, fileIndex) && this.matchesModule(vFile, fileIndex);
        }
        if (this.myScope == SCOPE_TEST) {
            return isSource && fileIndex.isInTestSourceContent(vFile) && this.matchesModule(vFile, fileIndex);
        }
        if (this.myScope == SCOPE_PROBLEM) {
            return isSource && WolfTheProblemSolver.getInstance(file.getProject()).isProblemFile(vFile) && this.matchesModule(vFile, fileIndex);
        }
        throw new RuntimeException("Unknown scope: " + this.myScope);
    }

    private boolean fileMatcher(VirtualFile virtualFile, ProjectFileIndex fileIndex) {
        if (this.myModulePattern != null) {
            VirtualFile contentRoot = fileIndex.getContentRootForFile(virtualFile);
            return this.myFilePattern.matcher(VfsUtil.getRelativePath(virtualFile, contentRoot, '/')).matches();
        }
        return this.myFilePattern.matcher(PatternPackageSet.getRelativePath(virtualFile, fileIndex, true)).matches();
    }

    private boolean matchesModule(VirtualFile file, ProjectFileIndex fileIndex) {
        if (this.myModulePattern == null) {
            return true;
        }
        Module module = fileIndex.getModuleForFile(file);
        LOG.assertTrue(module != null);
        if (this.myModulePattern.matcher(module.getName()).matches()) {
            return true;
        }
        String[] groupPath = ModuleManager.getInstance(module.getProject()).getModuleGroupPath(module);
        if (groupPath != null) {
            for (String node : groupPath) {
                if (!this.myModulePattern.matcher(node).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static String getPackageName(PsiFile file, ProjectFileIndex fileIndex) {
        VirtualFile vFile = file.getVirtualFile();
        if (fileIndex.isInLibrarySource(vFile)) {
            return fileIndex.getPackageNameByDirectory(vFile.getParent()) + "." + file.getVirtualFile().getNameWithoutExtension();
        }
        if (file instanceof PsiJavaFile) {
            return ((PsiJavaFile)file).getPackageName() + "." + file.getVirtualFile().getNameWithoutExtension();
        }
        PsiDirectory dir = file.getContainingDirectory();
        PsiPackage aPackage = dir.getPackage();
        return aPackage == null ? file.getName() : aPackage.getQualifiedName() + "." + file.getVirtualFile().getNameWithoutExtension();
    }

    public static String convertToRegexp(String aspectsntx, char separator) {
        StringBuffer buf = new StringBuffer(aspectsntx.length());
        boolean isAfterSeparator = false;
        boolean isAfterAsterix = false;
        for (int cur = 0; cur < aspectsntx.length(); ++cur) {
            char curChar = aspectsntx.charAt(cur);
            if (curChar != separator && isAfterSeparator) {
                buf.append("\\" + separator);
                isAfterSeparator = false;
            }
            if (curChar != '*' && isAfterAsterix) {
                buf.append(".*");
                isAfterAsterix = false;
            }
            if (curChar == '*') {
                if (!isAfterAsterix) {
                    isAfterAsterix = true;
                    continue;
                }
                buf.append("[^\\" + separator + "]*");
                isAfterAsterix = false;
                continue;
            }
            if (curChar == separator) {
                if (isAfterSeparator) {
                    buf.append("\\" + separator + "(.*\\" + separator + ")?");
                    isAfterSeparator = false;
                    continue;
                }
                isAfterSeparator = true;
                continue;
            }
            buf.append(curChar);
        }
        if (isAfterAsterix) {
            buf.append("[^\\" + separator + "]*");
        }
        return buf.toString();
    }

    public PackageSet createCopy() {
        return new PatternPackageSet(this.myAspectJSyntaxPattern, this.myScope, this.myModulePatternText, this.myPathPattern);
    }

    public int getNodePriority() {
        return 0;
    }

    public String getText() {
        StringBuffer buf = new StringBuffer();
        if (this.myScope != SCOPE_ANY) {
            buf.append(this.myScope);
        }
        if (this.myModulePattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myAspectJSyntaxPattern != null ? this.myAspectJSyntaxPattern : this.myPathPattern);
        return buf.toString();
    }

    public static String getRelativePath(VirtualFile virtualFile, ProjectFileIndex index, boolean useFQName) {
        Module module = index.getModuleForFile(virtualFile);
        if (module != null) {
            VirtualFile projectParent = module.getProject().getBaseDir();
            if (projectParent != null && VfsUtil.isAncestor(projectParent, virtualFile, false)) {
                String projectRelativePath = VfsUtil.getRelativePath(virtualFile, projectParent, '/');
                return useFQName ? projectRelativePath : projectRelativePath.substring(projectRelativePath.indexOf(47) + 1);
            }
            return virtualFile.getPath();
        }
        VirtualFile contentRootForFile = index.getContentRootForFile(virtualFile);
        if (contentRootForFile != null) {
            return VfsUtil.getRelativePath(virtualFile, contentRootForFile, '/');
        }
        return PatternPackageSet.getLibRelativePath(virtualFile, index);
    }

    public static String getLibRelativePath(VirtualFile virtualFile, ProjectFileIndex index) {
        StringBuilder relativePath = new StringBuilder(100);
        for (VirtualFile directory = virtualFile; directory != null && index.isInLibraryClasses(directory); directory = directory.getParent()) {
            relativePath.insert(0, '/');
            relativePath.insert(0, directory.getName());
        }
        return relativePath.toString();
    }
}

