/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamedScopesHolder
implements JDOMExternalizable {
    private List<NamedScope> myScopes = new ArrayList<NamedScope>();
    @NonNls
    private static final String SCOPE_TAG = "scope";
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String PATTERN_ATT = "pattern";
    private List<ScopeListener> myScopeListeners;

    public abstract String getDisplayName();

    public abstract Icon getIcon();

    public synchronized void addScopeListener(ScopeListener scopeListener) {
        if (this.myScopeListeners == null) {
            this.myScopeListeners = new ArrayList<ScopeListener>();
        }
        this.myScopeListeners.add(scopeListener);
    }

    public synchronized void removeScopeListener(ScopeListener scopeListener) {
        this.myScopeListeners.remove(scopeListener);
    }

    public synchronized void fireScopeListeners() {
        if (this.myScopeListeners != null) {
            for (ScopeListener listener : this.myScopeListeners) {
                listener.scopesChanged();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public NamedScope[] getScopes() {
        ArrayList<NamedScope> scopes = new ArrayList<NamedScope>();
        List<NamedScope> list = this.getPredefinedScopes();
        scopes.addAll(list);
        scopes.addAll(this.myScopes);
        NamedScope[] namedScopeArray = scopes.toArray(new NamedScope[scopes.size()]);
        if (namedScopeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/scope/packageSet/NamedScopesHolder.getScopes must not return null");
        }
        return namedScopeArray;
    }

    public NamedScope[] getEditableScopes() {
        return this.myScopes.toArray(new NamedScope[this.myScopes.size()]);
    }

    public void removeAllSets() {
        this.myScopes.clear();
        this.fireScopeListeners();
    }

    public void setScopes(NamedScope[] scopes) {
        this.myScopes = new ArrayList<NamedScope>(Arrays.asList(scopes));
        this.fireScopeListeners();
    }

    public void addScope(NamedScope scope) {
        this.myScopes.add(scope);
        this.fireScopeListeners();
    }

    @Nullable
    public static NamedScope getScope(Project project, String scopeName) {
        NamedScopesHolder[] holders;
        for (NamedScopesHolder holder : holders = project.getComponents(NamedScopesHolder.class)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return scope;
        }
        return null;
    }

    @Nullable
    public static NamedScopesHolder getHolder(Project project, String scopeName, NamedScopesHolder defaultHolder) {
        NamedScopesHolder[] holders;
        for (NamedScopesHolder holder : holders = project.getComponents(NamedScopesHolder.class)) {
            NamedScope scope = holder.getScope(scopeName);
            if (scope == null) continue;
            return holder;
        }
        return defaultHolder;
    }

    private static Element writeScope(NamedScope scope) {
        Element setElement = new Element(SCOPE_TAG);
        setElement.setAttribute(NAME_ATT, scope.getName());
        PackageSet packageSet = scope.getValue();
        setElement.setAttribute(PATTERN_ATT, packageSet != null ? packageSet.getText() : "");
        return setElement;
    }

    private static NamedScope readScope(Element setElement) {
        String name = setElement.getAttributeValue(NAME_ATT);
        PackageSet set = null;
        try {
            set = PackageSetFactory.getInstance().compile(setElement.getAttributeValue(PATTERN_ATT));
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        return new NamedScope(name, set);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        List sets = element.getChildren(SCOPE_TAG);
        for (Object set : sets) {
            this.addScope(NamedScopesHolder.readScope((Element)set));
        }
        this.fireScopeListeners();
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        for (NamedScope myScope : this.myScopes) {
            element.addContent(NamedScopesHolder.writeScope(myScope));
        }
    }

    @Nullable
    public NamedScope getScope(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (NamedScope scope : this.myScopes) {
            if (!name.equals(scope.getName())) continue;
            return scope;
        }
        List<NamedScope> predefinedScopes = this.getPredefinedScopes();
        for (NamedScope scope : predefinedScopes) {
            if (!name.equals(scope.getName())) continue;
            return scope;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<NamedScope> getPredefinedScopes() {
        List<NamedScope> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/scope/packageSet/NamedScopesHolder.getPredefinedScopes must not return null");
        }
        return list;
    }

    public static interface ScopeListener {
        public void scopesChanged();
    }
}

