/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;

public class NamedPackageSetReference
implements PackageSet {
    private String myName;

    public NamedPackageSetReference(String name) {
        this.myName = name.startsWith("$") ? name.substring(1) : name;
    }

    public boolean contains(PsiFile file, NamedScopesHolder holder) {
        NamedScope scope = holder.getScope(this.myName);
        if (scope != null) {
            PackageSet packageSet = scope.getValue();
            return packageSet != null && packageSet.contains(file, holder);
        }
        return false;
    }

    public PackageSet createCopy() {
        return new NamedPackageSetReference(this.myName);
    }

    public String getText() {
        return "$" + this.myName;
    }

    public int getNodePriority() {
        return 0;
    }
}

