/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;

public class IntersectionPackageSet
implements PackageSet {
    private PackageSet myFirstSet;
    private PackageSet mySecondSet;

    public IntersectionPackageSet(PackageSet firstSet, PackageSet secondSet) {
        this.myFirstSet = firstSet;
        this.mySecondSet = secondSet;
    }

    public boolean contains(PsiFile file, NamedScopesHolder holder) {
        return this.myFirstSet.contains(file, holder) && this.mySecondSet.contains(file, holder);
    }

    public PackageSet createCopy() {
        return new IntersectionPackageSet(this.myFirstSet.createCopy(), this.mySecondSet.createCopy());
    }

    public int getNodePriority() {
        return 2;
    }

    public String getText() {
        boolean needParen;
        StringBuffer buf = new StringBuffer();
        boolean bl = needParen = this.myFirstSet.getNodePriority() > this.getNodePriority();
        if (needParen) {
            buf.append('(');
        }
        buf.append(this.myFirstSet.getText());
        if (needParen) {
            buf.append(')');
        }
        buf.append("&&");
        boolean bl2 = needParen = this.mySecondSet.getNodePriority() > this.getNodePriority();
        if (needParen) {
            buf.append('(');
        }
        buf.append(this.mySecondSet.getText());
        if (needParen) {
            buf.append(')');
        }
        return buf.toString();
    }
}

