/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.awt.Color;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class TodoAttributes
implements JDOMExternalizable,
Cloneable {
    public static final Icon DEFAULT_ICON = IconLoader.getIcon("/general/todoDefault.png");
    public static final Icon QUESTION_ICON = IconLoader.getIcon("/general/todoQuestion.png");
    public static final Icon IMPORTANT_ICON = IconLoader.getIcon("/general/todoImportant.png");
    private Icon myIcon;
    private TextAttributes myTextAttributes = new TextAttributes();
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    @NonNls
    private static final String ICON_DEFAULT = "default";
    @NonNls
    private static final String ICON_QUESTION = "question";
    @NonNls
    private static final String ICON_IMPORTANT = "important";
    @NonNls
    private static final String ELEMENT_OPTION = "option";

    public TodoAttributes() {
    }

    private TodoAttributes(Icon icon, TextAttributes textAttributes) {
        this.myIcon = icon;
        this.myTextAttributes = textAttributes;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public TextAttributes getTextAttributes() {
        return this.myTextAttributes;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public static TodoAttributes createDefault() {
        TextAttributes textAttributes = TodoAttributes.createDefaultTextAttributes();
        return new TodoAttributes(DEFAULT_ICON, textAttributes);
    }

    private static TextAttributes createDefaultTextAttributes() {
        TextAttributes textAttributes = new TextAttributes(Color.blue, null, null, null, 3);
        textAttributes.setErrorStripeColor(Color.blue);
        return textAttributes;
    }

    public void readExternal(Element element) throws InvalidDataException {
        String icon = element.getAttributeValue(ATTRIBUTE_ICON, ICON_DEFAULT);
        if (ICON_DEFAULT.equals(icon)) {
            this.myIcon = DEFAULT_ICON;
        } else if (ICON_QUESTION.equals(icon)) {
            this.myIcon = QUESTION_ICON;
        } else if (ICON_IMPORTANT.equals(icon)) {
            this.myIcon = IMPORTANT_ICON;
        } else {
            throw new InvalidDataException(icon);
        }
        this.myTextAttributes.readExternal(element);
        if (element.getChild(ELEMENT_OPTION) == null) {
            this.myTextAttributes = TodoAttributes.createDefaultTextAttributes();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        String icon;
        if (this.myIcon == DEFAULT_ICON) {
            icon = ICON_DEFAULT;
        } else if (this.myIcon == QUESTION_ICON) {
            icon = ICON_QUESTION;
        } else if (this.myIcon == IMPORTANT_ICON) {
            icon = ICON_IMPORTANT;
        } else {
            throw new WriteExternalException("");
        }
        element.setAttribute(ATTRIBUTE_ICON, icon);
        this.myTextAttributes.writeExternal(element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TodoAttributes)) {
            return false;
        }
        TodoAttributes attributes = (TodoAttributes)o;
        if (this.myIcon != attributes.myIcon) {
            return false;
        }
        return !(this.myTextAttributes != null ? !this.myTextAttributes.equals(attributes.myTextAttributes) : attributes.myTextAttributes != null);
    }

    public int hashCode() {
        int result = this.myIcon != null ? this.myIcon.hashCode() : 0;
        result = 29 * result + (this.myTextAttributes != null ? this.myTextAttributes.hashCode() : 0);
        return result;
    }

    public TodoAttributes clone() {
        try {
            TextAttributes textAttributes = this.myTextAttributes.clone();
            TodoAttributes attributes = (TodoAttributes)super.clone();
            attributes.myTextAttributes = textAttributes;
            return attributes;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

