/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class SearchScope {
    private static int hashcode_counter = 0;
    private final int _hashcode = hashcode_counter++;

    public int hashCode() {
        return this._hashcode;
    }

    public String getDisplayName() {
        return PsiBundle.message("psi.search.scope.unknown", new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/SearchScope.intersectWith must not be null");
        }
        SearchScope searchScope = SearchScope.intersection(this, scope);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/SearchScope.intersectWith must not return null");
        }
        return searchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static SearchScope intersection(SearchScope scope1, SearchScope scope2) {
        SearchScope searchScope;
        if (scope1 instanceof LocalSearchScope) {
            if (!(scope2 instanceof LocalSearchScope ? (searchScope = ((LocalSearchScope)scope1).intersectWith((LocalSearchScope)scope2)) != null : (searchScope = SearchScope.intersection(scope2, scope1)) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/search/SearchScope.intersection must not return null");
            return searchScope;
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope _scope2 = (LocalSearchScope)scope2;
            PsiElement[] elements2 = _scope2.getScope();
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            for (PsiElement element2 : elements2) {
                if (!PsiSearchScopeUtil.isInScope(scope1, element2)) continue;
                result.add(element2);
            }
            searchScope = new LocalSearchScope(result.toArray(new PsiElement[result.size()]), null, _scope2.isIgnoreInjectedPsi());
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/SearchScope.intersection must not return null");
            return searchScope;
        }
        searchScope = ((GlobalSearchScope)scope1).intersectWith((GlobalSearchScope)scope2);
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/SearchScope.intersection must not return null");
    }
}

