/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class PsiSearchScopeUtil {
    public static SearchScope scopesUnion(SearchScope scope1, SearchScope scope2) {
        if (scope1 instanceof LocalSearchScope) {
            LocalSearchScope _scope1 = (LocalSearchScope)scope1;
            if (scope2 instanceof LocalSearchScope) {
                LocalSearchScope _scope2 = (LocalSearchScope)scope2;
                return _scope1.union(_scope2);
            }
            for (PsiElement element : _scope1.getScope()) {
                if (!PsiSearchScopeUtil.isInScope(scope2, element)) continue;
                return scope2;
            }
            return null;
        }
        if (scope2 instanceof LocalSearchScope) {
            return PsiSearchScopeUtil.scopesUnion(scope2, scope1);
        }
        final GlobalSearchScope _scope1 = (GlobalSearchScope)scope1;
        final GlobalSearchScope _scope2 = (GlobalSearchScope)scope2;
        return new GlobalSearchScope(){

            public boolean contains(VirtualFile file) {
                return _scope1.contains(file) || _scope2.contains(file);
            }

            public int compare(VirtualFile file1, VirtualFile file2) {
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiSearchScopeUtil$1.isSearchInModuleContent must not be null");
                }
                return _scope1.isSearchInModuleContent(aModule) || _scope2.isSearchInModuleContent(aModule);
            }

            public boolean isSearchInLibraries() {
                return _scope1.isSearchInLibraries() || _scope2.isSearchInLibraries();
            }
        };
    }

    public static boolean isInScope(SearchScope scope, PsiElement element) {
        if (scope instanceof LocalSearchScope) {
            PsiElement[] scopeElements;
            for (PsiElement scopeElement : scopeElements = ((LocalSearchScope)scope).getScope()) {
                if (!PsiTreeUtil.isAncestor(scopeElement, element, false)) continue;
                return true;
            }
            return false;
        }
        GlobalSearchScope _scope = (GlobalSearchScope)scope;
        PsiFile file = element.getContainingFile();
        if (file != null) {
            if (file.getVirtualFile() == null) {
                return true;
            }
            return _scope.contains(file.getVirtualFile());
        }
        return true;
    }
}

