/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class GlobalSearchScope
extends SearchScope {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.search.GlobalSearchScope");
    private static final String ALL_SCOPE_NAME = PsiBundle.message("psi.search.scope.project.and.libraries", new Object[0]);
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    public abstract boolean contains(VirtualFile var1);

    public abstract int compare(VirtualFile var1, VirtualFile var2);

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.isSearchInModuleContent must not be null");
        }
        return this.isSearchInModuleContent(aModule);
    }

    public abstract boolean isSearchInLibraries();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        GlobalSearchScope globalSearchScope;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.intersectWith must not be null");
        }
        if (ALL_SCOPE_NAME.equals(scope.getDisplayName())) {
            globalSearchScope = this;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
            return globalSearchScope;
        }
        globalSearchScope = GlobalSearchScope.intersection(this, scope);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
    }

    private static GlobalSearchScope intersection(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2) {
        if (scope1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.intersection must not be null");
        }
        if (scope2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.intersection must not be null");
        }
        return new IntersectionScope(scope1, scope2, null);
    }

    private static GlobalSearchScope union(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2) {
        if (scope1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.union must not be null");
        }
        if (scope2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.union must not be null");
        }
        return new UnionScope(scope1, scope2, null);
    }

    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.uniteWith must not be null");
        }
        if (ALL_SCOPE_NAME.equals(scope.getDisplayName())) {
            return scope;
        }
        return GlobalSearchScope.union(this, scope);
    }

    public static GlobalSearchScope allScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.allScope must not be null");
        }
        return project.getAllScope();
    }

    public static GlobalSearchScope projectScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.projectScope must not be null");
        }
        return project.getProjectScope();
    }

    public static GlobalSearchScope projectProductionScope(@NotNull Project project, boolean includeNonJavaFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.projectProductionScope must not be null");
        }
        return new IntersectionScope(GlobalSearchScope.projectScope(project), new ProductionScopeFilter(project, includeNonJavaFiles), PsiBundle.message("psi.search.scope.production.files", new Object[0]));
    }

    public static GlobalSearchScope projectTestScope(@NotNull Project project, boolean includeNonJavaFiles) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.projectTestScope must not be null");
        }
        return new IntersectionScope(GlobalSearchScope.projectScope(project), new TestScopeFilter(project, includeNonJavaFiles), PsiBundle.message("psi.search.scope.test.files", new Object[0]));
    }

    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.filterScope must not be null");
        }
        if (set == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.filterScope must not be null");
        }
        return new FilterScopeAdapter(project, set);
    }

    public static GlobalSearchScope notScope(final @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.notScope must not be null");
        }
        return new GlobalSearchScope(){

            public boolean contains(VirtualFile file) {
                return !scope.contains(file);
            }

            public int compare(VirtualFile file1, VirtualFile file2) {
                return scope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$1.isSearchInModuleContent must not be null");
                }
                return scope.isSearchInLibraries();
            }

            public boolean isSearchInLibraries() {
                return scope.isSearchInLibraries();
            }
        };
    }

    public static GlobalSearchScope moduleScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleScope must not be null");
        }
        return module.getModuleScope();
    }

    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithLibrariesScope must not be null");
        }
        return module.getModuleWithLibrariesScope();
    }

    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesScope must not be null");
        }
        return module.getModuleWithDependenciesScope();
    }

    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleRuntimeScope must not be null");
        }
        return module.getModuleRuntimeScope(includeTests);
    }

    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(Module module) {
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, true);
    }

    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesAndLibrariesScope must not be null");
        }
        return module.getModuleWithDependenciesAndLibrariesScope(includeTests);
    }

    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependentsScope must not be null");
        }
        return module.getModuleWithDependentsScope();
    }

    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleTestsWithDependentsScope must not be null");
        }
        return module.getModuleWithDependentsScope();
    }

    public static GlobalSearchScope packageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.packageScope must not be null");
        }
        return new PackageScope(aPackage, includeSubpackages, true);
    }

    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.directoryScope must not be null");
        }
        return new DirectoryScope(directory, withSubdirectories);
    }

    public static GlobalSearchScope packageScopeWithoutLibraries(@NotNull PsiPackage aPackage, boolean includeSubpackages) {
        if (aPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.packageScopeWithoutLibraries must not be null");
        }
        return new PackageScope(aPackage, includeSubpackages, false);
    }

    public static SearchScope fileScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.fileScope must not be null");
        }
        return new FileScope(psiFile);
    }

    public static GlobalSearchScope getScopeRestrictedByFileTypes(GlobalSearchScope scope, FileType ... fileTypes) {
        LOG.assertTrue(fileTypes.length > 0);
        return new FileTypeRestrictionScope(scope, fileTypes);
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        public boolean contains(VirtualFile file) {
            return false;
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$EmptyScope.isSearchInModuleContent must not be null");
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$EmptyScope.intersectWith must not be null");
            }
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$EmptyScope.intersectWith must not return null");
            }
            return emptyScope;
        }

        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$EmptyScope.uniteWith must not be null");
            }
            return scope;
        }
    }

    private static class FileTypeRestrictionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope;
        private final FileType[] myFileTypes;

        public FileTypeRestrictionScope(GlobalSearchScope scope, FileType[] fileTypes) {
            this.myFileTypes = fileTypes;
            this.myScope = scope;
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return this.myScope.compare(file1, file2);
        }

        public boolean contains(VirtualFile file) {
            if (!this.myScope.contains(file)) {
                return false;
            }
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(file);
            for (FileType otherFileType : this.myFileTypes) {
                if (!fileType.equals(otherFileType)) continue;
                return true;
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return this.myScope.isSearchInLibraries();
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope.isSearchInModuleContent(aModule);
        }
    }

    private static class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;
        private final Project myProject;

        public FilterScopeAdapter(Project project, NamedScope set) {
            this.mySet = set;
            this.myProject = project;
            this.myManager = PsiManager.getInstance(this.myProject);
        }

        public boolean contains(VirtualFile file) {
            PsiFile psiFile = this.myManager.findFile(file);
            if (psiFile == null) {
                return false;
            }
            NamedScopeManager holder = NamedScopeManager.getInstance(this.myProject);
            PackageSet packageSet = this.mySet.getValue();
            return packageSet != null && packageSet.contains(psiFile, holder);
        }

        public String getDisplayName() {
            return this.mySet.getName();
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FilterScopeAdapter.isSearchInModuleContent must not be null");
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }

    private static class FileScope
    extends GlobalSearchScope {
        private final VirtualFile myVirtualFile;
        private final Module myModule;

        public FileScope(PsiFile psiFile) {
            this.myVirtualFile = psiFile.getVirtualFile();
            Project project = psiFile.getProject();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
            this.myModule = this.myVirtualFile != null ? fileIndex.getModuleForFile(this.myVirtualFile) : null;
        }

        public boolean contains(VirtualFile file) {
            return Comparing.equal(this.myVirtualFile, file);
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileScope.isSearchInModuleContent must not be null");
            }
            return aModule == this.myModule;
        }

        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }
    }

    private static class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        public DirectoryScope(PsiDirectory directory, boolean withSubdirectories) {
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory.getVirtualFile();
        }

        public boolean contains(VirtualFile file) {
            if (this.myWithSubdirectories) {
                return VfsUtil.isAncestor(this.myDirectory, file, false);
            }
            return this.myDirectory.equals(file.getParent());
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$DirectoryScope.isSearchInModuleContent must not be null");
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }
    }

    private static class PackageScope
    extends GlobalSearchScope {
        private final Collection<VirtualFile> myDirs;
        private final PsiPackage myPackage;
        private final boolean myIncludeSubpackages;
        private final boolean myIncludeLibraries;

        public PackageScope(@NotNull PsiPackage aPackage, boolean includeSubpackages, boolean includeLibraries) {
            if (aPackage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$PackageScope.<init> must not be null");
            }
            this.myPackage = aPackage;
            this.myIncludeSubpackages = includeSubpackages;
            Project project = this.myPackage.getProject();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
            this.myDirs = fileIndex.getDirsByPackageName(this.myPackage.getQualifiedName(), true).findAll();
            this.myIncludeLibraries = includeLibraries;
        }

        public boolean contains(VirtualFile file) {
            for (VirtualFile scopeDir : this.myDirs) {
                boolean inDir = this.myIncludeSubpackages ? VfsUtil.isAncestor(scopeDir, file, false) : Comparing.equal(file.getParent(), scopeDir);
                if (!inDir) continue;
                return true;
            }
            return false;
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$PackageScope.isSearchInModuleContent must not be null");
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return this.myIncludeLibraries;
        }

        public String toString() {
            return "package scope: " + this.myPackage + ", includeSubpackages = " + this.myIncludeSubpackages;
        }
    }

    private static class TestScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;
        private final boolean myIncludeNonJavaFiles;

        public TestScopeFilter(Project project, boolean includeNonJavaFiles) {
            this.myIncludeNonJavaFiles = includeNonJavaFiles;
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        public boolean contains(VirtualFile file) {
            if (!this.myFileIndex.isJavaSourceFile(file)) {
                return this.myIncludeNonJavaFiles;
            }
            return this.myFileIndex.isInTestSourceContent(file);
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$TestScopeFilter.isSearchInModuleContent must not be null");
            }
            return true;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$TestScopeFilter.isSearchInModuleContent must not be null");
            }
            return testSources;
        }

        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private static class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;
        private final boolean myIncludeNonJavaFiles;

        public ProductionScopeFilter(Project project, boolean includeNonJavaFiles) {
            this.myIncludeNonJavaFiles = includeNonJavaFiles;
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        public boolean contains(VirtualFile file) {
            if (!this.myFileIndex.isJavaSourceFile(file)) {
                return this.myIncludeNonJavaFiles;
            }
            return this.myFileIndex.isInSourceContent(file) && !this.myFileIndex.isInTestSourceContent(file);
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$ProductionScopeFilter.isSearchInModuleContent must not be null");
            }
            return true;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$ProductionScopeFilter.isSearchInModuleContent must not be null");
            }
            return !testSources;
        }

        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private static class UnionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        public UnionScope(GlobalSearchScope scope1, GlobalSearchScope scope2, String displayName) {
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
            LOG.assertTrue(this.myScope1 != null);
            LOG.assertTrue(this.myScope2 != null);
        }

        public String getDisplayName() {
            if (this.myDisplayName == null) {
                return PsiBundle.message("psi.search.scope.union", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            }
            return this.myDisplayName;
        }

        public boolean contains(VirtualFile file) {
            return this.myScope1.contains(file) || this.myScope2.contains(file);
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            int res2;
            int res1 = this.myScope1.contains(file1) && this.myScope1.contains(file2) ? this.myScope1.compare(file1, file2) : 0;
            int n = res2 = this.myScope2.contains(file1) && this.myScope2.contains(file2) ? this.myScope2.compare(file1, file2) : 0;
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if ((res1 /= Math.abs(res1)) == (res2 /= Math.abs(res2))) {
                return res1;
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule) || this.myScope2.isSearchInModuleContent(aModule);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) || this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() || this.myScope2.isSearchInLibraries();
        }
    }

    private static class IntersectionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        public IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2, String displayName) {
            if (scope1 == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.<init> must not be null");
            }
            if (scope2 == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.<init> must not be null");
            }
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        public String getDisplayName() {
            if (this.myDisplayName == null) {
                return PsiBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            }
            return this.myDisplayName;
        }

        public boolean contains(VirtualFile file) {
            return this.myScope1.contains(file) && this.myScope2.contains(file);
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if ((res1 /= Math.abs(res1)) == (res2 /= Math.abs(res2))) {
                return res1;
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }
    }
}

