/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiUtil;

public class MethodCandidateInfo
extends CandidateInfo {
    private int myApplicabilityLevel = 0;
    private PsiExpressionList myArgumentList;
    private PsiType[] myTypeArguments;
    private PsiSubstitutor myCalcedSubstitutor = null;

    public MethodCandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiExpressionList argumentList, PsiElement currFileContext, PsiType[] typeArguments) {
        super(candidate, substitutor, accessProblem, staticsProblem, currFileContext);
        this.myArgumentList = argumentList;
        this.myTypeArguments = typeArguments;
    }

    public MethodCandidateInfo(PsiElement element, PsiSubstitutor substitutor) {
        super(element, substitutor, false, false);
        this.myApplicabilityLevel = 3;
        this.myArgumentList = null;
    }

    public boolean isApplicable() {
        if (this.myApplicabilityLevel == 0) {
            this.myApplicabilityLevel = this.getApplicabilityLevelInner();
        }
        return this.myApplicabilityLevel != 1;
    }

    private int getApplicabilityLevelInner() {
        int level = PsiUtil.getApplicabilityLevel(this.getElement(), this.getSubstitutor(), this.myArgumentList);
        if (level > 1 && !this.isTypeArgumentsApplicable()) {
            level = 1;
        }
        return level;
    }

    public int getApplicabilityLevel() {
        if (this.myApplicabilityLevel == 0) {
            this.myApplicabilityLevel = this.getApplicabilityLevelInner();
        }
        return this.myApplicabilityLevel;
    }

    public PsiSubstitutor getSubstitutor() {
        if (this.myCalcedSubstitutor == null) {
            PsiSubstitutor incompleteSubstitutor = super.getSubstitutor();
            PsiMethod method = this.getElement();
            if (this.myTypeArguments == null) {
                this.myCalcedSubstitutor = this.inferTypeArguments(false);
            } else {
                PsiTypeParameter[] typeParams = method.getTypeParameters();
                for (int i = 0; i < this.myTypeArguments.length && i < typeParams.length; ++i) {
                    incompleteSubstitutor = incompleteSubstitutor.put(typeParams[i], this.myTypeArguments[i]);
                }
                this.myCalcedSubstitutor = incompleteSubstitutor;
            }
        }
        return this.myCalcedSubstitutor;
    }

    public boolean isTypeArgumentsApplicable() {
        PsiTypeParameter[] typeParams = this.getElement().getTypeParameters();
        if (this.myTypeArguments != null && typeParams.length != this.myTypeArguments.length) {
            return false;
        }
        PsiSubstitutor substitutor = this.getSubstitutor();
        return GenericsUtil.isTypeArgumentsApplicable(typeParams, substitutor, this.myArgumentList.getParent());
    }

    public boolean isValidResult() {
        return super.isValidResult() && this.isApplicable();
    }

    public PsiMethod getElement() {
        return (PsiMethod)super.getElement();
    }

    public PsiSubstitutor inferTypeArguments(boolean forCompletion) {
        PsiClass containingClass;
        PsiMethod method = this.getElement();
        PsiSubstitutor partialSubstitutor = this.mySubstitutor;
        PsiExpression[] arguments = this.myArgumentList == null ? PsiExpression.EMPTY_ARRAY : this.myArgumentList.getExpressions();
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (!method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && PsiUtil.isRawSubstitutor(containingClass, partialSubstitutor)) {
            return MethodCandidateInfo.createRawSubstitutor(partialSubstitutor, typeParameters);
        }
        PsiResolveHelper helper = method.getManager().getResolveHelper();
        return helper.inferTypeArguments(typeParameters, method.getParameterList().getParameters(), arguments, partialSubstitutor, this.myArgumentList.getParent(), forCompletion);
    }

    private static PsiSubstitutor createRawSubstitutor(PsiSubstitutor substitutor, PsiTypeParameter[] typeParameters) {
        for (PsiTypeParameter typeParameter : typeParameters) {
            substitutor = substitutor.put(typeParameter, null);
        }
        return substitutor;
    }

    public static class ApplicabilityLevel {
        public static final int NOT_APPLICABLE = 1;
        public static final int VARARGS = 2;
        public static final int FIXED_ARITY = 3;
    }
}

