/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.infos;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiSubstitutor;

public class CandidateInfo
implements JavaResolveResult {
    public static final CandidateInfo[] EMPTY_ARRAY = new CandidateInfo[0];
    private final PsiElement myPlace;
    private final PsiClass myAccessClass;
    private final PsiElement myCandidate;
    private Boolean myAccessProblem = null;
    private final boolean myStaticsProblem;
    protected final PsiSubstitutor mySubstitutor;
    private final PsiElement myCurrentFileResolveContext;
    private boolean myPackagePrefixPackageReference;
    public static final JavaResolveResult[] RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE = new JavaResolveResult[]{CandidateInfo.createCandidateInfoForPackagePrefixPart()};

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem, PsiElement currFileContext) {
        this.myCandidate = candidate;
        this.myAccessProblem = accessProblem ? Boolean.TRUE : Boolean.FALSE;
        this.myStaticsProblem = staticsProblem;
        this.mySubstitutor = substitutor;
        this.myCurrentFileResolveContext = currFileContext;
        this.myAccessClass = null;
        this.myPlace = null;
    }

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, boolean accessProblem, boolean staticsProblem) {
        this(candidate, substitutor, accessProblem, staticsProblem, null);
    }

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, PsiElement place, boolean staticsProblem) {
        this(candidate, substitutor, place, null, staticsProblem, null);
    }

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor, PsiElement place, PsiClass accessClass, boolean staticsProblem, PsiElement currFileContext) {
        this.myStaticsProblem = staticsProblem;
        this.myAccessClass = accessClass;
        this.myPlace = place;
        this.mySubstitutor = substitutor;
        this.myCandidate = candidate;
        this.myCurrentFileResolveContext = currFileContext;
    }

    public CandidateInfo(PsiElement candidate, PsiSubstitutor substitutor) {
        this(candidate, substitutor, null, null, false, null);
    }

    public CandidateInfo(CandidateInfo candidate, PsiSubstitutor newSubstitutor) {
        this(candidate.myCandidate, newSubstitutor, candidate.myPlace, null, candidate.myStaticsProblem, candidate.myCurrentFileResolveContext);
        this.myAccessProblem = candidate.myAccessProblem;
    }

    public boolean isValidResult() {
        return this.isAccessible() && this.isStaticsScopeCorrect();
    }

    public boolean isPackagePrefixPackageReference() {
        return this.myPackagePrefixPackageReference;
    }

    public PsiElement getElement() {
        return this.myCandidate;
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public boolean isAccessible() {
        if (this.myAccessProblem == null) {
            boolean accessProblem = false;
            if (this.myPlace != null && this.myCandidate instanceof PsiMember) {
                PsiMember member = (PsiMember)this.myCandidate;
                accessProblem = !this.myPlace.getManager().getResolveHelper().isAccessible(member, member.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileResolveContext);
            }
            this.myAccessProblem = accessProblem ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.myAccessProblem == false;
    }

    public boolean isStaticsScopeCorrect() {
        return !this.myStaticsProblem;
    }

    public PsiElement getCurrentFileResolveScope() {
        return this.myCurrentFileResolveContext;
    }

    private void setPackagePrefixPackageReference(boolean packagePrefixPackageReference) {
        this.myPackagePrefixPackageReference = packagePrefixPackageReference;
    }

    public static CandidateInfo createCandidateInfoForPackagePrefixPart() {
        CandidateInfo candidateInfo = new CandidateInfo(null, PsiSubstitutor.EMPTY, false, false);
        candidateInfo.setPackagePrefixPackageReference(true);
        return candidateInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CandidateInfo that = (CandidateInfo)o;
        if (this.myPackagePrefixPackageReference != that.myPackagePrefixPackageReference) {
            return false;
        }
        if (this.myStaticsProblem != that.myStaticsProblem) {
            return false;
        }
        if (this.myAccessClass != null ? !this.myAccessClass.equals(that.myAccessClass) : that.myAccessClass != null) {
            return false;
        }
        if (this.myAccessProblem != null ? !this.myAccessProblem.equals(that.myAccessProblem) : that.myAccessProblem != null) {
            return false;
        }
        if (this.myCandidate != null ? !this.myCandidate.equals(that.myCandidate) : that.myCandidate != null) {
            return false;
        }
        if (this.myCurrentFileResolveContext != null ? !this.myCurrentFileResolveContext.equals(that.myCurrentFileResolveContext) : that.myCurrentFileResolveContext != null) {
            return false;
        }
        if (this.myPlace != null ? !this.myPlace.equals(that.myPlace) : that.myPlace != null) {
            return false;
        }
        return !(this.mySubstitutor != null ? !this.mySubstitutor.equals(that.mySubstitutor) : that.mySubstitutor != null);
    }

    public int hashCode() {
        int result = this.myPlace != null ? this.myPlace.hashCode() : 0;
        result = 31 * result + (this.myAccessClass != null ? this.myAccessClass.hashCode() : 0);
        result = 31 * result + (this.myCandidate != null ? this.myCandidate.hashCode() : 0);
        result = 31 * result + (this.myAccessProblem != null ? this.myAccessProblem.hashCode() : 0);
        result = 31 * result + (this.myStaticsProblem ? 1 : 0);
        result = 31 * result + (this.mySubstitutor != null ? this.mySubstitutor.hashCode() : 0);
        result = 31 * result + (this.myCurrentFileResolveContext != null ? this.myCurrentFileResolveContext.hashCode() : 0);
        result = 31 * result + (this.myPackagePrefixPackageReference ? 1 : 0);
        return result;
    }
}

