/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssRuleset;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class CssElementFactory {
    private PsiManager myManager;

    public CssElementFactory(PsiManager _manager) {
        this.myManager = _manager;
    }

    public static CssElementFactory getInstance(Project project) {
        return ServiceManager.getService(project, CssElementFactory.class);
    }

    @Nullable
    public CssRuleset createRuleset(String text) throws IncorrectOperationException {
        PsiFile fileFromText = this.myManager.getElementFactory().createFileFromText("_dummy_.css", text);
        if (fileFromText instanceof CssFile) {
            return ((CssFile)fileFromText).getStylesheet().getRulesets()[0];
        }
        return null;
    }

    @Nullable
    public CssDeclaration[] createProperties(String text) throws IncorrectOperationException {
        CssRuleset ruleset = this.createRuleset(".a {\n " + text + "\n}");
        if (ruleset != null) {
            return ruleset.getBlock().getDeclarations();
        }
        return null;
    }
}

