/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameUtil {
    private static final Function<String, String> LOWERCASE_MAPPING = new Function<String, String>(){

        @Override
        public String fun(String s) {
            return s.toLowerCase();
        }
    };

    private NameUtil() {
    }

    public static List<String> nameToWordsLowerCase(String name) {
        return ContainerUtil.map(NameUtil.nameToWords(name), LOWERCASE_MAPPING);
    }

    public static String[] nameToWords(String name) {
        ArrayList<String> array = new ArrayList<String>();
        int index = 0;
        while (index < name.length()) {
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            String word = name.substring(wordStart, index);
            array.add(word);
        }
        return array.toArray(new String[array.size()]);
    }

    private static boolean containsOnlyUppercaseLetters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '*' || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }

    public static String buildRegexp(String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        int eol = pattern.indexOf(10);
        if (eol != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 80) {
            pattern = pattern.substring(0, 80);
        }
        StringBuffer buffer = new StringBuffer();
        boolean lastIsUppercase = false;
        boolean endsWithSpace = StringUtil.endsWithChar(pattern, ' ');
        boolean uppercaseOnly = NameUtil.containsOnlyUppercaseLetters((pattern = pattern.trim()).substring(exactPrefixLen = Math.min(exactPrefixLen, pattern.length())));
        if (uppercaseOnly) {
            allowToLower = false;
        }
        for (int i = 0; i != exactPrefixLen; ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\x");
            buffer.append(Integer.toHexString(c + 131072).substring(3));
        }
        boolean firstIdentifierLetter = exactPrefixLen == 0;
        for (int i = exactPrefixLen; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            lastIsUppercase = false;
            if (Character.isLetterOrDigit(c)) {
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    buffer.append('(');
                    if (!firstIdentifierLetter) {
                        buffer.append("[a-z0-9\\$]*");
                    }
                    buffer.append(c);
                    if (allowToLower || i == exactPrefixLen) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    if (!firstIdentifierLetter) {
                        buffer.append("|([A-Za-z0-9\\$]*(_|-)(");
                        buffer.append(c);
                        buffer.append("|");
                        buffer.append(Character.toLowerCase(c));
                        buffer.append("))");
                    }
                    buffer.append(')');
                    lastIsUppercase = true;
                } else if (Character.isLowerCase(c) && allowToUpper) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append('|');
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                if (!firstIdentifierLetter) {
                    buffer.append("[a-z0-9\\$]*\\.");
                } else {
                    buffer.append("\\.");
                }
                firstIdentifierLetter = true;
                continue;
            }
            firstIdentifierLetter = true;
            buffer.append("\\x");
            buffer.append(Integer.toHexString(c + 131072).substring(3));
        }
        if (!endsWithSpace) {
            buffer.append(".*");
        } else if (lastIsUppercase) {
            buffer.append("[a-z0-9\\$]*");
        }
        return buffer.toString();
    }
}

