/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CustomCodeStyleSettings
implements Cloneable {
    private final CodeStyleSettings myContainer;
    private final String myTagName;

    protected CustomCodeStyleSettings(@NonNls @NotNull String tagName, CodeStyleSettings container) {
        if (tagName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/codeStyle/CustomCodeStyleSettings.<init> must not be null");
        }
        this.myTagName = tagName;
        this.myContainer = container;
    }

    public final CodeStyleSettings getContainer() {
        return this.myContainer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNls
    @NotNull
    public final String getTagName() {
        String string = this.myTagName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/codeStyle/CustomCodeStyleSettings.getTagName must not return null");
        }
        return string;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, parentElement.getChild(this.myTagName));
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/codeStyle/CustomCodeStyleSettings.writeExternal must not be null");
        }
        Element childElement = new Element(this.myTagName);
        DefaultJDOMExternalizer.writeExternal(this, childElement, new DifferenceFilter<CustomCodeStyleSettings>(this, parentSettings));
        if (!childElement.getContent().isEmpty()) {
            parentElement.addContent(childElement);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

