/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.FileTypeIndentOptionsProvider;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ClassMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeStyleSettings
implements Cloneable,
JDOMExternalizable {
    private ClassMap<CustomCodeStyleSettings> myCustomSettings = new ClassMap();
    @NonNls
    private static final String ADDITIONAL_INDENT_OPTIONS = "ADDITIONAL_INDENT_OPTIONS";
    @NonNls
    private static final String FILETYPE = "fileType";
    public boolean LINE_COMMENT_AT_FIRST_COLUMN = true;
    public boolean BLOCK_COMMENT_AT_FIRST_COLUMN = true;
    public boolean KEEP_LINE_BREAKS = true;
    public boolean KEEP_FIRST_COLUMN_COMMENT = true;
    public boolean INSERT_FIRST_SPACE_IN_LINE = true;
    public boolean USE_SAME_INDENTS = true;
    public IndentOptions JAVA_INDENT_OPTIONS = new IndentOptions();
    public IndentOptions JSP_INDENT_OPTIONS = new IndentOptions();
    public IndentOptions XML_INDENT_OPTIONS = new IndentOptions();
    public IndentOptions OTHER_INDENT_OPTIONS = new IndentOptions();
    private Map<FileType, IndentOptions> ourAdditionalIndentOptions = new LinkedHashMap<FileType, IndentOptions>();
    private static final String ourSystemLineSeparator = SystemProperties.getLineSeparator();
    public String LINE_SEPARATOR;
    public boolean KEEP_CONTROL_STATEMENT_IN_ONE_LINE = true;
    public static final int END_OF_LINE = 1;
    public static final int NEXT_LINE = 2;
    public static final int NEXT_LINE_SHIFTED = 3;
    public static final int NEXT_LINE_SHIFTED2 = 4;
    public static final int NEXT_LINE_IF_WRAPPED = 5;
    public int BRACE_STYLE = 1;
    public int CLASS_BRACE_STYLE = 1;
    public int METHOD_BRACE_STYLE = 1;
    public boolean DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = false;
    public boolean ELSE_ON_NEW_LINE = false;
    public boolean WHILE_ON_NEW_LINE = false;
    public boolean CATCH_ON_NEW_LINE = false;
    public boolean FINALLY_ON_NEW_LINE = false;
    public boolean INDENT_CASE_FROM_SWITCH = true;
    public boolean SPECIAL_ELSE_IF_TREATMENT = true;
    public boolean ALIGN_MULTILINE_PARAMETERS = true;
    public boolean ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
    public boolean ALIGN_MULTILINE_FOR = true;
    public boolean ALIGN_MULTILINE_BINARY_OPERATION = false;
    public boolean ALIGN_MULTILINE_ASSIGNMENT = false;
    public boolean ALIGN_MULTILINE_TERNARY_OPERATION = false;
    public boolean ALIGN_MULTILINE_THROWS_LIST = false;
    public boolean ALIGN_MULTILINE_EXTENDS_LIST = false;
    public boolean ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION = false;
    public boolean ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = false;
    public boolean ALIGN_GROUP_FIELD_DECLARATIONS = false;
    public int KEEP_BLANK_LINES_IN_DECLARATIONS = 2;
    public int KEEP_BLANK_LINES_IN_CODE = 2;
    public int KEEP_BLANK_LINES_BEFORE_RBRACE = 2;
    public int BLANK_LINES_BEFORE_PACKAGE = 0;
    public int BLANK_LINES_AFTER_PACKAGE = 1;
    public int BLANK_LINES_BEFORE_IMPORTS = 1;
    public int BLANK_LINES_AFTER_IMPORTS = 1;
    public int BLANK_LINES_AROUND_CLASS = 1;
    public int BLANK_LINES_AROUND_FIELD = 0;
    public int BLANK_LINES_AROUND_METHOD = 1;
    public int BLANK_LINES_AFTER_CLASS_HEADER = 0;
    public boolean SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
    public boolean SPACE_AROUND_LOGICAL_OPERATORS = true;
    public boolean SPACE_AROUND_EQUALITY_OPERATORS = true;
    public boolean SPACE_AROUND_RELATIONAL_OPERATORS = true;
    public boolean SPACE_AROUND_BITWISE_OPERATORS = true;
    public boolean SPACE_AROUND_ADDITIVE_OPERATORS = true;
    public boolean SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
    public boolean SPACE_AROUND_SHIFT_OPERATORS = true;
    public boolean SPACE_AFTER_COMMA = true;
    public boolean SPACE_BEFORE_COMMA = false;
    public boolean SPACE_AFTER_SEMICOLON = true;
    public boolean SPACE_BEFORE_SEMICOLON = false;
    public boolean SPACE_WITHIN_PARENTHESES = false;
    public boolean SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
    public boolean SPACE_WITHIN_METHOD_PARENTHESES = false;
    public boolean SPACE_WITHIN_IF_PARENTHESES = false;
    public boolean SPACE_WITHIN_WHILE_PARENTHESES = false;
    public boolean SPACE_WITHIN_FOR_PARENTHESES = false;
    public boolean SPACE_WITHIN_CATCH_PARENTHESES = false;
    public boolean SPACE_WITHIN_SWITCH_PARENTHESES = false;
    public boolean SPACE_WITHIN_SYNCHRONIZED_PARENTHESES = false;
    public boolean SPACE_WITHIN_CAST_PARENTHESES = false;
    public boolean SPACE_WITHIN_BRACKETS = false;
    public boolean SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
    public boolean SPACE_AFTER_TYPE_CAST = true;
    public boolean SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
    public boolean SPACE_BEFORE_METHOD_PARENTHESES = false;
    public boolean SPACE_BEFORE_IF_PARENTHESES = true;
    public boolean SPACE_BEFORE_WHILE_PARENTHESES = true;
    public boolean SPACE_BEFORE_FOR_PARENTHESES = true;
    public boolean SPACE_BEFORE_CATCH_PARENTHESES = true;
    public boolean SPACE_BEFORE_SWITCH_PARENTHESES = true;
    public boolean SPACE_BEFORE_SYNCHRONIZED_PARENTHESES = true;
    public boolean SPACE_BEFORE_CLASS_LBRACE = true;
    public boolean SPACE_BEFORE_METHOD_LBRACE = true;
    public boolean SPACE_BEFORE_IF_LBRACE = true;
    public boolean SPACE_BEFORE_ELSE_LBRACE = true;
    public boolean SPACE_BEFORE_WHILE_LBRACE = true;
    public boolean SPACE_BEFORE_FOR_LBRACE = true;
    public boolean SPACE_BEFORE_DO_LBRACE = true;
    public boolean SPACE_BEFORE_SWITCH_LBRACE = true;
    public boolean SPACE_BEFORE_TRY_LBRACE = true;
    public boolean SPACE_BEFORE_CATCH_LBRACE = true;
    public boolean SPACE_BEFORE_FINALLY_LBRACE = true;
    public boolean SPACE_BEFORE_SYNCHRONIZED_LBRACE = true;
    public boolean SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE = false;
    public boolean SPACE_BEFORE_QUEST = true;
    public boolean SPACE_AFTER_QUEST = true;
    public boolean SPACE_BEFORE_COLON = true;
    public boolean SPACE_AFTER_COLON = true;
    public boolean SPACE_BEFORE_TYPE_PARAMETER_LIST = false;
    public String FIELD_NAME_PREFIX = "";
    public String STATIC_FIELD_NAME_PREFIX = "";
    public String PARAMETER_NAME_PREFIX = "";
    public String LOCAL_VARIABLE_NAME_PREFIX = "";
    public String FIELD_NAME_SUFFIX = "";
    public String STATIC_FIELD_NAME_SUFFIX = "";
    public String PARAMETER_NAME_SUFFIX = "";
    public String LOCAL_VARIABLE_NAME_SUFFIX = "";
    public boolean PREFER_LONGER_NAMES = true;
    public TypeToNameMap FIELD_TYPE_TO_NAME = new TypeToNameMap();
    public TypeToNameMap STATIC_FIELD_TYPE_TO_NAME = new TypeToNameMap();
    @NonNls
    public TypeToNameMap PARAMETER_TYPE_TO_NAME = new TypeToNameMap();
    public TypeToNameMap LOCAL_VARIABLE_TYPE_TO_NAME = new TypeToNameMap();
    public boolean GENERATE_FINAL_LOCALS = false;
    public boolean GENERATE_FINAL_PARAMETERS = false;
    public boolean USE_EXTERNAL_ANNOTATIONS = false;
    public boolean USE_FQ_CLASS_NAMES = false;
    public boolean USE_FQ_CLASS_NAMES_IN_JAVADOC = true;
    public boolean USE_SINGLE_CLASS_IMPORTS = true;
    public boolean INSERT_INNER_CLASS_IMPORTS = false;
    public int CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = 5;
    public int NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = 3;
    public PackageTable PACKAGES_TO_USE_IMPORT_ON_DEMAND = new PackageTable();
    public ImportLayoutTable IMPORT_LAYOUT_TABLE = new ImportLayoutTable();
    public boolean OPTIMIZE_IMPORTS_ON_THE_FLY = false;
    public boolean ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY = false;
    public int FIELDS_ORDER_WEIGHT = 1;
    public int CONSTRUCTORS_ORDER_WEIGHT = 2;
    public int METHODS_ORDER_WEIGHT = 3;
    public int INNER_CLASSES_ORDER_WEIGHT = 4;
    public int RIGHT_MARGIN = 120;
    public static final int DO_NOT_WRAP = 0;
    public static final int WRAP_AS_NEEDED = 1;
    public static final int WRAP_ALWAYS = 2;
    public static final int WRAP_ON_EVERY_ITEM = 4;
    public int CALL_PARAMETERS_WRAP = 0;
    public boolean PREFER_PARAMETERS_WRAP = false;
    public boolean CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
    public boolean CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
    public int METHOD_PARAMETERS_WRAP = 0;
    public boolean METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
    public boolean METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
    public int EXTENDS_LIST_WRAP = 0;
    public int THROWS_LIST_WRAP = 0;
    public int EXTENDS_KEYWORD_WRAP = 0;
    public int THROWS_KEYWORD_WRAP = 0;
    public int METHOD_CALL_CHAIN_WRAP = 0;
    public boolean PARENTHESES_EXPRESSION_LPAREN_WRAP = false;
    public boolean PARENTHESES_EXPRESSION_RPAREN_WRAP = false;
    public int BINARY_OPERATION_WRAP = 0;
    public boolean BINARY_OPERATION_SIGN_ON_NEXT_LINE = false;
    public int TERNARY_OPERATION_WRAP = 0;
    public boolean TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = false;
    public boolean MODIFIER_LIST_WRAP = false;
    public boolean KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
    public boolean KEEP_SIMPLE_METHODS_IN_ONE_LINE = false;
    public int FOR_STATEMENT_WRAP = 0;
    public boolean FOR_STATEMENT_LPAREN_ON_NEXT_LINE = false;
    public boolean FOR_STATEMENT_RPAREN_ON_NEXT_LINE = false;
    public int ARRAY_INITIALIZER_WRAP = 0;
    public boolean ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = false;
    public boolean ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = false;
    public int ASSIGNMENT_WRAP = 0;
    public boolean PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE = false;
    public int LABELED_STATEMENT_WRAP = 2;
    public boolean WRAP_COMMENTS = false;
    public int ASSERT_STATEMENT_WRAP = 0;
    public boolean ASSERT_STATEMENT_COLON_ON_NEXT_LINE = false;
    public static final int DO_NOT_FORCE = 0;
    public static final int FORCE_BRACES_IF_MULTILINE = 1;
    public static final int FORCE_BRACES_ALWAYS = 3;
    public int IF_BRACE_FORCE = 0;
    public int DOWHILE_BRACE_FORCE = 0;
    public int WHILE_BRACE_FORCE = 0;
    public int FOR_BRACE_FORCE = 0;
    @NonNls
    public String ENTITY_EB_PREFIX = "";
    @NonNls
    public String ENTITY_EB_SUFFIX = "Bean";
    @NonNls
    public String ENTITY_HI_PREFIX = "";
    @NonNls
    public String ENTITY_HI_SUFFIX = "Home";
    @NonNls
    public String ENTITY_RI_PREFIX = "";
    @NonNls
    public String ENTITY_RI_SUFFIX = "";
    @NonNls
    public String ENTITY_LHI_PREFIX = "Local";
    @NonNls
    public String ENTITY_LHI_SUFFIX = "Home";
    @NonNls
    public String ENTITY_LI_PREFIX = "Local";
    @NonNls
    public String ENTITY_LI_SUFFIX = "";
    @NonNls
    public String ENTITY_DD_PREFIX = "";
    @NonNls
    public String ENTITY_DD_SUFFIX = "EJB";
    @NonNls
    public String ENTITY_VO_PREFIX = "";
    @NonNls
    public String ENTITY_VO_SUFFIX = "VO";
    @NonNls
    public String ENTITY_PK_CLASS = "java.lang.String";
    @NonNls
    public String SESSION_EB_PREFIX = "";
    @NonNls
    public String SESSION_EB_SUFFIX = "Bean";
    @NonNls
    public String SESSION_HI_PREFIX = "";
    @NonNls
    public String SESSION_HI_SUFFIX = "Home";
    @NonNls
    public String SESSION_RI_PREFIX = "";
    @NonNls
    public String SESSION_RI_SUFFIX = "";
    @NonNls
    public String SESSION_LHI_PREFIX = "Local";
    @NonNls
    public String SESSION_LHI_SUFFIX = "Home";
    @NonNls
    public String SESSION_LI_PREFIX = "Local";
    @NonNls
    public String SESSION_LI_SUFFIX = "";
    @NonNls
    public String SESSION_SI_PREFIX = "";
    @NonNls
    public String SESSION_SI_SUFFIX = "Service";
    @NonNls
    public String SESSION_DD_PREFIX = "";
    @NonNls
    public String SESSION_DD_SUFFIX = "EJB";
    @NonNls
    public String MESSAGE_EB_PREFIX = "";
    @NonNls
    public String MESSAGE_EB_SUFFIX = "Bean";
    @NonNls
    public String MESSAGE_DD_PREFIX = "";
    @NonNls
    public String MESSAGE_DD_SUFFIX = "EJB";
    @NonNls
    public String SERVLET_CLASS_PREFIX = "";
    @NonNls
    public String SERVLET_CLASS_SUFFIX = "";
    @NonNls
    public String SERVLET_DD_PREFIX = "";
    @NonNls
    public String SERVLET_DD_SUFFIX = "";
    @NonNls
    public String FILTER_CLASS_PREFIX = "";
    @NonNls
    public String FILTER_CLASS_SUFFIX = "";
    @NonNls
    public String FILTER_DD_PREFIX = "";
    @NonNls
    public String FILTER_DD_SUFFIX = "";
    @NonNls
    public String LISTENER_CLASS_PREFIX = "";
    @NonNls
    public String LISTENER_CLASS_SUFFIX = "";
    public boolean ENABLE_JAVADOC_FORMATTING = true;
    public boolean JD_ALIGN_PARAM_COMMENTS = true;
    public int JD_MIN_PARM_NAME_LENGTH = 0;
    public int JD_MAX_PARM_NAME_LENGTH = 30;
    public boolean JD_ALIGN_EXCEPTION_COMMENTS = true;
    public int JD_MIN_EXCEPTION_NAME_LENGTH = 0;
    public int JD_MAX_EXCEPTION_NAME_LENGTH = 30;
    public boolean JD_ADD_BLANK_AFTER_PARM_COMMENTS = false;
    public boolean JD_ADD_BLANK_AFTER_RETURN = false;
    public boolean JD_ADD_BLANK_AFTER_DESCRIPTION = true;
    public boolean JD_P_AT_EMPTY_LINES = true;
    public boolean JD_KEEP_INVALID_TAGS = true;
    public boolean JD_KEEP_EMPTY_LINES = true;
    public boolean JD_DO_NOT_WRAP_ONE_LINE_COMMENTS = false;
    public boolean JD_USE_THROWS_NOT_EXCEPTION = true;
    public boolean JD_KEEP_EMPTY_PARAMETER = true;
    public boolean JD_KEEP_EMPTY_EXCEPTION = true;
    public boolean JD_KEEP_EMPTY_RETURN = true;
    public boolean JD_LEADING_ASTERISKS_ARE_ENABLED = true;
    public boolean XML_KEEP_WHITESPACES = false;
    public int XML_ATTRIBUTE_WRAP = 1;
    public int XML_TEXT_WRAP = 1;
    public boolean XML_KEEP_LINE_BREAKS = true;
    public boolean XML_KEEP_LINE_BREAKS_IN_TEXT = true;
    public int XML_KEEP_BLANK_LINES = 2;
    public boolean XML_ALIGN_ATTRIBUTES = true;
    public boolean XML_ALIGN_TEXT = false;
    public boolean XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE = false;
    public boolean XML_SPACE_AFTER_TAG_NAME = false;
    public boolean XML_SPACE_INSIDE_EMPTY_TAG = false;
    public boolean HTML_KEEP_WHITESPACES = false;
    public int HTML_ATTRIBUTE_WRAP = 1;
    public int HTML_TEXT_WRAP = 1;
    public boolean HTML_KEEP_LINE_BREAKS = true;
    public boolean HTML_KEEP_LINE_BREAKS_IN_TEXT = true;
    public int HTML_KEEP_BLANK_LINES = 2;
    public boolean HTML_ALIGN_ATTRIBUTES = true;
    public boolean HTML_ALIGN_TEXT = false;
    public boolean HTML_SPACE_AROUND_EQUALITY_IN_ATTRINUTE = false;
    public boolean HTML_SPACE_AFTER_TAG_NAME = false;
    public boolean HTML_SPACE_INSIDE_EMPTY_TAG = false;
    @NonNls
    public String HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE = "body,div,p,form,h1,h2,h3";
    @NonNls
    public String HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE = "br";
    @NonNls
    public String HTML_DO_NOT_INDENT_CHILDREN_OF = "html,body";
    public int HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES = 100;
    @NonNls
    public String HTML_KEEP_WHITESPACES_INSIDE = "span,pre";
    @NonNls
    public String HTML_INLINE_ELEMENTS = "a,abbr,acronym,b,basefont,bdo,big,br,cite,cite,code,dfn,em,font,i,img,input,kbd,label,q,s,samp,select,span,strike,strong,sub,sup,textarea,tt,u,var";
    @NonNls
    public String HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT = "title,h1,h2,h3,h4,h5,h6,p";
    public boolean JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST = false;
    public int METHOD_ANNOTATION_WRAP = 2;
    public int CLASS_ANNOTATION_WRAP = 2;
    public int FIELD_ANNOTATION_WRAP = 2;
    public int PARAMETER_ANNOTATION_WRAP = 0;
    public int VARIABLE_ANNOTATION_WRAP = 0;
    public boolean SPACE_BEFORE_ANOTATION_PARAMETER_LIST = false;
    public boolean SPACE_WITHIN_ANNOTATION_PARENTHESES = false;
    public int ENUM_CONSTANTS_WRAP = 0;
    private CodeStyleSettings myParentSettings;

    public CodeStyleSettings() {
        this(true);
    }

    public CodeStyleSettings(boolean loadExtensions) {
        this.initTypeToName();
        this.initImports();
        if (loadExtensions) {
            FileTypeIndentOptionsProvider[] fileTypeIndentOptionsProviders;
            CodeStyleSettingsProvider[] codeStyleSettingsProviders;
            for (CodeStyleSettingsProvider provider : codeStyleSettingsProviders = (CodeStyleSettingsProvider[])Extensions.getExtensions(CodeStyleSettingsProvider.EXTENSION_POINT_NAME)) {
                this.addCustomSettings(provider.createCustomSettings(this));
            }
            for (FileTypeIndentOptionsProvider provider : fileTypeIndentOptionsProviders = ApplicationManager.getApplication().getComponents(FileTypeIndentOptionsProvider.class)) {
                this.registerAdditionalIndentOptions(provider.getFileType(), provider.createIndentOptions());
            }
        }
    }

    private void initImports() {
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.insertEntryAt(new PackageTable.Entry("java.awt", false), 0);
        this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.insertEntryAt(new PackageTable.Entry("javax.swing", false), 1);
        this.IMPORT_LAYOUT_TABLE.insertEntryAt(new ImportLayoutTable.PackageEntry("", true), 0);
        this.IMPORT_LAYOUT_TABLE.insertEntryAt(new ImportLayoutTable.EmptyLineEntry(), 1);
        this.IMPORT_LAYOUT_TABLE.insertEntryAt(new ImportLayoutTable.PackageEntry("javax", true), 2);
        this.IMPORT_LAYOUT_TABLE.insertEntryAt(new ImportLayoutTable.PackageEntry("java", true), 3);
    }

    private void initTypeToName() {
        CodeStyleSettings.initGeneralLocalVariable(this.PARAMETER_TYPE_TO_NAME);
        CodeStyleSettings.initGeneralLocalVariable(this.LOCAL_VARIABLE_TYPE_TO_NAME);
        this.PARAMETER_TYPE_TO_NAME.addPair("*Exception", "e");
    }

    private static void initGeneralLocalVariable(@NonNls TypeToNameMap map) {
        map.addPair("int", "i");
        map.addPair("byte", "b");
        map.addPair("char", "c");
        map.addPair("long", "l");
        map.addPair("short", "i");
        map.addPair("boolean", "b");
        map.addPair("double", "v");
        map.addPair("float", "v");
        map.addPair("java.lang.Object", "o");
        map.addPair("java.lang.String", "s");
        map.addPair("*Event", "event");
    }

    public void setParentSettings(CodeStyleSettings parent) {
        this.myParentSettings = parent;
    }

    public CodeStyleSettings getParentSettings() {
        return this.myParentSettings;
    }

    private void addCustomSettings(CustomCodeStyleSettings settings) {
        this.myCustomSettings.put(settings.getClass(), settings);
    }

    public <T extends CustomCodeStyleSettings> T getCustomSettings(Class<T> aClass) {
        return (T)this.myCustomSettings.get(aClass);
    }

    public Object clone() {
        try {
            CodeStyleSettings clon = (CodeStyleSettings)super.clone();
            for (CustomCodeStyleSettings customCodeStyleSettings : this.myCustomSettings.values()) {
                clon.addCustomSettings(customCodeStyleSettings);
            }
            clon.FIELD_TYPE_TO_NAME = (TypeToNameMap)this.FIELD_TYPE_TO_NAME.clone();
            clon.STATIC_FIELD_TYPE_TO_NAME = (TypeToNameMap)this.STATIC_FIELD_TYPE_TO_NAME.clone();
            clon.PARAMETER_TYPE_TO_NAME = (TypeToNameMap)this.PARAMETER_TYPE_TO_NAME.clone();
            clon.LOCAL_VARIABLE_TYPE_TO_NAME = (TypeToNameMap)this.LOCAL_VARIABLE_TYPE_TO_NAME.clone();
            clon.PACKAGES_TO_USE_IMPORT_ON_DEMAND = (PackageTable)this.PACKAGES_TO_USE_IMPORT_ON_DEMAND.clone();
            clon.IMPORT_LAYOUT_TABLE = (ImportLayoutTable)this.IMPORT_LAYOUT_TABLE.clone();
            clon.JAVA_INDENT_OPTIONS = (IndentOptions)this.JAVA_INDENT_OPTIONS.clone();
            clon.JSP_INDENT_OPTIONS = (IndentOptions)this.JSP_INDENT_OPTIONS.clone();
            clon.XML_INDENT_OPTIONS = (IndentOptions)this.XML_INDENT_OPTIONS.clone();
            clon.OTHER_INDENT_OPTIONS = (IndentOptions)this.OTHER_INDENT_OPTIONS.clone();
            clon.ourAdditionalIndentOptions = new LinkedHashMap<FileType, IndentOptions>();
            for (Map.Entry entry : this.ourAdditionalIndentOptions.entrySet()) {
                clon.ourAdditionalIndentOptions.put((FileType)entry.getKey(), (IndentOptions)((IndentOptions)entry.getValue()).clone());
            }
            return clon;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getLineSeparator() {
        return this.LINE_SEPARATOR != null ? this.LINE_SEPARATOR : ourSystemLineSeparator;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element);
        this.importOldIndentOptions(element);
        for (CustomCodeStyleSettings settings : this.myCustomSettings.values()) {
            settings.readExternal(element);
        }
        List list = element.getChildren(ADDITIONAL_INDENT_OPTIONS);
        if (list != null) {
            for (Object o : list) {
                Element additionalIndentElement;
                String fileTypeId;
                if (!(o instanceof Element) || (fileTypeId = (additionalIndentElement = (Element)o).getAttributeValue(FILETYPE)) == null) continue;
                FileType target = FileTypeManager.getInstance().getFileTypeByExtension(fileTypeId);
                IndentOptions options = new IndentOptions();
                options.readExternal(additionalIndentElement);
                this.registerAdditionalIndentOptions(target, options);
            }
        }
    }

    private void importOldIndentOptions(@NonNls Element element) {
        List options = element.getChildren("option");
        for (Object option1 : options) {
            int value;
            Element option = (Element)option1;
            String name = option.getAttributeValue("name");
            if ("TAB_SIZE".equals(name)) {
                this.JAVA_INDENT_OPTIONS.TAB_SIZE = value = Integer.valueOf(option.getAttributeValue("value")).intValue();
                this.JSP_INDENT_OPTIONS.TAB_SIZE = value;
                this.XML_INDENT_OPTIONS.TAB_SIZE = value;
                this.OTHER_INDENT_OPTIONS.TAB_SIZE = value;
                continue;
            }
            if ("INDENT_SIZE".equals(name)) {
                this.JAVA_INDENT_OPTIONS.INDENT_SIZE = value = Integer.valueOf(option.getAttributeValue("value")).intValue();
                this.JSP_INDENT_OPTIONS.INDENT_SIZE = value;
                this.XML_INDENT_OPTIONS.INDENT_SIZE = value;
                this.OTHER_INDENT_OPTIONS.INDENT_SIZE = value;
                continue;
            }
            if ("CONTINUATION_INDENT_SIZE".equals(name)) {
                this.JAVA_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE = value = Integer.valueOf(option.getAttributeValue("value")).intValue();
                this.JSP_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE = value;
                this.XML_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE = value;
                this.OTHER_INDENT_OPTIONS.CONTINUATION_INDENT_SIZE = value;
                continue;
            }
            if ("USE_TAB_CHARACTER".equals(name)) {
                value = Boolean.valueOf(option.getAttributeValue("value")).booleanValue() ? 1 : 0;
                this.JAVA_INDENT_OPTIONS.USE_TAB_CHARACTER = value;
                this.JSP_INDENT_OPTIONS.USE_TAB_CHARACTER = value;
                this.XML_INDENT_OPTIONS.USE_TAB_CHARACTER = value;
                this.OTHER_INDENT_OPTIONS.USE_TAB_CHARACTER = value;
                continue;
            }
            if (!"SMART_TABS".equals(name)) continue;
            value = Boolean.valueOf(option.getAttributeValue("value")).booleanValue() ? 1 : 0;
            this.JAVA_INDENT_OPTIONS.SMART_TABS = value;
            this.JSP_INDENT_OPTIONS.SMART_TABS = value;
            this.XML_INDENT_OPTIONS.SMART_TABS = value;
            this.OTHER_INDENT_OPTIONS.SMART_TABS = value;
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        CodeStyleSettings parentSettings = new CodeStyleSettings();
        DefaultJDOMExternalizer.writeExternal(this, element, new DifferenceFilter<CodeStyleSettings>(this, parentSettings));
        for (CustomCodeStyleSettings settings : this.myCustomSettings.values()) {
            Object parentCustomSettings = parentSettings.getCustomSettings(settings.getClass());
            assert (parentCustomSettings != null);
            settings.writeExternal(element, (CustomCodeStyleSettings)parentCustomSettings);
        }
        FileType[] fileTypes = this.ourAdditionalIndentOptions.keySet().toArray(new FileType[this.ourAdditionalIndentOptions.keySet().size()]);
        Arrays.sort(fileTypes, new Comparator<FileType>(){

            @Override
            public int compare(FileType o1, FileType o2) {
                return o1.getDefaultExtension().compareTo(o2.getDefaultExtension());
            }
        });
        for (FileType fileType : fileTypes) {
            IndentOptions indentOptions = this.ourAdditionalIndentOptions.get(fileType);
            Element additionalIndentOptions = new Element(ADDITIONAL_INDENT_OPTIONS);
            indentOptions.writeExternal(additionalIndentOptions);
            additionalIndentOptions.setAttribute(FILETYPE, fileType.getDefaultExtension());
            element.addContent(additionalIndentOptions);
        }
    }

    public IndentOptions getIndentOptions(FileType fileType) {
        if (this.USE_SAME_INDENTS || fileType == null || fileType == StdFileTypes.JAVA) {
            return this.JAVA_INDENT_OPTIONS;
        }
        IndentOptions indentOptions = this.ourAdditionalIndentOptions.get(fileType);
        if (indentOptions != null) {
            return indentOptions;
        }
        if (fileType == StdFileTypes.JSP) {
            return this.JSP_INDENT_OPTIONS;
        }
        if (fileType == StdFileTypes.XML) {
            return this.XML_INDENT_OPTIONS;
        }
        return this.OTHER_INDENT_OPTIONS;
    }

    public boolean isSmartTabs(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).SMART_TABS;
    }

    public int getIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).INDENT_SIZE;
    }

    public int getContinuationIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).CONTINUATION_INDENT_SIZE;
    }

    public int getLabelIndentSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).LABEL_INDENT_SIZE;
    }

    public boolean getLabelIndentAbsolute(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).LABEL_INDENT_ABSOLUTE;
    }

    public int getTabSize(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).TAB_SIZE;
    }

    public boolean useTabCharacter(FileType fileType) {
        return this.getIndentOptions((FileType)fileType).USE_TAB_CHARACTER;
    }

    private void registerAdditionalIndentOptions(FileType fileType, IndentOptions options) {
        this.ourAdditionalIndentOptions.put(fileType, options);
    }

    public Collection<FileType> getFileTypesWithAdditionalIndentOptions() {
        return this.ourAdditionalIndentOptions.keySet();
    }

    public IndentOptions getAdditionalIndentOptions(FileType fileType) {
        return this.ourAdditionalIndentOptions.get(fileType);
    }

    public static class ImportLayoutTable
    implements JDOMExternalizable,
    Cloneable {
        private ArrayList<Entry> myEntries = new ArrayList();

        public void copyFrom(ImportLayoutTable importLayoutTable) {
            this.myEntries = (ArrayList)importLayoutTable.myEntries.clone();
        }

        public Entry[] getEntries() {
            return this.myEntries.toArray(new Entry[this.myEntries.size()]);
        }

        public void insertEntryAt(Entry entry, int i) {
            this.myEntries.add(i, entry);
        }

        public void removeEntryAt(int i) {
            this.myEntries.remove(i);
        }

        public Entry getEntryAt(int i) {
            return this.myEntries.get(i);
        }

        public int getEntryCount() {
            return this.myEntries.size();
        }

        public void setEntryAt(Entry entry, int i) {
            this.myEntries.set(i, entry);
        }

        public void readExternal(Element element) throws InvalidDataException {
            this.myEntries.clear();
            List children = element.getChildren();
            for (Object aChildren : children) {
                Element e = (Element)aChildren;
                String name = e.getName();
                if ("package".equals(name)) {
                    String packageName = e.getAttributeValue("name");
                    boolean withSubpackages = Boolean.parseBoolean(e.getAttributeValue("withSubpackages"));
                    if (packageName == null) {
                        throw new InvalidDataException();
                    }
                    this.myEntries.add(new PackageEntry(packageName, withSubpackages));
                    continue;
                }
                if (!"emptyLine".equals(name)) continue;
                this.myEntries.add(new EmptyLineEntry());
            }
        }

        public void writeExternal(Element parentNode) throws WriteExternalException {
            for (Entry myEntry : this.myEntries) {
                if (myEntry instanceof PackageEntry) {
                    PackageEntry entry = (PackageEntry)myEntry;
                    Element element = new Element("package");
                    parentNode.addContent(element);
                    element.setAttribute("name", entry.getPackageName());
                    element.setAttribute("withSubpackages", entry.isWithSubpackages() ? "true" : "false");
                    continue;
                }
                if (!(myEntry instanceof EmptyLineEntry)) continue;
                Element element = new Element("emptyLine");
                parentNode.addContent(element);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ImportLayoutTable)) {
                return false;
            }
            ImportLayoutTable other = (ImportLayoutTable)obj;
            if (other.myEntries.size() != this.myEntries.size()) {
                return false;
            }
            for (int i = 0; i < this.myEntries.size(); ++i) {
                Entry otherentry;
                Entry entry = this.myEntries.get(i);
                if (Comparing.equal(entry, otherentry = other.myEntries.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (!this.myEntries.isEmpty() && this.myEntries.get(0) != null) {
                return this.myEntries.get(0).hashCode();
            }
            return 0;
        }

        public Object clone() throws CloneNotSupportedException {
            ImportLayoutTable clon = (ImportLayoutTable)ImportLayoutTable.super.clone();
            clon.myEntries = (ArrayList)this.myEntries.clone();
            return clon;
        }

        public static class EmptyLineEntry
        implements Entry {
            public boolean equals(Object obj) {
                return obj instanceof EmptyLineEntry;
            }

            public int hashCode() {
                return 100;
            }
        }

        public static class PackageEntry
        implements Entry {
            private final String myPackageName;
            private final boolean myWithSubpackages;

            public PackageEntry(@NonNls String packageName, boolean withSubpackages) {
                this.myPackageName = packageName;
                this.myWithSubpackages = withSubpackages;
            }

            public String getPackageName() {
                return this.myPackageName;
            }

            public boolean isWithSubpackages() {
                return this.myWithSubpackages;
            }

            public boolean matchesPackageName(String packageName) {
                if (this.myPackageName.length() == 0 && this.myWithSubpackages) {
                    return true;
                }
                if (packageName.startsWith(this.myPackageName)) {
                    if (packageName.length() == this.myPackageName.length()) {
                        return true;
                    }
                    if (this.myWithSubpackages && packageName.charAt(this.myPackageName.length()) == '.') {
                        return true;
                    }
                }
                return false;
            }

            public boolean matchesClassName(String className) {
                int dotIndex = className.lastIndexOf(46);
                String packageName = dotIndex < 0 ? "" : className.substring(0, dotIndex);
                return this.matchesPackageName(packageName);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof PackageEntry)) {
                    return false;
                }
                PackageEntry entry = (PackageEntry)obj;
                return entry.myWithSubpackages == this.myWithSubpackages && Comparing.equal(entry.myPackageName, this.myPackageName);
            }

            public int hashCode() {
                if (this.myPackageName == null) {
                    return 0;
                }
                return this.myPackageName.hashCode();
            }
        }

        public static interface Entry {
        }
    }

    public static class PackageTable
    implements JDOMExternalizable,
    Cloneable {
        private ArrayList<Entry> myEntries = new ArrayList();

        public boolean equals(Object obj) {
            if (!(obj instanceof PackageTable)) {
                return false;
            }
            PackageTable other = (PackageTable)obj;
            if (other.myEntries.size() != this.myEntries.size()) {
                return false;
            }
            for (int i = 0; i < this.myEntries.size(); ++i) {
                Entry otherentry;
                Entry entry = this.myEntries.get(i);
                if (Comparing.equal(entry, otherentry = other.myEntries.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (!this.myEntries.isEmpty() && this.myEntries.get(0) != null) {
                return this.myEntries.get(0).hashCode();
            }
            return 0;
        }

        public Object clone() throws CloneNotSupportedException {
            PackageTable clon = (PackageTable)PackageTable.super.clone();
            clon.myEntries = (ArrayList)this.myEntries.clone();
            return clon;
        }

        public void copyFrom(PackageTable packageTable) {
            this.myEntries = (ArrayList)packageTable.myEntries.clone();
        }

        public Entry[] getEntries() {
            return this.myEntries.toArray(new Entry[this.myEntries.size()]);
        }

        public void insertEntryAt(Entry entry, int i) {
            this.myEntries.add(i, entry);
        }

        public void removeEntryAt(int i) {
            this.myEntries.remove(i);
        }

        public Entry getEntryAt(int i) {
            return this.myEntries.get(i);
        }

        public int getEntryCount() {
            return this.myEntries.size();
        }

        public void setEntryAt(Entry entry, int i) {
            this.myEntries.set(i, entry);
        }

        public boolean contains(String packageName) {
            for (Entry entry : this.myEntries) {
                if (!packageName.startsWith(entry.packageName)) continue;
                if (packageName.length() == entry.packageName.length()) {
                    return true;
                }
                if (!entry.withSubpackages || packageName.charAt(entry.packageName.length()) != '.') continue;
                return true;
            }
            return false;
        }

        public void readExternal(@NonNls Element element) throws InvalidDataException {
            this.myEntries.clear();
            for (Object o : element.getChildren("package")) {
                Element e = (Element)o;
                String packageName = e.getAttributeValue("name");
                boolean withSubpackages = Boolean.parseBoolean(e.getAttributeValue("withSubpackages"));
                if (packageName == null) {
                    throw new InvalidDataException();
                }
                this.myEntries.add(new Entry(packageName, withSubpackages));
            }
        }

        public void writeExternal(Element parentNode) throws WriteExternalException {
            for (Entry entry : this.myEntries) {
                Element element = new Element("package");
                parentNode.addContent(element);
                element.setAttribute("name", entry.packageName);
                element.setAttribute("withSubpackages", Boolean.toString(entry.withSubpackages));
            }
        }

        public static class Entry
        implements Cloneable {
            final String packageName;
            final boolean withSubpackages;

            public Entry(@NonNls String packageName, boolean withSubpackages) {
                this.packageName = packageName;
                this.withSubpackages = withSubpackages;
            }

            public String getPackageName() {
                return this.packageName;
            }

            public boolean isWithSubpackages() {
                return this.withSubpackages;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Entry)) {
                    return false;
                }
                Entry entry = (Entry)obj;
                return entry.withSubpackages == this.withSubpackages && Comparing.equal(entry.packageName, this.packageName);
            }

            public int hashCode() {
                if (this.packageName == null) {
                    return 0;
                }
                return this.packageName.hashCode();
            }
        }
    }

    public static class TypeToNameMap
    implements JDOMExternalizable,
    Cloneable {
        private ArrayList<String> myPatterns = new ArrayList();
        private ArrayList<String> myNames = new ArrayList();

        public void addPair(String pattern, String name) {
            this.myPatterns.add(pattern);
            this.myNames.add(name);
        }

        public String nameByType(String type) {
            for (int i = 0; i < this.myPatterns.size(); ++i) {
                String pattern = this.myPatterns.get(i);
                if (!(StringUtil.startsWithChar(pattern, '*') ? type.endsWith(pattern.substring(1)) : type.equals(pattern))) continue;
                return this.myNames.get(i);
            }
            return null;
        }

        public void readExternal(@NonNls Element element) throws InvalidDataException {
            this.myPatterns.clear();
            this.myNames.clear();
            for (Object o : element.getChildren("pair")) {
                Element e = (Element)o;
                String pattern = e.getAttributeValue("type");
                String name = e.getAttributeValue("name");
                if (pattern == null || name == null) {
                    throw new InvalidDataException();
                }
                this.myPatterns.add(pattern);
                this.myNames.add(name);
            }
        }

        public void writeExternal(Element parentNode) throws WriteExternalException {
            for (int i = 0; i < this.myPatterns.size(); ++i) {
                String pattern = this.myPatterns.get(i);
                String name = this.myNames.get(i);
                Element element = new Element("pair");
                parentNode.addContent(element);
                element.setAttribute("type", pattern);
                element.setAttribute("name", name);
            }
        }

        public Object clone() throws CloneNotSupportedException {
            TypeToNameMap clon = (TypeToNameMap)TypeToNameMap.super.clone();
            clon.myPatterns = (ArrayList)this.myPatterns.clone();
            clon.myNames = (ArrayList)this.myNames.clone();
            return clon;
        }

        public boolean equals(Object other) {
            if (other instanceof TypeToNameMap) {
                String s2;
                String s1;
                int i;
                TypeToNameMap otherMap = (TypeToNameMap)other;
                if (this.myPatterns.size() != otherMap.myPatterns.size()) {
                    return false;
                }
                if (this.myNames.size() != otherMap.myNames.size()) {
                    return false;
                }
                for (i = 0; i < this.myPatterns.size(); ++i) {
                    s1 = this.myPatterns.get(i);
                    if (Comparing.equal(s1, s2 = otherMap.myPatterns.get(i))) continue;
                    return false;
                }
                for (i = 0; i < this.myNames.size(); ++i) {
                    s1 = this.myNames.get(i);
                    if (Comparing.equal(s1, s2 = otherMap.myNames.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int code = 0;
            for (String myPattern : this.myPatterns) {
                code += myPattern.hashCode();
            }
            for (String myName : this.myNames) {
                code += myName.hashCode();
            }
            return code;
        }
    }

    public static class IndentOptions
    implements JDOMExternalizable,
    Cloneable {
        public int INDENT_SIZE = 4;
        public int CONTINUATION_INDENT_SIZE = 8;
        public int TAB_SIZE = 4;
        public boolean USE_TAB_CHARACTER = false;
        public boolean SMART_TABS = false;
        public int LABEL_INDENT_SIZE = 0;
        public boolean LABEL_INDENT_ABSOLUTE = false;

        public void readExternal(Element element) throws InvalidDataException {
            DefaultJDOMExternalizer.readExternal(this, element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            DefaultJDOMExternalizer.writeExternal(this, element);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndentOptions)) {
                return false;
            }
            IndentOptions indentOptions = (IndentOptions)o;
            if (this.CONTINUATION_INDENT_SIZE != indentOptions.CONTINUATION_INDENT_SIZE) {
                return false;
            }
            if (this.INDENT_SIZE != indentOptions.INDENT_SIZE) {
                return false;
            }
            if (this.SMART_TABS != indentOptions.SMART_TABS) {
                return false;
            }
            if (this.TAB_SIZE != indentOptions.TAB_SIZE) {
                return false;
            }
            return this.USE_TAB_CHARACTER == indentOptions.USE_TAB_CHARACTER;
        }
    }
}

