/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PsiType {
    public static final PsiType BYTE = PsiPrimitiveType.BYTE;
    public static final PsiType CHAR = PsiPrimitiveType.CHAR;
    public static final PsiType DOUBLE = PsiPrimitiveType.DOUBLE;
    public static final PsiType FLOAT = PsiPrimitiveType.FLOAT;
    public static final PsiType INT = PsiPrimitiveType.INT;
    public static final PsiType LONG = PsiPrimitiveType.LONG;
    public static final PsiType SHORT = PsiPrimitiveType.SHORT;
    public static final PsiType BOOLEAN = PsiPrimitiveType.BOOLEAN;
    public static final PsiType VOID = PsiPrimitiveType.VOID;
    public static final PsiType NULL = PsiPrimitiveType.NULL;
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];

    public PsiArrayType createArrayType() {
        return new PsiArrayType(this);
    }

    public abstract String getPresentableText();

    @NonNls
    public abstract String getCanonicalText();

    public abstract String getInternalCanonicalText();

    public abstract boolean isValid();

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiType.isAssignableFrom must not be null");
        }
        return TypeConversionUtil.isAssignable(this, type);
    }

    public boolean isConvertibleFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiType.isConvertibleFrom must not be null");
        }
        return TypeConversionUtil.areTypesConvertible(type, this);
    }

    public abstract boolean equalsToText(@NonNls String var1);

    public static PsiClassType getJavaLangObject(PsiManager manager, GlobalSearchScope resolveScope) {
        return manager.getElementFactory().createTypeByFQClassName("java.lang.Object", resolveScope);
    }

    public static PsiClassType getJavaLangClass(PsiManager manager, GlobalSearchScope resolveScope) {
        return manager.getElementFactory().createTypeByFQClassName("java.lang.Class", resolveScope);
    }

    public static PsiClassType getJavaLangTrowable(PsiManager manager, GlobalSearchScope resolveScope) {
        return manager.getElementFactory().createTypeByFQClassName("java.lang.Throwable", resolveScope);
    }

    public static PsiClassType getJavaLangString(PsiManager manager, GlobalSearchScope resolveScope) {
        return manager.getElementFactory().createTypeByFQClassName("java.lang.String", resolveScope);
    }

    public static PsiClassType getJavaLangError(PsiManager manager, GlobalSearchScope resolveScope) {
        return manager.getElementFactory().createTypeByFQClassName("java.lang.Error", resolveScope);
    }

    public static PsiClassType getJavaLangRuntimeException(PsiManager manager, GlobalSearchScope resolveScope) {
        return manager.getElementFactory().createTypeByFQClassName("java.lang.RuntimeException", resolveScope);
    }

    public abstract <A> A accept(PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type = this;
        int dims = 0;
        while (type instanceof PsiArrayType) {
            ++dims;
            type = ((PsiArrayType)type).getComponentType();
        }
        return dims;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type = this;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiType.getDeepComponentType must not return null");
        }
        return psiType;
    }

    @Nullable
    public abstract GlobalSearchScope getResolveScope();

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    @NotNull
    public abstract PsiType[] getSuperTypes();
}

