/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PsiReferenceBase<T extends PsiElement>
implements PsiReference {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiReferenceBase");
    protected final T myElement;
    private TextRange myRange;
    protected boolean mySoft;

    public PsiReferenceBase(T element, TextRange range, boolean soft) {
        this(element, range);
        this.mySoft = soft;
    }

    public PsiReferenceBase(T element, TextRange range) {
        this(element);
        this.myRange = range;
    }

    public PsiReferenceBase(T element, boolean soft) {
        this(element);
        this.mySoft = soft;
    }

    public PsiReferenceBase(T element) {
        this.myElement = element;
    }

    public void setRangeInElement(TextRange range) {
        this.myRange = range;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getValue() {
        String string;
        String text = this.myElement.getText();
        TextRange range = this.getRangeInElement();
        if (range.getEndOffset() > text.length() || range.getStartOffset() > text.length() || range.getStartOffset() < 0 || range.getEndOffset() < 0) {
            LOG.error("Wrong range in reference " + this + ": " + range + ". Reference text: '" + text + "'");
            string = text;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiReferenceBase.getValue must not return null");
            return string;
        }
        string = range.substring(text);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiReferenceBase.getValue must not return null");
    }

    public T getElement() {
        return this.myElement;
    }

    @Override
    public TextRange getRangeInElement() {
        if (this.myRange == null) {
            this.myRange = this.calculateDefaultRangeInElement();
        }
        return this.myRange;
    }

    protected TextRange calculateDefaultRangeInElement() {
        ElementManipulator<T> manipulator = this.getManipulator();
        assert (manipulator != null) : "Cannot find manipulator for " + this.myElement;
        return manipulator.getRangeInElement(this.myElement);
    }

    @Override
    public String getCanonicalText() {
        return this.getValue();
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator<T> manipulator = this.getManipulator();
        assert (manipulator != null) : "Cannot find manipulator for " + this.myElement;
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiReferenceBase.bindToElement must not be null");
        }
        throw new IncorrectOperationException("Rebind cannot be performed for " + this.getClass());
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return element.getManager().areElementsEquivalent(element, this.resolve());
    }

    public static <T extends PsiElement> PsiReferenceBase<T> createSelfReference(T element, final PsiElement resolveTo) {
        return new PsiReferenceBase<T>(element, true){

            @Override
            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return this.getElement();
            }

            @Override
            @Nullable
            public PsiElement resolve() {
                return resolveTo;
            }

            @Override
            public Object[] getVariants() {
                return EMPTY_ARRAY;
            }
        };
    }

    @Nullable
    public Module getModule() {
        return ModuleUtil.findModuleForPsiElement(this.myElement);
    }

    @Nullable
    ElementManipulator<T> getManipulator() {
        return PsiManager.getInstance(this.myElement.getProject()).getElementManipulatorsRegistry().getManipulator(this.myElement);
    }

    @Override
    public boolean isSoft() {
        return this.mySoft;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Poly<T extends PsiElement>
    extends PsiReferenceBase<T>
    implements PsiPolyVariantReference {
        public Poly(T psiElement) {
            super(psiElement);
        }

        public Poly(T element, boolean soft) {
            super(element, soft);
        }

        public Poly(T element, TextRange range, boolean soft) {
            super(element, range, soft);
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            ResolveResult[] results;
            for (ResolveResult result : results = this.multiResolve(false)) {
                if (!element.getManager().areElementsEquivalent(result.getElement(), element)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            ResolveResult[] resolveResults = this.multiResolve(false);
            return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
        }
    }
}

