/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsiPrimitiveType
extends PsiType {
    protected static final PsiPrimitiveType VOID = new PsiPrimitiveType("void");
    protected static final PsiPrimitiveType BYTE = new PsiPrimitiveType("byte");
    protected static final PsiPrimitiveType CHAR = new PsiPrimitiveType("char");
    protected static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType("double");
    protected static final PsiPrimitiveType FLOAT = new PsiPrimitiveType("float");
    protected static final PsiPrimitiveType LONG = new PsiPrimitiveType("long");
    protected static final PsiPrimitiveType INT = new PsiPrimitiveType("int");
    protected static final PsiPrimitiveType SHORT = new PsiPrimitiveType("short");
    protected static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType("boolean");
    protected static final PsiPrimitiveType NULL = new PsiPrimitiveType("null");
    private final String myName;
    @NonNls
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new HashMap<String, PsiPrimitiveType>();
    @NonNls
    private static final Map<PsiPrimitiveType, String> ourUnboxedToQName = new HashMap<PsiPrimitiveType, String>();

    private PsiPrimitiveType(@NonNls String name) {
        this.myName = name;
    }

    @Override
    public String getPresentableText() {
        return this.myName;
    }

    @Override
    public String getCanonicalText() {
        return this.myName;
    }

    @Override
    public String getInternalCanonicalText() {
        return this.getCanonicalText();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean equalsToText(String text) {
        return this.myName.equals(text);
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{};
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiPrimitiveType.getSuperTypes must not return null");
        }
        return psiTypeArray;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        if (!((PsiClassType)type).getLanguageLevel().hasEnumKeywordAndAutoboxing()) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return null;
        }
        return ourQNameToUnboxed.get(psiClass.getQualifiedName());
    }

    public String getBoxedTypeName() {
        return ourUnboxedToQName.get(this);
    }

    @Nullable
    public PsiClassType getBoxedType(PsiElement context) {
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(context);
        if (!languageLevel.hasEnumKeywordAndAutoboxing()) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        PsiManager manager = context.getManager();
        PsiClass aClass = manager.findClass(boxedQName, context.getResolveScope());
        if (aClass == null) {
            return null;
        }
        return manager.getElementFactory().createType(aClass, PsiSubstitutor.EMPTY, languageLevel);
    }

    @Nullable
    public PsiClassType getBoxedType(PsiManager manager, GlobalSearchScope resolveScope) {
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        PsiClass aClass = manager.findClass(boxedQName, resolveScope);
        if (aClass == null) {
            return null;
        }
        return manager.getElementFactory().createType(aClass);
    }

    static {
        ourQNameToUnboxed.put("java.lang.Boolean", BOOLEAN);
        ourUnboxedToQName.put(BOOLEAN, "java.lang.Boolean");
        ourQNameToUnboxed.put("java.lang.Byte", BYTE);
        ourUnboxedToQName.put(BYTE, "java.lang.Byte");
        ourQNameToUnboxed.put("java.lang.Character", CHAR);
        ourUnboxedToQName.put(CHAR, "java.lang.Character");
        ourQNameToUnboxed.put("java.lang.Short", SHORT);
        ourUnboxedToQName.put(SHORT, "java.lang.Short");
        ourQNameToUnboxed.put("java.lang.Integer", INT);
        ourUnboxedToQName.put(INT, "java.lang.Integer");
        ourQNameToUnboxed.put("java.lang.Long", LONG);
        ourUnboxedToQName.put(LONG, "java.lang.Long");
        ourQNameToUnboxed.put("java.lang.Float", FLOAT);
        ourUnboxedToQName.put(FLOAT, "java.lang.Float");
        ourQNameToUnboxed.put("java.lang.Double", DOUBLE);
        ourUnboxedToQName.put(DOUBLE, "java.lang.Double");
    }
}

