/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PsiNameHelper {
    @NonNls
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?:\\s)|(?:/\\*.*\\*/)|(?://[^\\n]*)");
    private static final int NO_WORD = 0;
    private static final int PREV_UC = 1;
    private static final int WORD = 2;

    public abstract boolean isIdentifier(@Nullable String var1);

    public abstract boolean isIdentifier(@Nullable String var1, LanguageLevel var2);

    public abstract boolean isKeyword(@Nullable String var1);

    public abstract boolean isQualifiedName(@Nullable String var1);

    public static String getShortClassName(@NotNull String referenceText) {
        if (referenceText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiNameHelper.getShortClassName must not be null");
        }
        return PsiNameHelper.getShortClassName(referenceText, true);
    }

    private static String getShortClassName(String referenceText, boolean flag) {
        char[] chars = referenceText.toCharArray();
        int lessPos = chars.length;
        int count = 0;
        block5: for (int i = chars.length - 1; i >= 0; --i) {
            char aChar = chars[i];
            switch (aChar) {
                case ')': 
                case '>': {
                    ++count;
                    continue block5;
                }
                case '(': 
                case '<': {
                    --count;
                    lessPos = i;
                    continue block5;
                }
                case '.': 
                case '@': {
                    if (count != 0) continue block5;
                    return new String(chars, i + 1, lessPos - (i + 1)).trim();
                }
                default: {
                    if (count != 0 || Character.isWhitespace(aChar) || !flag || Character.isJavaIdentifierPart(aChar)) continue block5;
                    return PsiNameHelper.getShortClassName(PsiNameHelper.removeWhitespace(referenceText), false);
                }
            }
        }
        return new String(chars, 0, lessPos).trim();
    }

    public static String getPresentableText(PsiJavaCodeReferenceElement ref) {
        String referenceName = ref.getReferenceName();
        PsiType[] typeParameters = ref.getTypeParameters();
        if (typeParameters.length > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(referenceName);
            buffer.append("<");
            for (int i = 0; i < typeParameters.length; ++i) {
                buffer.append(typeParameters[i].getPresentableText());
                if (i >= typeParameters.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(">");
            return buffer.toString();
        }
        return referenceName != null ? referenceName : "";
    }

    public static String getQualifiedClassName(String referenceText, boolean removeWhitespace) {
        if (removeWhitespace) {
            referenceText = PsiNameHelper.removeWhitespace(referenceText);
        }
        if (referenceText.indexOf(60) < 0) {
            return referenceText;
        }
        StringBuilder buffer = new StringBuilder(referenceText.length());
        char[] chars = referenceText.toCharArray();
        int gtPos = 0;
        int count = 0;
        block4: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++count != 1) continue block4;
                    buffer.append(new String(chars, gtPos, i - gtPos));
                    continue block4;
                }
                case '>': {
                    --count;
                    gtPos = i + 1;
                }
            }
        }
        if (count == 0) {
            buffer.append(new String(chars, gtPos, chars.length - gtPos));
        }
        return buffer.toString();
    }

    private static String removeWhitespace(String referenceText) {
        return WHITESPACE_PATTERN.matcher(referenceText).replaceAll("");
    }

    public static String[] getClassParametersText(String referenceText) {
        if (referenceText.indexOf(60) < 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        referenceText = PsiNameHelper.removeWhitespace(referenceText);
        char[] chars = referenceText.toCharArray();
        int count = 0;
        int dim = 0;
        block10: for (char aChar : chars) {
            switch (aChar) {
                case '<': {
                    if (++count != 1) continue block10;
                    ++dim;
                    continue block10;
                }
                case ',': {
                    if (count != 1) continue block10;
                    ++dim;
                    continue block10;
                }
                case '>': {
                    --count;
                }
            }
        }
        if (count != 0 || dim == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[dim];
        dim = 0;
        int ltPos = 0;
        block11: for (int i = 0; i < chars.length; ++i) {
            char aChar;
            aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++count != 1) continue block11;
                    ltPos = i;
                    continue block11;
                }
                case ',': {
                    if (count != 1) continue block11;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                    ltPos = i;
                    continue block11;
                }
                case '>': {
                    if (--count != 0) continue block11;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                }
            }
        }
        return result;
    }

    public static String[] splitNameIntoWords(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiNameHelper.splitNameIntoWords must not be null");
        }
        String[] underlineDelimited = name.split("_");
        ArrayList<String> result = new ArrayList<String>();
        for (String word : underlineDelimited) {
            PsiNameHelper.addAllWords(word, result);
        }
        return result.toArray(new String[result.size()]);
    }

    private static void addAllWords(String word, List<String> result) {
        StringCharacterIterator it = new StringCharacterIterator(word);
        StringBuffer b = new StringBuffer();
        int state = 0;
        char curPrevUC = '\u0000';
        char c = it.first();
        while (c != '\uffff') {
            switch (state) {
                case 0: {
                    if (!Character.isUpperCase(c)) {
                        b.append(c);
                        state = 2;
                        break;
                    }
                    state = 1;
                    curPrevUC = c;
                    break;
                }
                case 1: {
                    if (!Character.isUpperCase(c)) {
                        b = PsiNameHelper.startNewWord(result, b, curPrevUC);
                        b.append(c);
                        state = 2;
                        break;
                    }
                    b.append(curPrevUC);
                    state = 1;
                    curPrevUC = c;
                    break;
                }
                case 2: {
                    if (Character.isUpperCase(c)) {
                        PsiNameHelper.startNewWord(result, b, c);
                        b.setLength(0);
                        state = 1;
                        curPrevUC = c;
                        break;
                    }
                    b.append(c);
                }
            }
            c = it.next();
        }
        if (state == 1) {
            b.append(curPrevUC);
        }
        result.add(b.toString());
    }

    private static StringBuffer startNewWord(List<String> result, StringBuffer b, char c) {
        if (b.length() > 0) {
            result.add(b.toString());
        }
        b = new StringBuffer();
        b.append(c);
        return b;
    }
}

