/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsiIntersectionType
extends PsiType {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.PsiIntersectionType");
    private final PsiType[] myConjuncts;

    private PsiIntersectionType(PsiType[] conjuncts) {
        LOG.assertTrue(conjuncts.length > 1);
        this.myConjuncts = conjuncts;
    }

    public PsiType[] getConjuncts() {
        return this.myConjuncts;
    }

    @Override
    public String getPresentableText() {
        return this.myConjuncts[0].getPresentableText();
    }

    @Override
    public String getCanonicalText() {
        return this.myConjuncts[0].getCanonicalText();
    }

    @Override
    public String getInternalCanonicalText() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.myConjuncts.length; ++i) {
            buffer.append(this.myConjuncts[i].getInternalCanonicalText());
            if (i >= this.myConjuncts.length - 1) continue;
            buffer.append(" & ");
        }
        return buffer.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiType conjunct : this.myConjuncts) {
            if (conjunct.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsToText(String text) {
        return false;
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return this.myConjuncts[0].accept(visitor);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myConjuncts[0].getResolveScope();
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        if (this.myConjuncts == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiIntersectionType.getSuperTypes must not return null");
        }
        return this.myConjuncts;
    }

    public static PsiType createIntersection(PsiType ... conjuncts) {
        LOG.assertTrue(conjuncts.length >= 1);
        if (conjuncts.length == 1) {
            return conjuncts[0];
        }
        return new PsiIntersectionType(conjuncts);
    }

    public PsiType getRepresentative() {
        return this.myConjuncts[0];
    }

    public boolean equals(Object obj) {
        PsiType[] second;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PsiIntersectionType)) {
            return false;
        }
        PsiType[] first = this.getConjuncts();
        if (first.length != (second = ((PsiIntersectionType)obj).getConjuncts()).length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i].equals(second[i])) continue;
            return false;
        }
        return true;
    }
}

